/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;

public class OptimizedConstructionInvocations
extends OptimizedBehaviourInvocations {
    protected static void addCopy(ClassPool pool, CtClass invocation, CtClass[] params) throws Exception {
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.ConstructionInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        String code = "{    " + invocation.getName() + " wrapper = new " + invocation.getName() + "(this.interceptors, this.constructor); " + "   wrapper.metadata = this.metadata; " + "   wrapper.currentInterceptor = this.currentInterceptor; ";
        for (int i = 0; i < params.length; ++i) {
            code = code + "   wrapper.arg" + i + " = this.arg" + i + "; ";
        }
        code = code + "   return wrapper; }";
        copy.setBody(code);
        invocation.addMethod(copy);
    }

    protected static String getOptimizedInvocationClassName(CtClass declaringClazz, int constructorIndex) {
        return declaringClazz.getName() + constructorIndex + "OptimizedConstructionInvocation";
    }

    protected static String createOptimizedInvocationClass(Instrumentor instrumentor, CtClass clazz, CtConstructor con, int index) throws Exception {
        CtClass invocation;
        boolean makeInnerClass;
        AOPClassPool pool = (AOPClassPool)instrumentor.getClassPool();
        CtClass conInvocation = pool.get("org.jboss.aop.joinpoint.ConstructionInvocation");
        CtClass untransformable = pool.get("org.jboss.aop.instrument.Untransformable");
        String className = OptimizedConstructionInvocations.getOptimizedInvocationClassName(clazz, index);
        boolean bl = makeInnerClass = !Modifier.isPublic((int)con.getModifiers());
        if (makeInnerClass) {
            String innerClassName = className.substring(className.lastIndexOf(46) + 1);
            boolean classStatic = true;
            invocation = TransformerCommon.makeNestedClass(clazz, innerClassName, classStatic);
            invocation.setSuperclass(conInvocation);
        } else {
            invocation = TransformerCommon.makeClass(pool, className, conInvocation);
        }
        invocation.addInterface(untransformable);
        CtConstructor template = null;
        CtConstructor[] tcons = conInvocation.getDeclaredConstructors();
        for (int i = 0; i < tcons.length; ++i) {
            if (tcons[i].getParameterTypes().length != 2) continue;
            template = tcons[i];
            break;
        }
        CtConstructor icon = CtNewConstructor.make((CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), (CtClass)invocation);
        invocation.addConstructor(icon);
        CtClass[] params = con.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            CtField field = new CtField(params[i], "arg" + i, invocation);
            field.setModifiers(1);
            invocation.addField(field);
        }
        OptimizedConstructionInvocations.addGetArguments(pool, invocation, con.getParameterTypes());
        OptimizedConstructionInvocations.addCopy(pool, invocation, con.getParameterTypes());
        TransformerCommon.compileOrLoadClass(con.getDeclaringClass(), invocation);
        return invocation.getName();
    }
}

