/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.MethodByConInfo;
import org.jboss.aop.advice.AdviceMethodProperties;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.JoinPointGenerator;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.OptimizedBehaviourInvocations;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
import org.jboss.aop.util.ReflectToJavassist;

public class MethodByConJoinPointGenerator
extends JoinPointGenerator {
    public static final String GENERATOR_PREFIX = "generator_CByM_";
    public static final String JOINPOINT_CLASS_PREFIX = "JoinPoint_CByM_";
    public static final String JOINPOINT_FIELD_PREFIX = "joinpoint_CByM_";
    private static final Class INVOCATION_TYPE = MethodCalledByConstructorInvocation.class;
    private static final CtClass INVOCATION_CT_TYPE;

    public MethodByConJoinPointGenerator(GeneratedClassAdvisor advisor, JoinPointInfo info) {
        super(advisor, info);
    }

    protected void initialiseJoinPointNames() {
        this.joinpointClassName = MethodByConJoinPointGenerator.getInfoClassName(this.callingIndex(), this.calledClass(), this.calledMethodHash());
        this.joinpointFieldName = MethodByConJoinPointGenerator.getInfoFieldName(this.callingIndex(), this.calledClass(), this.calledMethodHash());
    }

    private int callingIndex() {
        return ((MethodByConInfo)this.info).getCallingIndex();
    }

    private String calledClass() {
        return ((MethodByConInfo)this.info).getCalledClass().getName();
    }

    private long calledMethodHash() {
        return ((MethodByConInfo)this.info).getCalledMethodHash();
    }

    protected boolean isVoid() {
        return ((MethodByConInfo)this.info).getMethod().getReturnType().equals(Void.TYPE);
    }

    protected Class getReturnType() {
        if (this.isVoid()) {
            return null;
        }
        return ((MethodByConInfo)this.info).getMethod().getReturnType();
    }

    protected AdviceMethodProperties getAdviceMethodProperties(JoinPointGenerator.AdviceSetup setup) {
        Method method = ((MethodByConInfo)this.info).getMethod();
        return new AdviceMethodProperties(setup.getAspectClass(), setup.getAdviceName(), this.info.getClass(), INVOCATION_TYPE, method.getReturnType(), method.getParameterTypes(), method.getExceptionTypes());
    }

    protected boolean isCaller() {
        return true;
    }

    protected boolean hasCallingObject() {
        return false;
    }

    protected boolean hasTargetObject() {
        return !java.lang.reflect.Modifier.isStatic(((MethodByConInfo)this.info).getMethod().getModifiers());
    }

    protected static CtClass createJoinpointBaseClass(GeneratedAdvisorInstrumentor instrumentor, int callingIndex, CtClass callingClass, CtMethod targetMethod, String classname, long calledHash, String ciname) throws NotFoundException, CannotCompileException {
        instrumentor.addJoinPointGeneratorFieldToGenAdvisor(MethodByConJoinPointGenerator.getJoinPointGeneratorFieldName(callingIndex, classname, calledHash));
        BaseClassGenerator generator = new BaseClassGenerator(instrumentor, callingClass, callingIndex, classname, targetMethod, calledHash, ciname);
        return generator.generate();
    }

    protected String getJoinPointGeneratorFieldName() {
        return MethodByConJoinPointGenerator.getJoinPointGeneratorFieldName(this.callingIndex(), this.calledClass(), this.calledMethodHash());
    }

    protected static String getInfoClassName(int callingIndex, String classname, long calledHash) {
        return JOINPOINT_CLASS_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    protected static String getInfoFieldName(int callingIndex, String classname, long calledHash) {
        return JOINPOINT_FIELD_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    protected static String getJoinPointGeneratorFieldName(int callingIndex, String classname, long calledHash) {
        return GENERATOR_PREFIX + CallerTransformer.getUniqueInvocationFieldname(callingIndex, classname, calledHash);
    }

    static {
        try {
            INVOCATION_CT_TYPE = ReflectToJavassist.classToJavassist(INVOCATION_TYPE);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BaseClassGenerator {
        GeneratedAdvisorInstrumentor instrumentor;
        CtClass callingClass;
        int callingIndex;
        CtClass targetClass;
        String classname;
        CtMethod targetMethod;
        long calledHash;
        String ciname;
        boolean hasTargetObject;
        CtClass jp;
        CtMethod invokeJoinpointMethod;
        CtConstructor publicConstructor;
        CtConstructor protectedConstructor;
        CtField targetField;
        CtClass[] params;
        CtClass methodInfoClass;

        BaseClassGenerator(GeneratedAdvisorInstrumentor instrumentor, CtClass callingClass, int callingIndex, String classname, CtMethod targetMethod, long calledHash, String ciname) throws NotFoundException {
            this.instrumentor = instrumentor;
            this.callingClass = callingClass;
            this.callingIndex = callingIndex;
            this.classname = classname;
            this.targetClass = instrumentor.forName(classname);
            this.targetMethod = targetMethod;
            this.calledHash = calledHash;
            this.ciname = ciname;
            this.params = targetMethod.getParameterTypes();
            this.methodInfoClass = instrumentor.forName(CallerTransformer.METHOD_BY_CON_INFO_CLASS_NAME);
            this.hasTargetObject = !Modifier.isStatic((int)targetMethod.getModifiers());
        }

        protected CtClass generate() throws CannotCompileException, NotFoundException {
            this.jp = this.setupClass();
            this.addArgumentsFieldsAndAccessors();
            if (this.hasTargetObject) {
                this.addTypedTargetField();
            }
            this.addInvokeJoinpointMethod();
            this.addMethodInfoField();
            this.addPublicConstructor();
            this.addProtectedConstructor();
            this.addDispatchMethods();
            TransformerCommon.compileOrLoadClass(this.callingClass, this.jp);
            return this.jp;
        }

        private CtClass setupClass() throws NotFoundException, CannotCompileException {
            String className = MethodByConJoinPointGenerator.getInfoClassName(this.callingIndex, this.targetClass.getName(), this.calledHash);
            this.jp = TransformerCommon.makeNestedClass(this.callingClass, className, true);
            int mod = this.jp.getModifiers();
            this.jp.setModifiers(mod | 1);
            CtClass invocation = INVOCATION_CT_TYPE;
            this.jp.setSuperclass(invocation);
            JoinPointGenerator.addUntransformableInterface(this.instrumentor, this.jp);
            return this.jp;
        }

        private void addArgumentsFieldsAndAccessors() throws NotFoundException, CannotCompileException {
            OptimizedBehaviourInvocations.addArgumentFieldsToInvocation(this.jp, this.params);
            OptimizedBehaviourInvocations.addSetArguments(this.instrumentor.getClassPool(), this.jp, this.params);
            OptimizedBehaviourInvocations.addGetArguments(this.instrumentor.getClassPool(), this.jp, this.params);
        }

        private void addTypedTargetField() throws CannotCompileException {
            this.targetField = new CtField(this.targetClass, "tgt", this.jp);
            this.jp.addField(this.targetField);
            this.targetField.setModifiers(4);
        }

        private void addPublicConstructor() throws CannotCompileException {
            this.publicConstructor = CtNewConstructor.make((CtClass[])new CtClass[]{this.methodInfoClass}, (CtClass[])new CtClass[0], (CtClass)this.jp);
            this.publicConstructor.setBody("{super($1, null, $1.getInterceptors()); this.info = $1;}");
            this.jp.addConstructor(this.publicConstructor);
        }

        protected void addProtectedConstructor() throws CannotCompileException {
            int offset = this.hasTargetObject ? 2 : 1;
            CtClass[] ctorParams = new CtClass[this.params.length + offset];
            ctorParams[0] = this.jp;
            if (this.hasTargetObject) {
                ctorParams[1] = this.targetClass;
            }
            System.arraycopy(this.params, 0, ctorParams, offset, this.params.length);
            this.protectedConstructor = CtNewConstructor.make((CtClass[])ctorParams, (CtClass[])new CtClass[0], (CtClass)this.jp);
            this.protectedConstructor.setModifiers(4);
            StringBuffer body = new StringBuffer();
            body.append("{");
            body.append("   this($1.info);");
            if (this.hasTargetObject) {
                body.append("   super.targetObject=$2;");
                body.append("   this.tgt=$2;");
            }
            for (int i = offset; i < ctorParams.length; ++i) {
                body.append("   arg" + (i - offset) + " = $" + (i + 1) + ";");
            }
            body.append("}");
            this.protectedConstructor.setBody(body.toString());
            this.jp.addConstructor(this.protectedConstructor);
        }

        private CtClass[] getInvokeJoinPointParameters() {
            if (this.hasTargetObject) {
                CtClass[] invokeParams = new CtClass[this.params.length + 1];
                invokeParams[0] = this.targetClass;
                System.arraycopy(this.params, 0, invokeParams, 1, this.params.length);
                return invokeParams;
            }
            return this.params;
        }

        private CtMethod addInvokeJoinpointMethod() throws CannotCompileException, NotFoundException {
            Object invokeParams = null;
            this.invokeJoinpointMethod = CtNewMethod.make((CtClass)this.targetMethod.getReturnType(), (String)"invokeJoinpoint", (CtClass[])this.getInvokeJoinPointParameters(), (CtClass[])this.targetMethod.getExceptionTypes(), null, (CtClass)this.jp);
            this.invokeJoinpointMethod.setModifiers(4);
            this.jp.addMethod(this.invokeJoinpointMethod);
            return this.invokeJoinpointMethod;
        }

        private void addMethodInfoField() throws CannotCompileException {
            CtField infoField = new CtField(this.methodInfoClass, "info", this.jp);
            this.jp.addField(infoField);
        }

        private void addDispatchMethods() throws CannotCompileException, NotFoundException {
            this.addInvokeNextDispatchMethod();
            if (this.hasTargetObject || this.params.length > 0) {
                this.addInvokeJoinPointDispatchMethod();
            }
        }

        private void addInvokeNextDispatchMethod() throws CannotCompileException, NotFoundException {
            boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
            CtMethod dispatch = CtNewMethod.make((CtClass)(isVoid ? CtClass.voidType : this.targetMethod.getReturnType()), (String)"dispatch", (CtClass[])new CtClass[0], (CtClass[])this.targetMethod.getExceptionTypes(), null, (CtClass)this.jp);
            dispatch.setModifiers(4);
            StringBuffer parameters = new StringBuffer();
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("arg" + i);
            }
            StringBuffer body = new StringBuffer("{");
            if (Modifier.isStatic((int)this.targetMethod.getModifiers())) {
                body.append(MethodExecutionTransformer.getReturnStr(isVoid) + this.targetClass.getName() + "." + this.targetMethod.getName() + "(" + parameters + ");");
            } else {
                body.append(MethodExecutionTransformer.getAopReturnStr(isVoid) + "tgt" + "." + this.targetMethod.getName() + "(" + parameters + ");");
            }
            body.append("}");
            try {
                dispatch.setBody(body.toString());
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            this.jp.addMethod(dispatch);
        }

        private void addInvokeJoinPointDispatchMethod() throws CannotCompileException, NotFoundException {
            boolean isVoid = this.targetMethod.getReturnType().equals(CtClass.voidType);
            CtMethod dispatch = CtNewMethod.make((CtClass)(isVoid ? CtClass.voidType : this.targetMethod.getReturnType()), (String)"dispatch", (CtClass[])this.getInvokeJoinPointParameters(), (CtClass[])this.targetMethod.getExceptionTypes(), null, (CtClass)this.jp);
            dispatch.setModifiers(4);
            int offset = this.hasTargetObject ? 1 : 0;
            StringBuffer parameters = new StringBuffer();
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    parameters.append(", ");
                }
                parameters.append("$" + (i + offset + 1));
            }
            StringBuffer body = new StringBuffer("{");
            if (Modifier.isStatic((int)this.targetMethod.getModifiers())) {
                body.append(MethodExecutionTransformer.getReturnStr(isVoid) + this.targetClass.getName() + "." + this.targetMethod.getName() + "(" + parameters + ");");
            } else {
                body.append(MethodExecutionTransformer.getAopReturnStr(isVoid) + "$1." + this.targetMethod.getName() + "(" + parameters + ");");
            }
            body.append("}");
            try {
                dispatch.setBody(body.toString());
            }
            catch (CannotCompileException e) {
                throw new RuntimeException("Could not compile code " + body + " for method " + dispatch, e);
            }
            this.jp.addMethod(dispatch);
        }
    }
}

