/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.CFlowInterceptor;
import org.jboss.aop.advice.GenericInterceptorFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.InterceptorFactoryWrapper;
import org.jboss.aop.advice.PerInstanceInterceptor;
import org.jboss.aop.advice.PerJoinpointInterceptor;
import org.jboss.aop.advice.PrecedenceDef;
import org.jboss.aop.advice.PrecedenceDefEntry;

public class PrecedenceSorter {
    static Comparator interceptorComparator = new Comparator(){

        public int compare(Object objA, Object objB) {
            InterceptorEntry entryA = (InterceptorEntry)objA;
            InterceptorEntry entryB = (InterceptorEntry)objB;
            return entryA.precedenceOrder - entryB.precedenceOrder;
        }
    };

    private static boolean matches(InterceptorEntry ientry, PrecedenceDefEntry pentry) {
        if (ientry.classname.equals(pentry.interceptorClass)) {
            if (ientry.method == null) {
                if (pentry.adviceMethod == null) {
                    return true;
                }
            } else if (pentry.adviceMethod != null) {
                return ientry.method.equals(pentry.adviceMethod);
            }
        }
        return false;
    }

    public static PrecedenceDefEntry[] createOverallPrecedence(AspectManager manager) {
        ArrayList overall = new ArrayList();
        LinkedHashMap precedenceDefs = manager.getPrecedenceDefs();
        boolean first = true;
        Iterator it = precedenceDefs.values().iterator();
        while (it.hasNext()) {
            PrecedenceDef precedenceDef = (PrecedenceDef)it.next();
            PrecedenceDefEntry[] entries = precedenceDef.getEntries();
            if (first) {
                for (int i = 0; i < entries.length; ++i) {
                    overall.add(entries[i]);
                }
                first = false;
                continue;
            }
            overall = PrecedenceSorter.mergePrecedenceDef(overall, precedenceDef);
        }
        return overall.toArray(new PrecedenceDefEntry[overall.size()]);
    }

    public static ArrayList mergePrecedenceDef(ArrayList overall, PrecedenceDef precedenceDef) {
        PrecedenceDefEntry[] entries = precedenceDef.getEntries();
        int start = 0;
        int end = 0;
        int size = overall.size();
        for (int i = 0; i < size; ++i) {
            PrecedenceDefEntry global = (PrecedenceDefEntry)overall.get(i);
            boolean found = false;
            for (int j = start; j < entries.length; ++j) {
                PrecedenceDefEntry cur = entries[j];
                if (!cur.equals(global)) continue;
                found = true;
                end = j;
                break;
            }
            if (!found) continue;
            int insert = i;
            for (int j = start; j < end; ++j) {
                overall.add(insert++, entries[j]);
            }
            start = ++end;
        }
        for (int j = start; j < entries.length; ++j) {
            overall.add(entries[j]);
        }
        return overall;
    }

    public static Interceptor[] applyPrecedence(Interceptor[] interceptors, AspectManager manager) {
        if (interceptors.length == 0) {
            return interceptors;
        }
        ArrayList<InterceptorEntry> all = new ArrayList<InterceptorEntry>(interceptors.length);
        ArrayList<InterceptorEntry> precedence = new ArrayList<InterceptorEntry>(interceptors.length);
        PrecedenceDefEntry[] precedenceEntries = manager.getSortedPrecedenceDefEntries();
        block0: for (int i = 0; i < interceptors.length; ++i) {
            InterceptorEntry interceptorEntry = new InterceptorEntry(interceptors[i]);
            all.add(interceptorEntry);
            for (int j = 0; j < precedenceEntries.length; ++j) {
                if (!PrecedenceSorter.matches(interceptorEntry, precedenceEntries[j])) continue;
                interceptorEntry.originalOrder = i;
                interceptorEntry.precedenceOrder = j;
                precedence.add(interceptorEntry);
                continue block0;
            }
        }
        Collections.sort(precedence, interceptorComparator);
        Interceptor[] sortedInterceptors = new Interceptor[interceptors.length];
        int prec = 0;
        int allSize = all.size();
        int precedenceSize = precedence.size();
        for (int i = 0; i < allSize; ++i) {
            InterceptorEntry entry = (InterceptorEntry)all.get(i);
            if (entry.precedenceOrder >= 0 && prec < precedenceSize) {
                entry = (InterceptorEntry)precedence.get(prec++);
            }
            sortedInterceptors[i] = entry.interceptor;
        }
        return sortedInterceptors;
    }

    public static InterceptorFactoryWrapper[] applyPrecedence(InterceptorFactoryWrapper[] interceptors, AspectManager manager) {
        ArrayList<InterceptorEntry> all = new ArrayList<InterceptorEntry>(interceptors.length);
        ArrayList<InterceptorEntry> precedence = new ArrayList<InterceptorEntry>(interceptors.length);
        PrecedenceDefEntry[] precedenceEntries = manager.getSortedPrecedenceDefEntries();
        block0: for (int i = 0; i < interceptors.length; ++i) {
            InterceptorEntry interceptorEntry = new InterceptorEntry(interceptors[i]);
            all.add(interceptorEntry);
            for (int j = 0; j < precedenceEntries.length; ++j) {
                if (!PrecedenceSorter.matches(interceptorEntry, precedenceEntries[j])) continue;
                interceptorEntry.originalOrder = i;
                interceptorEntry.precedenceOrder = j;
                precedence.add(interceptorEntry);
                continue block0;
            }
        }
        Collections.sort(precedence, interceptorComparator);
        InterceptorFactoryWrapper[] sortedInterceptors = new InterceptorFactoryWrapper[interceptors.length];
        int prec = 0;
        int allSize = all.size();
        int precedenceSize = precedence.size();
        for (int i = 0; i < allSize; ++i) {
            InterceptorEntry entry = (InterceptorEntry)all.get(i);
            if (entry.precedenceOrder >= 0 && prec < precedenceSize) {
                entry = (InterceptorEntry)precedence.get(prec++);
            }
            sortedInterceptors[i] = entry.factoryWrapper;
        }
        return sortedInterceptors;
    }

    static class InterceptorEntry {
        Interceptor interceptor;
        InterceptorFactoryWrapper factoryWrapper;
        int originalOrder;
        int precedenceOrder = -1;
        String classname;
        String method;

        InterceptorEntry(InterceptorFactoryWrapper factoryWrapper) {
            this.factoryWrapper = factoryWrapper;
            this.classname = factoryWrapper.getName();
            InterceptorFactory ifac = factoryWrapper.getDelegate();
            if (ifac instanceof GenericInterceptorFactory) {
                this.classname = ((GenericInterceptorFactory)ifac).getClassName();
            } else {
                AspectFactory af = factoryWrapper.getAspect().getFactory();
                this.classname = af.getName();
            }
            if (ifac instanceof AdviceFactory) {
                this.method = ((AdviceFactory)ifac).getAdvice();
            }
        }

        InterceptorEntry(Interceptor interceptor) {
            Interceptor icptr;
            this.interceptor = interceptor;
            String interceptorName = null;
            if (interceptor instanceof PerInstanceInterceptor) {
                icptr = (PerInstanceInterceptor)interceptor;
                interceptorName = ((PerInstanceInterceptor)icptr).getName();
            } else if (interceptor instanceof PerJoinpointInterceptor) {
                icptr = (PerJoinpointInterceptor)interceptor;
                interceptorName = ((PerJoinpointInterceptor)icptr).getName();
            } else if (interceptor instanceof CFlowInterceptor) {
                icptr = (CFlowInterceptor)interceptor;
                interceptorName = ((CFlowInterceptor)icptr).getName();
            } else {
                interceptorName = interceptor.getClass().getName();
            }
            try {
                boolean isAdvice = interceptorName.startsWith("org.jboss.aop.advice.");
                if (isAdvice) {
                    String name = interceptor.getName();
                    int index = name.lastIndexOf(".");
                    this.classname = name.substring(0, index);
                    this.method = name.substring(index + 1);
                } else {
                    this.classname = interceptorName;
                }
            }
            catch (RuntimeException e) {
                System.err.print(interceptor.getName());
                throw e;
            }
        }

        public String toString() {
            return "Entry: " + this.precedenceOrder + " (" + this.originalOrder + ")interceptorClass=" + this.classname + "; adviceMethod=" + this.method;
        }
    }
}

