/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.GeneratedClassAdvisor;
import org.jboss.aop.GeneratedInstanceAdvisorMixin;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AdviceFactory;
import org.jboss.aop.advice.AfterFactory;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.AspectFactoryDelegator;
import org.jboss.aop.advice.BeforeFactory;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.advice.GenericInterceptorFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopedInterceptorFactory;
import org.jboss.aop.advice.ThrowingFactory;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;

public class InterceptorFactoryWrapper {
    InterceptorFactory factory;
    volatile Object instance;
    String cflowString;
    ASTCFlowExpression cflowExpression;

    public InterceptorFactoryWrapper(InterceptorFactory factory, GeneratedClassAdvisor advisor, Joinpoint joinpoint, String cflowString, ASTCFlowExpression cflowExpr) {
        this(factory, advisor, joinpoint);
        this.cflowString = cflowString;
        this.cflowExpression = cflowExpr;
    }

    public InterceptorFactoryWrapper(InterceptorFactory factory, GeneratedClassAdvisor advisor, Joinpoint joinpoint) {
        this.factory = factory;
        if (!(factory instanceof GenericInterceptorFactory)) {
            if (this.getScope() == Scope.PER_INSTANCE) {
                if (!advisor.getPerInstanceAspectDefinitions().contains(factory.getAspect())) {
                    advisor.addPerInstanceAspect(factory.getAspect());
                }
            } else if (this.getScope() == Scope.PER_JOINPOINT) {
                advisor.addPerInstanceJoinpointAspect(joinpoint, factory.getAspect());
            } else if (this.getScope() == Scope.PER_CLASS_JOINPOINT && advisor.getPerClassJoinpointAspect(factory.getAspect(), joinpoint) == null) {
                advisor.addPerClassJoinpointAspect(factory.getAspect(), joinpoint);
            }
        }
    }

    public Interceptor create(Advisor advisor, Joinpoint joinpoint) {
        return this.factory.create(advisor, joinpoint);
    }

    public Object getAspect(Advisor advisor, Joinpoint joinpoint) {
        return this.getAspect(advisor, joinpoint, false);
    }

    public Object getAspect(Advisor advisor, Joinpoint joinpoint, boolean forCodeGeneration) {
        if (this.factory instanceof GenericInterceptorFactory) {
            if (this.instance == null) {
                this.instance = ((GenericInterceptorFactory)this.factory).create(advisor, joinpoint);
            }
            return this.instance;
        }
        if (this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory) {
            return ((GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory)this.factory).create(advisor, joinpoint);
        }
        if (this.factory instanceof ScopedInterceptorFactory || this.factory instanceof AdviceFactory) {
            ClassInstanceAdvisor temp = forCodeGeneration ? new ClassInstanceAdvisor(advisor) : null;
            return this.getAspectInstance(this.factory.getAspect(), advisor, joinpoint, temp);
        }
        return null;
    }

    public Object getPerInstanceAspect(Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia) {
        if (this.factory instanceof GenericInterceptorFactory) {
            if (this.instance == null) {
                this.instance = ((GenericInterceptorFactory)this.factory).create(advisor, joinpoint);
            }
            return this.instance;
        }
        if (this.factory instanceof ScopedInterceptorFactory || this.factory instanceof AdviceFactory) {
            return this.getAspectInstance(this.factory.getAspect(), advisor, joinpoint, ia);
        }
        return null;
    }

    private Object getAspectInstance(AspectDefinition def, Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia) {
        if (def.getScope() == Scope.PER_VM) {
            if (this.instance == null) {
                this.instance = advisor.getManager().getPerVMAspect(def);
            }
            return this.instance;
        }
        if (def.getScope() == Scope.PER_CLASS) {
            if (this.instance == null) {
                this.instance = advisor.getPerClassAspect(def);
                if (this.instance != null) {
                    return this.instance;
                }
                advisor.addPerClassAspect(def);
                this.instance = advisor.getPerClassAspect(def);
            }
            return this.instance;
        }
        if (def.getScope() == Scope.PER_INSTANCE) {
            return this.getPerInstanceAspect(def, advisor, joinpoint, ia);
        }
        if (def.getScope() == Scope.PER_JOINPOINT) {
            return this.getPerJoinPointAspect(def, advisor, joinpoint, ia);
        }
        if (def.getScope() == Scope.PER_CLASS_JOINPOINT) {
            if (this.instance == null) {
                this.instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(def, joinpoint);
                if (this.instance != null) {
                    return this.instance;
                }
                ((GeneratedClassAdvisor)advisor).addPerClassJoinpointAspect(def, joinpoint);
                this.instance = ((GeneratedClassAdvisor)advisor).getPerClassJoinpointAspect(def, joinpoint);
            }
            return this.instance;
        }
        return null;
    }

    private Object getPerJoinPointAspect(AspectDefinition def, Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia) {
        if (ia == null) {
            if (this.instance == null) {
                Field field;
                if (AspectManager.verbose) {
                    System.out.println("[info] Calling create on PER_JOINPOINT scoped AspectFactory with no InstanceAdvisor as part of setup");
                }
                if (joinpoint instanceof FieldJoinpoint && Modifier.isStatic((field = ((FieldJoinpoint)joinpoint).getField()).getModifiers())) {
                    this.instance = ((ClassAdvisor)advisor).getFieldAspect((FieldJoinpoint)joinpoint, def);
                }
                if (this.instance == null) {
                    this.instance = def.getFactory().createPerJoinpoint(advisor, ia, joinpoint);
                }
            }
            return this.instance;
        }
        return ia.getPerInstanceJoinpointAspect(joinpoint, def);
    }

    private Object getPerInstanceAspect(AspectDefinition def, Advisor advisor, Joinpoint joinpoint, InstanceAdvisor ia) {
        if (ia == null) {
            if (AspectManager.verbose) {
                System.out.println("[info] Calling create on PER_INSTANCE scoped AspectFactory with no InstanceAdvisor as part of setup");
            }
            return def.getFactory().createPerInstance(advisor, ia);
        }
        return ia.getPerInstanceAspect(def);
    }

    public boolean isAspectFactory() {
        if (this.factory instanceof GenericInterceptorFactory || this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory) {
            return false;
        }
        return !(this.factory.getAspect().getFactory() instanceof GenericAspectFactory);
    }

    public InterceptorFactory getDelegate() {
        return this.factory;
    }

    public AspectDefinition getAspect() {
        return this.factory.getAspect();
    }

    public String getName() {
        return this.factory.getName();
    }

    public String getAspectClassName() {
        if (this.factory instanceof GenericInterceptorFactory) {
            return ((GenericInterceptorFactory)this.factory).getClassName();
        }
        if (this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory) {
            return ((GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory)this.factory).getClassName();
        }
        AspectFactory af = this.factory.getAspect().getFactory();
        if (af instanceof AspectFactoryDelegator) {
            return ((AspectFactoryDelegator)af).getName();
        }
        return ((GenericAspectFactory)af).getName();
    }

    public boolean isBefore() {
        return this.factory instanceof BeforeFactory;
    }

    public boolean isAfter() {
        return this.factory instanceof AfterFactory;
    }

    public boolean isThrowing() {
        return this.factory instanceof ThrowingFactory;
    }

    public boolean isAround() {
        return !this.isBefore() && !this.isAfter() && !this.isThrowing();
    }

    public boolean isInterceptor() {
        return !(this.factory instanceof AdviceFactory);
    }

    public String getAdviceName() {
        if (this.factory instanceof AdviceFactory) {
            return ((AdviceFactory)this.factory).getAdvice();
        }
        return "invoke";
    }

    public Scope getScope() {
        if (this.factory instanceof GenericInterceptorFactory || this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory) {
            return null;
        }
        return this.factory.getAspect().getScope();
    }

    public String getRegisteredName() {
        if (this.factory instanceof GenericInterceptorFactory || this.factory instanceof GeneratedInstanceAdvisorMixin.InstanceInterceptorFactory) {
            return null;
        }
        return this.factory.getAspect().getName();
    }

    public ASTCFlowExpression getCflowExpression() {
        return this.cflowExpression;
    }

    public String getCFlowString() {
        return this.cflowString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InterceptorFactoryWrapper)) {
            return false;
        }
        return this.factory.equals(((InterceptorFactoryWrapper)obj).getDelegate());
    }
}

