/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.security.jacc.URLPatternSpec;
import javax.servlet.http.HttpServletRequest;
import org.jboss.util.id.SerialVersion;

public final class WebResourcePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID;
    private static TreeSet ALL_HTTP_METHODS;
    private static final ObjectStreamField[] serialPersistentFields;
    private transient URLPatternSpec urlSpec;
    private transient String httpMethodsString;
    private transient TreeSet httpMethods;

    public WebResourcePermission(HttpServletRequest request) {
        this(WebResourcePermission.requestURI(request), request.getMethod());
    }

    public WebResourcePermission(String name, String actions) {
        super(name == null ? "/" : name);
        if (name == null) {
            name = "/";
        }
        this.urlSpec = new URLPatternSpec(name);
        this.parseActions(actions);
    }

    public WebResourcePermission(String urlPatternSpec, String[] httpMethods) {
        super(urlPatternSpec);
        this.urlSpec = new URLPatternSpec(urlPatternSpec);
        Object[] methodInfo = WebResourcePermission.canonicalMethods(httpMethods);
        this.httpMethods = (TreeSet)methodInfo[0];
        this.httpMethodsString = (String)methodInfo[1];
    }

    public boolean equals(Object p) {
        boolean equals = false;
        if (p == null || !(p instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission perm = (WebResourcePermission)p;
        equals = this.urlSpec.equals(perm.urlSpec);
        if (equals) {
            String a0 = this.getActions();
            String a1 = perm.getActions();
            equals = a0 != null && a0.equals(a1) || a0 == a1;
        }
        return equals;
    }

    public String getActions() {
        return this.httpMethodsString;
    }

    public int hashCode() {
        int hashCode = this.urlSpec.hash();
        if (this.httpMethods != null) {
            hashCode += this.httpMethods.hashCode();
        }
        return hashCode;
    }

    public boolean implies(Permission p) {
        if (p == null || !(p instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission perm = (WebResourcePermission)p;
        boolean implies = this.urlSpec.implies(perm.urlSpec);
        if (implies && this.httpMethods != null) {
            implies = this.httpMethods.containsAll(perm.httpMethods);
        }
        return implies;
    }

    static String requestURI(HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (uri != null) {
            int length;
            String contextPath = request.getContextPath();
            int n = length = contextPath == null ? 0 : contextPath.length();
            if (length > 0) {
                uri = uri.substring(length);
            }
            if (uri.equals("/")) {
                uri = "";
            }
        } else {
            uri = "";
        }
        return uri;
    }

    static Object[] canonicalMethods(String[] methods) {
        TreeSet<String> actions = new TreeSet<String>();
        int length = methods != null ? methods.length : 0;
        for (int n = 0; n < length; ++n) {
            actions.add(methods[n]);
        }
        return WebResourcePermission.canonicalMethods(actions);
    }

    static Object[] canonicalMethods(String methods) {
        if (methods == null || methods.length() == 0) {
            return new Object[]{ALL_HTTP_METHODS, null};
        }
        StringTokenizer tokenizer = new StringTokenizer(methods, ",");
        TreeSet<String> actions = new TreeSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String action = tokenizer.nextToken();
            actions.add(action);
        }
        return WebResourcePermission.canonicalMethods(actions);
    }

    static Object[] canonicalMethods(TreeSet actions) {
        Object[] info = new Object[]{null, null};
        if (actions.equals(ALL_HTTP_METHODS) || actions.size() == 0) {
            return info;
        }
        info[0] = actions;
        Iterator iter = actions.iterator();
        StringBuffer tmp = new StringBuffer();
        while (iter.hasNext()) {
            tmp.append(iter.next());
            tmp.append(',');
        }
        if (tmp.length() > 0) {
            tmp.setLength(tmp.length() - 1);
        }
        info[1] = tmp.toString();
        return info;
    }

    private void parseActions(String actions) {
        Object[] methodInfo = WebResourcePermission.canonicalMethods(actions);
        this.httpMethods = (TreeSet)methodInfo[0];
        this.httpMethodsString = (String)methodInfo[1];
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        String actions = (String)fields.get("actions", null);
        this.parseActions(actions);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        fields.put("actions", this.getActions());
        oos.writeFields();
    }

    static {
        ALL_HTTP_METHODS = new TreeSet();
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
        ALL_HTTP_METHODS.add("GET");
        ALL_HTTP_METHODS.add("POST");
        ALL_HTTP_METHODS.add("PUT");
        ALL_HTTP_METHODS.add("DELETE");
        ALL_HTTP_METHODS.add("HEAD");
        ALL_HTTP_METHODS.add("OPTIONS");
        ALL_HTTP_METHODS.add("TRACE");
        serialVersionUID = SerialVersion.version == 0 ? 141000L : 1L;
    }
}

