/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.StringMonitorMBean;
import org.jboss.mx.util.MonitorCallback;
import org.jboss.mx.util.MonitorRunnable;
import org.jboss.mx.util.ObservedObject;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    int STRING_MATCHES_NOTIFIED = 16;
    int STRING_DIFFERS_NOTIFIED = 32;
    String stringToCompare = new String();
    boolean notifyMatch = false;
    boolean notifyDiffer = false;
    private MonitorRunnable monitorRunnable;

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[1];
        String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.string.matches", "jmx.monitor.string.differs"};
        result[0] = new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the String Monitor Service MBean");
        return result;
    }

    public String getDerivedGauge() {
        ObservedObject object = this.getFirstObservedObject();
        if (object != null) {
            return (String)object.getDerivedGauge();
        }
        return null;
    }

    public String getDerivedGauge(ObjectName name) {
        ObservedObject object = this.retrieveObservedObject(name);
        if (object != null) {
            return (String)object.getDerivedGauge();
        }
        return null;
    }

    public long getDerivedGaugeTimeStamp() {
        ObservedObject object = this.getFirstObservedObject();
        if (object != null) {
            return object.getDerivedGaugeTimeStamp();
        }
        return 0L;
    }

    public long getDerivedGaugeTimeStamp(ObjectName name) {
        ObservedObject object = this.retrieveObservedObject(name);
        if (object != null) {
            return object.getDerivedGaugeTimeStamp();
        }
        return 0L;
    }

    public String getStringToCompare() {
        return this.stringToCompare;
    }

    public void setStringToCompare(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null string to compare.");
        }
        this.stringToCompare = value;
    }

    public boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    public void setNotifyMatch(boolean value) {
        this.notifyMatch = value;
    }

    public boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    public void setNotifyDiffer(boolean value) {
        this.notifyDiffer = value;
    }

    public synchronized void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        Iterator i = this.retrieveObservedObjects().values().iterator();
        while (i.hasNext()) {
            ObservedObject object = (ObservedObject)i.next();
            this.initObservedObject(object);
        }
        MonitorCallback callback = new MonitorCallback(){

            public void monitorCallback(ObservedObject object, MBeanAttributeInfo attributeInfo, Object value) throws Exception {
                StringMonitor.this.monitor(object, attributeInfo, value);
            }

            public MonitorNotification createNotification(String type, Object source, long timeStamp, String message, Object derivedGauge, String observedAttribute, ObjectName observedObject, Object trigger) {
                return new MonitorNotification(type, source, StringMonitor.this.nextSeqNo(), timeStamp, message, derivedGauge, observedAttribute, observedObject, trigger);
            }
        };
        this.monitorRunnable = new MonitorRunnable(this, this.objectName, callback, (Map)this.observedObjects, this.server);
    }

    public synchronized void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.monitorRunnable.setScheduler(null);
        this.monitorRunnable = null;
    }

    void initObservedObject(ObservedObject object) {
        super.initObservedObject(object);
        object.setDerivedGauge(new String());
    }

    void monitor(ObservedObject object, MBeanAttributeInfo attributeInfo, Object value) throws Exception {
        if (!(value instanceof String)) {
            this.sendAttributeTypeErrorNotification(object, "Not a string attribute");
            return;
        }
        object.setDerivedGauge(value);
        object.setDerivedGaugeTimeStamp(System.currentTimeMillis());
        if (value.equals(this.stringToCompare)) {
            this.sendStringMatchesNotification(object, (String)value);
        } else {
            this.sendStringDiffersNotification(object, (String)value);
        }
    }

    void sendStringMatchesNotification(ObservedObject object, String value) {
        if (this.notifyMatch && object.notAlreadyNotified(this.STRING_MATCHES_NOTIFIED)) {
            this.sendNotification(object, "jmx.monitor.string.matches", object.getDerivedGaugeTimeStamp(), "matches", this.observedAttribute, value, this.stringToCompare);
        }
        object.setNotAlreadyNotified(this.STRING_DIFFERS_NOTIFIED);
    }

    void sendStringDiffersNotification(ObservedObject object, String value) {
        if (this.notifyDiffer && object.notAlreadyNotified(this.STRING_DIFFERS_NOTIFIED)) {
            this.sendNotification(object, "jmx.monitor.string.differs", object.getDerivedGaugeTimeStamp(), "differs", this.observedAttribute, value, this.stringToCompare);
        }
        object.setNotAlreadyNotified(this.STRING_MATCHES_NOTIFIED);
    }
}

