/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.lang.StringUtils;
import org.milyn.schema.ediMessageMapping10.DelimitersDocument;
import org.xml.sax.InputSource;

class BufferedSegmentReader {
    private Reader reader;
    private StringBuffer segmentBuffer = new StringBuffer(512);
    private String[] currentSegmentFields = null;
    private int currentSegmentNumber = 0;
    private DelimitersDocument.Delimiters delimiters;
    private char[] segmentDelimiter;

    protected BufferedSegmentReader(InputSource ediInputSource, DelimitersDocument.Delimiters delimiters) {
        this.reader = ediInputSource.getCharacterStream();
        if (this.reader == null) {
            this.reader = new InputStreamReader(ediInputSource.getByteStream());
        }
        this.delimiters = delimiters;
        this.segmentDelimiter = delimiters.getSegment().toCharArray();
    }

    protected boolean moveToNextSegment() throws IOException {
        int c = this.reader.read();
        int delimiterLen = this.segmentDelimiter.length;
        this.segmentBuffer.setLength(0);
        this.currentSegmentFields = null;
        if (c == -1) {
            return false;
        }
        while (c != -1) {
            this.segmentBuffer.append((char)c);
            int segLen = this.segmentBuffer.length();
            if (segLen >= delimiterLen) {
                boolean reachedSegEnd = true;
                for (int i = 0; i < delimiterLen; ++i) {
                    char delimChar;
                    char segChar = this.segmentBuffer.charAt(segLen - 1 - i);
                    if (segChar == (delimChar = this.segmentDelimiter[delimiterLen - 1 - i])) continue;
                    reachedSegEnd = false;
                    break;
                }
                if (reachedSegEnd) {
                    this.segmentBuffer.setLength(segLen - delimiterLen);
                    break;
                }
            }
            c = this.reader.read();
        }
        ++this.currentSegmentNumber;
        return true;
    }

    public boolean hasCurrentSegment() {
        return this.segmentBuffer.length() != 0;
    }

    protected String getCurrentSegment() throws IllegalStateException {
        this.assertCurrentSegmentExists();
        return this.segmentBuffer.toString();
    }

    protected String[] getCurrentSegmentFields() throws IllegalStateException {
        int endIndex;
        this.assertCurrentSegmentExists();
        if (this.currentSegmentFields == null) {
            this.currentSegmentFields = StringUtils.splitPreserveAllTokens((String)this.segmentBuffer.toString(), (String)this.delimiters.getField());
        }
        if (this.delimiters.getSegment().equals("\n") && this.currentSegmentFields[endIndex = this.currentSegmentFields.length - 1].endsWith("\r")) {
            int stringLen = this.currentSegmentFields[endIndex].length();
            this.currentSegmentFields[endIndex] = this.currentSegmentFields[endIndex].substring(0, stringLen - 1);
        }
        return this.currentSegmentFields;
    }

    public int getCurrentSegmentNumber() {
        return this.currentSegmentNumber;
    }

    private void assertCurrentSegmentExists() {
        if (!this.hasCurrentSegment()) {
            throw new IllegalStateException("No current segment available.  Possible conditions: \n\t\t1. A call to moveToNextSegment() was not made, or \n\t\t2. The last call to moveToNextSegment() returned false.");
        }
    }
}

