/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.classpool;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.scopedpool.ScopedClassPool;
import javassist.scopedpool.ScopedClassPoolRepository;
import org.jboss.aop.AspectManager;
import org.jboss.aop.classpool.AOPClassPoolRepository;

public class AOPClassPool
extends ScopedClassPool {
    protected ConcurrentReaderHashMap generatedClasses = new ConcurrentReaderHashMap();
    protected ConcurrentReaderHashMap localResources = new ConcurrentReaderHashMap();

    public AOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        this(cl, src, repository, false);
    }

    protected AOPClassPool(ClassPool src, ScopedClassPoolRepository repository) {
        this(null, src, repository, true);
    }

    private AOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, boolean isTemp) {
        super(cl, src, repository, isTemp);
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = new WeakReference<ClassLoader>(cl);
    }

    public void registerGeneratedClass(String className) {
        this.generatedClasses.put((Object)className, (Object)className);
    }

    public void close() {
        super.close();
        AOPClassPoolRepository.getInstance().perfomUnregisterClassLoader(this.getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CtClass getCached(String classname) {
        CtClass clazz = this.getCachedLocally(classname);
        if (clazz == null) {
            Object o;
            boolean isLocal = false;
            ClassLoader cl = null;
            try {
                cl = this.getClassLoader();
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (cl != null) {
                String classResourceName = this.getResourceName(classname);
                isLocal = this.isLocalResource(classResourceName);
            }
            if (!isLocal && (o = this.generatedClasses.get((Object)classname)) == null) {
                Map registeredCLs;
                Map map = registeredCLs = AspectManager.getRegisteredCLs();
                synchronized (map) {
                    Iterator it = registeredCLs.values().iterator();
                    while (it.hasNext()) {
                        AOPClassPool pool = (AOPClassPool)((Object)it.next());
                        if (pool.isUnloadedClassLoader()) {
                            AspectManager.instance().unregisterClassLoader(pool.getClassLoader());
                            continue;
                        }
                        if (((Object)((Object)pool)).getClass().getName().equals("org.jboss.aop.deployment.ScopedJBossClassPool") || (clazz = pool.getCachedLocally(classname)) == null) continue;
                        return clazz;
                    }
                }
            }
        }
        return clazz;
    }

    protected String getResourceName(String classname) {
        int lastIndex = classname.lastIndexOf(36);
        if (lastIndex < 0) {
            return classname.replaceAll("[\\.]", "/") + ".class";
        }
        return classname.substring(0, lastIndex).replaceAll("[\\.]", "/") + classname.substring(lastIndex) + ".class";
    }

    protected boolean isLocalResource(String resourceName) {
        String classResourceName = this.getResourceName(resourceName);
        Boolean isLocal = (Boolean)this.localResources.get((Object)classResourceName);
        if (isLocal != null) {
            return isLocal;
        }
        boolean localResource = this.getClassLoader().getResource(classResourceName) != null;
        this.localResources.put((Object)classResourceName, (Object)(localResource ? Boolean.TRUE : Boolean.FALSE));
        return localResource;
    }

    public synchronized CtClass getLocally(String classname) throws NotFoundException {
        this.softcache.remove((Object)classname);
        CtClass clazz = (CtClass)this.classes.get(classname);
        if (clazz == null) {
            clazz = this.createCtClass(classname, true);
            if (clazz == null) {
                throw new NotFoundException(classname);
            }
            this.lockInCache(clazz);
        }
        return clazz;
    }

    public static AOPClassPool createAOPClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        return (AOPClassPool)AspectManager.getClassPoolFactory().create(cl, src, repository);
    }

    public static AOPClassPool createAOPClassPool(ClassPool src, ScopedClassPoolRepository repository) {
        return (AOPClassPool)AspectManager.getClassPoolFactory().create(src, repository);
    }

    public String toString() {
        ClassLoader cl = null;
        try {
            cl = this.getClassLoader();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return super.toString() + " - dcl " + cl;
    }

    static {
        ClassPool.doPruning = false;
        ClassPool.releaseUnmodifiedClassFile = false;
    }
}

