/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;

public class ConvertTraceFile {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [-traceFile <trace file name>] [-javaClass <java class name>] [-script <sql script file>]");
    }

    public static void main(String[] args) throws SQLException {
        new ConvertTraceFile().run(args);
    }

    private void run(String[] args) throws SQLException {
        String traceFile = "test.trace.db";
        String javaClass = "Test";
        String script = "test.sql";
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-traceFile")) {
                traceFile = args[++i];
                continue;
            }
            if (args[i].equals("-javaClass")) {
                javaClass = args[++i];
                continue;
            }
            if (args[i].equals("-script")) {
                script = args[++i];
                continue;
            }
            this.showUsage();
            return;
        }
        try {
            this.convertFile(traceFile, javaClass, script);
        }
        catch (IOException e) {
            throw Message.convertIOException(e, traceFile);
        }
    }

    private void convertFile(String traceFileName, String javaClassName, String script) throws IOException, SQLException {
        String line;
        LineNumberReader reader = new LineNumberReader(IOUtils.getReader(FileUtils.openFileInputStream(traceFileName)));
        PrintWriter javaWriter = new PrintWriter(FileUtils.openFileWriter(javaClassName + ".java", false));
        PrintWriter scriptWriter = new PrintWriter(FileUtils.openFileWriter(script, false));
        javaWriter.println("import java.io.*;");
        javaWriter.println("import java.sql.*;");
        javaWriter.println("import java.math.*;");
        javaWriter.println("import java.util.Calendar;");
        javaWriter.println("public class " + javaClassName + " {");
        javaWriter.println("    public static void main(String[] args) throws Exception {");
        javaWriter.println("        Class.forName(\"org.h2.Driver\");");
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("/**/")) {
                line = "        " + line.substring(4);
                javaWriter.println(line);
                continue;
            }
            if (!line.startsWith("/*SQL*/")) continue;
            line = line.substring("/*SQL*/".length());
            scriptWriter.println(line);
        }
        javaWriter.println("    }");
        javaWriter.println("}");
        reader.close();
        javaWriter.close();
        scriptWriter.close();
    }
}

