/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.pg;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.h2.Driver;
import org.h2.engine.Constants;
import org.h2.server.Service;
import org.h2.server.pg.PgServerThread;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;

public class PgServer
implements Service {
    public static final int DEFAULT_PORT = 5435;
    private int port = 5435;
    private boolean stop;
    private boolean log;
    private ServerSocket serverSocket;
    private Set running = Collections.synchronizedSet(new HashSet());
    private String baseDir;
    private String url;
    private boolean allowOthers;
    private boolean ifExists;

    public void init(String[] args) throws Exception {
        this.port = 5435;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if ("-log".equals(a)) {
                this.log = Boolean.valueOf(args[++i]);
                continue;
            }
            if ("-pgPort".equals(a)) {
                this.port = MathUtils.decodeInt(args[++i]);
                continue;
            }
            if ("-baseDir".equals(a)) {
                this.baseDir = args[++i];
                continue;
            }
            if ("-pgAllowOthers".equals(a)) {
                this.allowOthers = Boolean.valueOf(args[++i]);
                continue;
            }
            if (!"-ifExists".equals(a)) continue;
            this.ifExists = Boolean.valueOf(args[++i]);
        }
        Driver.load();
        this.url = "pg://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    boolean getLog() {
        return this.log;
    }

    void log(String s) {
        if (this.log) {
            System.out.println(s);
        }
    }

    synchronized void remove(PgServerThread t) {
        this.running.remove(t);
    }

    void logError(Exception e) {
        if (this.log) {
            e.printStackTrace();
        }
    }

    public String getURL() {
        return this.url;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        return NetUtils.isLoopbackAddress(socket);
    }

    public void start() throws SQLException {
        this.serverSocket = NetUtils.createServerSocket(this.port, false);
    }

    public void listen() {
        block4: {
            String threadName = Thread.currentThread().getName();
            try {
                while (!this.stop) {
                    Socket s = this.serverSocket.accept();
                    if (!this.allow(s)) {
                        this.log("Connection not allowed");
                        s.close();
                        continue;
                    }
                    PgServerThread c = new PgServerThread(s, this);
                    this.running.add(c);
                    c.setProcessId(this.running.size());
                    Thread thread = new Thread(c);
                    thread.setName(threadName + " thread");
                    c.setThread(thread);
                    thread.start();
                }
            }
            catch (Exception e) {
                if (this.stop) break block4;
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (!this.stop) {
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.serverSocket = null;
            }
        }
        ArrayList list = new ArrayList(this.running);
        for (int i = 0; i < list.size(); ++i) {
            PgServerThread c = (PgServerThread)list.get(i);
            c.close();
            try {
                Thread t = c.getThread();
                if (t == null) continue;
                t.join(100L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.serverSocket.getLocalPort(), false);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    public String getType() {
        return "PG";
    }

    public String getName() {
        return "H2 PG Server";
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public static String getIndexColumn(Connection conn, int indexId, Integer ordinalPosition, Boolean pretty) throws SQLException {
        if (ordinalPosition == null || ordinalPosition == 0) {
            PreparedStatement prep = conn.prepareStatement("select sql from information_schema.indexes where id=?");
            prep.setInt(1, indexId);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                return rs.getString(1);
            }
            return null;
        }
        PreparedStatement prep = conn.prepareStatement("select column_name from information_schema.indexes where id=? and ordinal_position=?");
        prep.setInt(1, indexId);
        prep.setInt(2, ordinalPosition);
        ResultSet rs = prep.executeQuery();
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    public static String getCurrentSchema(Connection conn) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("call schema()");
        rs.next();
        return rs.getString(1);
    }

    public static String getEncodingName(int code) throws SQLException {
        switch (code) {
            case 0: {
                return "SQL_ASCII";
            }
            case 6: {
                return "UTF8";
            }
            case 8: {
                return "LATIN1";
            }
        }
        return code < 40 ? "UTF8" : "";
    }

    public static String getVersion() {
        return "PostgreSQL 8.1.4  server protocol using H2 " + Constants.getVersion();
    }

    public static Timestamp getStartTime() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String getUserById(Connection conn, int id) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT NAME FROM INFORMATION_SCHEMA.USERS WHERE ID=?");
        prep.setInt(1, id);
        ResultSet rs = prep.executeQuery();
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    public static boolean hasDatabasePrivilege(int id, String privilege) {
        return true;
    }

    public static boolean hasTablePrivilege(String table, String privilege) {
        return true;
    }

    public static int getCurrentTid(String table, String id) {
        return 1;
    }
}

