/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ListEntries;
import org.apache.myfaces.config.element.ListEntry;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.ManagedProperty;
import org.apache.myfaces.config.element.MapEntries;
import org.apache.myfaces.config.element.MapEntry;
import org.apache.myfaces.shared_impl.util.ClassUtils;

public class ManagedBeanBuilder {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$config$ManagedBeanBuilder == null ? (class$org$apache$myfaces$config$ManagedBeanBuilder = ManagedBeanBuilder.class$("org.apache.myfaces.config.ManagedBeanBuilder")) : class$org$apache$myfaces$config$ManagedBeanBuilder));
    private RuntimeConfig _runtimeConfig;
    static /* synthetic */ Class class$org$apache$myfaces$config$ManagedBeanBuilder;
    static /* synthetic */ Class class$java$lang$String;

    public Object buildManagedBean(FacesContext facesContext, ManagedBean beanConfiguration) throws FacesException {
        Object bean = ClassUtils.newInstance(beanConfiguration.getManagedBeanClassName());
        switch (beanConfiguration.getInitMode()) {
            case 1: {
                try {
                    this.initializeProperties(facesContext, beanConfiguration.getManagedProperties(), beanConfiguration.getManagedBeanScope(), bean);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(e.getMessage() + " for bean '" + beanConfiguration.getManagedBeanName() + "' check the configuration to make sure all properties correspond with get/set methods");
                }
            }
            case 2: {
                if (!(bean instanceof Map)) {
                    throw new IllegalArgumentException("Class " + bean.getClass().getName() + " of managed bean " + beanConfiguration.getManagedBeanName() + " is not a Map.");
                }
                this.initializeMap(facesContext, beanConfiguration.getMapEntries(), (Map)bean);
                break;
            }
            case 3: {
                if (!(bean instanceof List)) {
                    throw new IllegalArgumentException("Class " + bean.getClass().getName() + " of managed bean " + beanConfiguration.getManagedBeanName() + " is not a List.");
                }
                this.initializeList(facesContext, beanConfiguration.getListEntries(), (List)bean);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown managed bean type " + bean.getClass().getName() + " for managed bean " + beanConfiguration.getManagedBeanName() + '.');
            }
        }
        return bean;
    }

    private void initializeProperties(FacesContext facesContext, Iterator managedProperties, String targetScope, Object bean) {
        PropertyResolver propertyResolver = facesContext.getApplication().getPropertyResolver();
        while (managedProperties.hasNext()) {
            ManagedProperty property = (ManagedProperty)managedProperties.next();
            Object value = null;
            switch (property.getType()) {
                case 4: {
                    if (PropertyUtils.isReadable((Object)bean, (String)property.getPropertyName())) {
                        value = propertyResolver.getValue(bean, (Object)property.getPropertyName());
                    }
                    Object object = value = value == null ? new ArrayList() : value;
                    if (value instanceof List) {
                        this.initializeList(facesContext, property.getListEntries(), (List)value);
                        break;
                    }
                    if (value != null && value.getClass().isArray()) {
                        int i;
                        int length = Array.getLength(value);
                        ArrayList<Object> temp = new ArrayList<Object>(length);
                        for (i = 0; i < length; ++i) {
                            temp.add(Array.get(value, i));
                        }
                        this.initializeList(facesContext, property.getListEntries(), temp);
                        value = Array.newInstance(value.getClass().getComponentType(), temp.size());
                        length = temp.size();
                        for (i = 0; i < length; ++i) {
                            Array.set(value, i, temp.get(i));
                        }
                        break;
                    }
                    value = new ArrayList();
                    this.initializeList(facesContext, property.getListEntries(), (List)value);
                    break;
                }
                case 1: {
                    if (PropertyUtils.isReadable((Object)bean, (String)property.getPropertyName())) {
                        value = propertyResolver.getValue(bean, (Object)property.getPropertyName());
                    }
                    Object object = value = value == null ? new HashMap() : value;
                    if (!(value instanceof Map)) {
                        value = new HashMap();
                    }
                    this.initializeMap(facesContext, property.getMapEntries(), (Map)value);
                    break;
                }
                case 2: {
                    value = null;
                    break;
                }
                case 3: {
                    if (!this.isInValidScope(facesContext, property, targetScope)) {
                        throw new FacesException("Property " + property.getPropertyName() + " references object in a scope with shorter lifetime than the target scope " + targetScope);
                    }
                    value = property.getRuntimeValue(facesContext);
                }
            }
            Class propertyClass = null;
            propertyClass = property.getPropertyClass() == null ? propertyResolver.getType(bean, (Object)property.getPropertyName()) : ClassUtils.simpleJavaTypeToClass(property.getPropertyClass());
            if (null == propertyClass) {
                throw new IllegalArgumentException("unable to find the type of property " + property.getPropertyName());
            }
            Object coercedValue = ClassUtils.convertToType(value, propertyClass);
            propertyResolver.setValue(bean, (Object)property.getPropertyName(), coercedValue);
        }
    }

    private boolean isInValidScope(FacesContext facesContext, ManagedProperty property, String targetScope) {
        if (!property.isValueReference()) {
            return true;
        }
        String[] expressions = this.extractExpressions(property.getValueBinding(facesContext).getExpressionString());
        for (int i = 0; i < expressions.length; ++i) {
            String expression = expressions[i];
            if (expression == null) continue;
            String valueScope = this.getScope(facesContext, expression);
            if (targetScope == null || targetScope.equalsIgnoreCase("none")) {
                return valueScope == null || valueScope.equalsIgnoreCase("none");
            }
            if (targetScope.equalsIgnoreCase("application")) {
                return valueScope == null || !valueScope.equalsIgnoreCase("request") && !valueScope.equalsIgnoreCase("session");
            }
            if (targetScope.equalsIgnoreCase("session")) {
                return valueScope == null || !valueScope.equalsIgnoreCase("request");
            }
            if (!targetScope.equalsIgnoreCase("request")) continue;
            return true;
        }
        return false;
    }

    private String getScope(FacesContext facesContext, String expression) {
        String beanName = this.getFirstSegment(expression);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (beanName.equalsIgnoreCase("requestScope")) {
            return "request";
        }
        if (beanName.equalsIgnoreCase("sessionScope")) {
            return "session";
        }
        if (beanName.equalsIgnoreCase("applicationScope")) {
            return "application";
        }
        if (beanName.equalsIgnoreCase("cookie")) {
            return "request";
        }
        if (beanName.equalsIgnoreCase("facesContext")) {
            return "request";
        }
        if (beanName.equalsIgnoreCase("header")) {
            return "request";
        }
        if (beanName.equalsIgnoreCase("headerValues")) {
            return "request";
        }
        if (beanName.equalsIgnoreCase("initParam")) {
            return "application";
        }
        if (beanName.equalsIgnoreCase("param")) {
            return "request";
        }
        if (beanName.equalsIgnoreCase("paramValues")) {
            return "request";
        }
        if (beanName.equalsIgnoreCase("view")) {
            return "request";
        }
        if (externalContext.getRequestMap().get(beanName) != null) {
            return "request";
        }
        if (externalContext.getSessionMap().get(beanName) != null) {
            return "session";
        }
        if (externalContext.getApplicationMap().get(beanName) != null) {
            return "application";
        }
        ManagedBean mbc = this.getRuntimeConfig(facesContext).getManagedBean(beanName);
        if (mbc != null) {
            return mbc.getManagedBeanScope();
        }
        return null;
    }

    private String getFirstSegment(String expression) {
        int indexDot = expression.indexOf(46);
        int indexBracket = expression.indexOf(91);
        if (indexBracket < 0) {
            if (indexDot < 0) {
                return expression;
            }
            return expression.substring(0, indexDot);
        }
        if (indexDot < 0) {
            return expression.substring(0, indexBracket);
        }
        return expression.substring(0, Math.min(indexDot, indexBracket));
    }

    private String getSecondSegment(String expression, String firstSegment) {
        String tmp = expression.substring(firstSegment.length());
        if (tmp.length() == 0) {
            return null;
        }
        if (tmp.charAt(0) == '.') {
            return this.getFirstSegment(tmp.substring(1));
        }
        if ((tmp = tmp.substring(1).trim()).charAt(0) == '\"') {
            int index = tmp.indexOf(34, 1);
            if (index < 0) {
                throw new EvaluationException(tmp);
            }
            return tmp.substring(1, index);
        }
        if (tmp.charAt(0) == '\'') {
            int index = tmp.indexOf(39, 1);
            if (index < 0) {
                throw new EvaluationException(tmp);
            }
            return tmp.substring(1, index);
        }
        int index = tmp.indexOf(93);
        if (index < 0) {
            throw new EvaluationException(tmp);
        }
        return tmp.substring(1, index);
    }

    private String[] extractExpressions(String expressionString) {
        String[] expressions = expressionString.split("\\#\\{");
        for (int i = 0; i < expressions.length; ++i) {
            String expression = expressions[i];
            if (expression.trim().length() == 0) {
                expressions[i] = null;
                continue;
            }
            int index = expression.indexOf(125);
            expressions[i] = expression.substring(0, index);
        }
        return expressions;
    }

    private void initializeMap(FacesContext facesContext, MapEntries mapEntries, Map map) {
        Class keyClass;
        Application application = facesContext.getApplication();
        Class clazz = mapEntries.getKeyClass() == null ? (class$java$lang$String == null ? (class$java$lang$String = ManagedBeanBuilder.class$("java.lang.String")) : class$java$lang$String) : (keyClass = ClassUtils.simpleJavaTypeToClass(mapEntries.getKeyClass()));
        Class valueClass = mapEntries.getValueClass() == null ? (class$java$lang$String == null ? (class$java$lang$String = ManagedBeanBuilder.class$("java.lang.String")) : class$java$lang$String) : ClassUtils.simpleJavaTypeToClass(mapEntries.getValueClass());
        Iterator iterator = mapEntries.getMapEntries();
        while (iterator.hasNext()) {
            ValueBinding valueBinding;
            MapEntry entry = (MapEntry)iterator.next();
            Object key = entry.getKey();
            if (UIComponentTag.isValueReference((String)key)) {
                valueBinding = application.createValueBinding((String)key);
                key = valueBinding.getValue(facesContext);
            }
            if (entry.isNullValue()) {
                map.put(ClassUtils.convertToType(key, keyClass), null);
                continue;
            }
            Object value = entry.getValue();
            if (UIComponentTag.isValueReference((String)value)) {
                valueBinding = application.createValueBinding((String)value);
                value = valueBinding.getValue(facesContext);
            }
            map.put(ClassUtils.convertToType(key, keyClass), ClassUtils.convertToType(value, valueClass));
        }
    }

    private void initializeList(FacesContext facesContext, ListEntries listEntries, List list) {
        Application application = facesContext.getApplication();
        Class clazz = listEntries.getValueClass() == null ? (class$java$lang$String == null ? (class$java$lang$String = ManagedBeanBuilder.class$("java.lang.String")) : class$java$lang$String) : ClassUtils.simpleJavaTypeToClass(listEntries.getValueClass());
        Class valueClass = clazz;
        Iterator iterator = listEntries.getListEntries();
        while (iterator.hasNext()) {
            ListEntry entry = (ListEntry)iterator.next();
            if (entry.isNullValue()) {
                list.add(null);
                continue;
            }
            Object value = entry.getValue();
            if (UIComponentTag.isValueReference((String)value)) {
                ValueBinding valueBinding = application.createValueBinding((String)value);
                value = valueBinding.getValue(facesContext);
            }
            list.add(ClassUtils.convertToType(value, valueClass));
        }
    }

    private RuntimeConfig getRuntimeConfig(FacesContext facesContext) {
        if (this._runtimeConfig == null) {
            this._runtimeConfig = RuntimeConfig.getCurrentInstance(facesContext.getExternalContext());
        }
        return this._runtimeConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

