/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.bisocket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.invocation.InternalInvocation;
import org.jboss.remoting.socketfactory.CreationListenerServerSocket;
import org.jboss.remoting.socketfactory.CreationListenerSocketFactory;
import org.jboss.remoting.socketfactory.SocketCreationListener;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.transport.bisocket.BisocketClientInvoker;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.ServerThread;
import org.jboss.remoting.transport.socket.SocketServerInvoker;

public class BisocketServerInvoker
extends SocketServerInvoker {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$bisocket$BisocketServerInvoker == null ? (class$org$jboss$remoting$transport$bisocket$BisocketServerInvoker = BisocketServerInvoker.class$("org.jboss.remoting.transport.bisocket.BisocketServerInvoker")) : class$org$jboss$remoting$transport$bisocket$BisocketServerInvoker);
    private static Map listenerIdToServerInvokerMap = Collections.synchronizedMap(new HashMap());
    private static Timer timer;
    private Map listenerIdToInvokerLocatorMap = Collections.synchronizedMap(new HashMap());
    private ServerSocket secondaryServerSocket;
    private InvokerLocator secondaryLocator;
    private SecondaryServerSocketThread secondaryServerSocketThread;
    private Map controlConnectionThreadMap = new HashMap();
    private Map controlConnectionRestartsMap = Collections.synchronizedMap(new HashMap());
    private int pingFrequency = 5000;
    private int pingWindowFactor = 2;
    private int pingWindow = this.pingWindowFactor * this.pingFrequency;
    private int socketCreationRetries = 10;
    private int controlConnectionRestarts = 10;
    private ControlMonitorTimerTask controlMonitorTimerTask;
    protected boolean isCallbackServer = false;
    static /* synthetic */ Class class$org$jboss$remoting$transport$bisocket$BisocketServerInvoker;

    public static BisocketServerInvoker getBisocketServerInvoker(String listenerId) {
        return (BisocketServerInvoker)listenerIdToServerInvokerMap.get(listenerId);
    }

    public BisocketServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public BisocketServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public void start() throws IOException {
        if (this.isCallbackServer) {
            int nVal;
            Object val = this.configuration.get("maxRetries");
            if (val != null) {
                try {
                    this.socketCreationRetries = nVal = Integer.valueOf((String)val).intValue();
                    log.debug("Setting socket creation retry limit: " + this.socketCreationRetries);
                }
                catch (Exception e) {
                    log.warn("Could not convert maxRetries value of " + val + " to an int value.");
                }
            }
            if ((val = this.configuration.get("maxControlConnectionRestarts")) != null) {
                try {
                    this.controlConnectionRestarts = nVal = Integer.valueOf((String)val).intValue();
                    log.debug("Setting control connection restart limit: " + this.controlConnectionRestarts);
                }
                catch (Exception e) {
                    log.warn("Could not convert maxControlConnectionRestarts value of " + val + " to an int value.");
                }
            }
            if (this.maxPoolSize <= 0) {
                this.maxPoolSize = MAX_POOL_SIZE_DEFAULT;
            }
            this.clientpool = new LRUPool(2, this.maxPoolSize);
            this.clientpool.create();
            this.threadpool = new LinkedList();
            this.checkSocketFactoryWrapper();
            timer = new Timer(true);
            this.controlMonitorTimerTask = new ControlMonitorTimerTask(this);
            timer.schedule((TimerTask)this.controlMonitorTimerTask, this.pingFrequency, (long)this.pingFrequency);
            this.running = true;
            this.started = true;
        } else {
            super.start();
            InetAddress host = this.getServerSocket().getInetAddress();
            int freePort = PortUtil.findFreePort(host.getHostAddress());
            this.secondaryServerSocket = this.serverSocketFactory != null ? this.serverSocketFactory.createServerSocket(freePort, 0, host) : new ServerSocket(freePort, 0, host);
            this.checkSecondaryServerSocketWrapper();
            this.secondaryLocator = new InvokerLocator(null, host.getHostAddress(), freePort, null, null);
            this.secondaryServerSocketThread = new SecondaryServerSocketThread(this.secondaryServerSocket);
            this.secondaryServerSocketThread.setName("secondaryServerSocketThread");
            this.secondaryServerSocketThread.setDaemon(true);
            this.secondaryServerSocketThread.start();
            log.debug("started secondary port: " + host + ":" + freePort);
        }
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createControlConnection(String listenerId, boolean firstConnection) throws IOException {
        BisocketClientInvoker clientInvoker = BisocketClientInvoker.getBisocketClientInvoker(listenerId);
        if (clientInvoker == null) {
            log.debug("Unable to retrieve client invoker: must have disconnected");
            throw new ClientUnavailableException();
        }
        InvokerLocator oldLocator = (InvokerLocator)this.listenerIdToInvokerLocatorMap.get(listenerId);
        InvokerLocator newLocator = null;
        try {
            newLocator = clientInvoker.getSecondaryLocator();
        }
        catch (Throwable t) {
            log.error("unable to get secondary locator", t);
            throw new IOException("unable to get secondary locator: " + t.getMessage());
        }
        boolean locatorChanged = !newLocator.equals(oldLocator);
        this.listenerIdToInvokerLocatorMap.put(listenerId, newLocator);
        log.debug("creating control connection: " + newLocator);
        Socket socket = null;
        IOException savedException = null;
        for (int i = 0; i < this.socketCreationRetries; ++i) {
            try {
                socket = this.socketFactory != null ? this.socketFactory.createSocket(newLocator.getHost(), newLocator.getPort()) : new Socket(newLocator.getHost(), newLocator.getPort());
            }
            catch (IOException e) {
                log.debug("Error creating a control socket", e);
                savedException = e;
            }
            if (socket != null) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                log.debug("received interrupt");
                throw new InterruptedIOException("interrupt in createControlConnection()");
            }
        }
        if (socket == null) {
            log.error("unable to create control connection after " + this.socketCreationRetries + " retries", savedException);
            throw savedException;
        }
        DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
        if (firstConnection) {
            dos.write(3);
        } else {
            dos.write(2);
        }
        dos.writeUTF(listenerId);
        ControlConnectionThread thread = new ControlConnectionThread(socket, listenerId);
        thread.setName("control: " + socket.toString());
        thread.setDaemon(true);
        Map map = this.controlConnectionThreadMap;
        synchronized (map) {
            this.controlConnectionThreadMap.put(listenerId, thread);
        }
        Object o = this.controlConnectionRestartsMap.get(listenerId);
        if (o != null) {
            int restarts = (Integer)o;
            if (locatorChanged || restarts > 0) {
                this.controlConnectionRestartsMap.put(listenerId, new Integer(++restarts));
            }
        } else {
            this.controlConnectionRestartsMap.put(listenerId, new Integer(0));
        }
        thread.start();
        log.debug("created control connection: " + socket.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyControlConnection(String listenerId) throws IOException {
        this.listenerIdToInvokerLocatorMap.remove(listenerId);
        this.controlConnectionRestartsMap.remove(listenerId);
        Thread t = null;
        Map map = this.controlConnectionThreadMap;
        synchronized (map) {
            t = (Thread)this.controlConnectionThreadMap.remove(listenerId);
        }
        if (t != null) {
            ((ControlConnectionThread)t).shutdown();
        } else {
            log.debug("unrecognized listener ID: " + listenerId);
        }
    }

    public int getControlConnectionRestarts() {
        return this.controlConnectionRestarts;
    }

    public void setControlConnectionRestarts(int controlConnectionRestarts) {
        this.controlConnectionRestarts = controlConnectionRestarts;
    }

    public int getPingFrequency() {
        return this.pingFrequency;
    }

    public void setPingFrequency(int pingFrequency) {
        this.pingFrequency = pingFrequency;
        this.pingWindow = this.pingWindowFactor * pingFrequency;
    }

    public int getPingWindowFactor() {
        return this.pingWindowFactor;
    }

    public void setPingWindowFactor(int pingWindowFactor) {
        this.pingWindowFactor = pingWindowFactor;
        this.pingWindow = pingWindowFactor * this.pingFrequency;
    }

    public int getSocketCreationRetries() {
        return this.socketCreationRetries;
    }

    public void setSocketCreationRetries(int socketCreationRetries) {
        this.socketCreationRetries = socketCreationRetries;
    }

    protected void setup() throws Exception {
        Object o = this.configuration.get("isCallbackServer");
        if (o != null) {
            if (o instanceof String) {
                this.isCallbackServer = Boolean.valueOf((String)o);
            } else if (o instanceof Boolean) {
                this.isCallbackServer = (Boolean)o;
            } else {
                log.error("unrecognized value for configuration key \"isCallbackServer\": " + o);
            }
        }
        if ((o = this.configuration.get("pingFrequency")) instanceof String && ((String)o).length() > 0) {
            try {
                this.pingFrequency = Integer.valueOf((String)o);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid format for \"pingFrequency\": " + o);
            }
        } else if (o != null) {
            log.warn("\"pingFrequency\" must be specified as a String");
        }
        if ((o = this.configuration.get("pingWindowFactor")) instanceof String && ((String)o).length() > 0) {
            try {
                this.pingWindowFactor = Integer.valueOf((String)o);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid format for \"pingWindowFactor\": " + o);
            }
        } else if (o != null) {
            log.warn("\"pingWindowFactor\" must be specified as a String");
        }
        this.pingWindow = this.pingWindowFactor * this.pingFrequency;
        super.setup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        super.cleanup();
        if (this.controlMonitorTimerTask != null) {
            this.controlMonitorTimerTask.shutdown();
        }
        Map map = this.controlConnectionThreadMap;
        synchronized (map) {
            Iterator it = this.controlConnectionThreadMap.values().iterator();
            while (it.hasNext()) {
                ControlConnectionThread t = (ControlConnectionThread)it.next();
                it.remove();
                t.shutdown();
            }
        }
        if (this.secondaryServerSocketThread != null) {
            this.secondaryServerSocketThread.shutdown();
        }
        if (this.secondaryServerSocket != null) {
            try {
                this.secondaryServerSocket.close();
            }
            catch (IOException e) {
                log.info("Error closing secondary server socket: " + e.getMessage());
            }
        }
    }

    protected InvokerLocator getSecondaryLocator() {
        return this.secondaryLocator;
    }

    protected ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    protected void checkSocketFactoryWrapper() throws IOException {
        Object o = this.configuration.get("socketCreationServerListener");
        if (o != null) {
            if (o instanceof SocketCreationListener) {
                SocketCreationListener listener = (SocketCreationListener)o;
                if (this.socketFactory instanceof CreationListenerSocketFactory) {
                    CreationListenerSocketFactory clsf = (CreationListenerSocketFactory)this.socketFactory;
                    clsf.setListener(listener);
                } else {
                    this.socketFactory = new CreationListenerSocketFactory(this.socketFactory, listener);
                }
            } else {
                log.error("socket creation listener of invalid type: " + o);
            }
        } else if (this.socketFactory instanceof CreationListenerSocketFactory) {
            CreationListenerSocketFactory clsf = (CreationListenerSocketFactory)this.socketFactory;
            this.socketFactory = clsf.getFactory();
        }
    }

    protected void checkSecondaryServerSocketWrapper() throws IOException {
        Object o = this.configuration.get("socketCreationClientListener");
        if (o != null) {
            if (o instanceof SocketCreationListener) {
                SocketCreationListener listener = (SocketCreationListener)o;
                if (this.secondaryServerSocket instanceof CreationListenerServerSocket) {
                    CreationListenerServerSocket clss = (CreationListenerServerSocket)this.secondaryServerSocket;
                    clss.setListener(listener);
                } else {
                    this.secondaryServerSocket = new CreationListenerServerSocket(this.secondaryServerSocket, listener);
                }
            } else {
                log.error("socket creation listener of invalid type: " + o);
            }
        } else if (this.secondaryServerSocket instanceof CreationListenerServerSocket) {
            CreationListenerServerSocket clss = (CreationListenerServerSocket)this.secondaryServerSocket;
            this.secondaryServerSocket = clss.getServerSocket();
        }
    }

    protected Object handleInternalInvocation(InternalInvocation ii, InvocationRequest ir, ServerInvocationHandler handler) throws Throwable {
        String listenerId;
        Map metadata;
        if ("getSecondaryInvokerLocator".equals(ii.getMethodName())) {
            return this.secondaryLocator;
        }
        Object response = super.handleInternalInvocation(ii, ir, handler);
        if ("addClientListener".equals(ii.getMethodName())) {
            String listenerId2;
            Map metadata2 = ir.getRequestPayload();
            if (metadata2 != null && (listenerId2 = (String)metadata2.get("listenerId")) != null) {
                listenerIdToServerInvokerMap.put(listenerId2, this);
            }
        } else if ("removeClientListener".equals(ii.getMethodName()) && (metadata = ir.getRequestPayload()) != null && (listenerId = (String)metadata.get("listenerId")) != null) {
            listenerIdToServerInvokerMap.remove(listenerId);
            BisocketClientInvoker.removeBisocketClientInvoker(listenerId);
            this.destroyControlConnection(listenerId);
        }
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ClientUnavailableException
    extends IOException {
        private static final long serialVersionUID = 2846502029152028732L;

        ClientUnavailableException() {
        }
    }

    static class ControlMonitorTimerTask
    extends TimerTask {
        private boolean running = true;
        private BisocketServerInvoker invoker;
        private Map listenerIdToInvokerLocatorMap;
        private Map controlConnectionThreadMap;
        private Map controlConnectionRestartsMap;
        private int controlConnectionRestarts;

        ControlMonitorTimerTask(BisocketServerInvoker invoker) {
            this.invoker = invoker;
            this.listenerIdToInvokerLocatorMap = invoker.listenerIdToInvokerLocatorMap;
            this.controlConnectionThreadMap = invoker.controlConnectionThreadMap;
            this.controlConnectionRestartsMap = invoker.controlConnectionRestartsMap;
            this.controlConnectionRestarts = invoker.controlConnectionRestarts;
        }

        synchronized void shutdown() {
            this.running = false;
            this.invoker = null;
            this.listenerIdToInvokerLocatorMap = null;
            this.controlConnectionThreadMap = null;
            this.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!this.running) {
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace("checking connections");
            }
            HashSet controlConnectionThreads = null;
            ControlMonitorTimerTask controlMonitorTimerTask = this;
            synchronized (controlMonitorTimerTask) {
                if (!this.running) {
                    return;
                }
                controlConnectionThreads = new HashSet(this.controlConnectionThreadMap.values());
            }
            Iterator it = controlConnectionThreads.iterator();
            while (it.hasNext()) {
                Object locator;
                ControlConnectionThread t = (ControlConnectionThread)it.next();
                String listenerId = t.getListenerId();
                ControlMonitorTimerTask controlMonitorTimerTask2 = this;
                synchronized (controlMonitorTimerTask2) {
                    if (!this.running) {
                        return;
                    }
                    locator = this.listenerIdToInvokerLocatorMap.get(listenerId);
                }
                if (t.checkConnection()) continue;
                t.shutdown();
                controlMonitorTimerTask2 = this;
                synchronized (controlMonitorTimerTask2) {
                    if (!this.running) {
                        return;
                    }
                    this.controlConnectionThreadMap.remove(listenerId);
                    Object o = this.controlConnectionRestartsMap.get(listenerId);
                    int restarts = (Integer)o;
                    if (restarts + 1 > this.controlConnectionRestarts) {
                        log.warn(this + ": detected failure on control connection " + t);
                        log.warn("Control connection " + listenerId + " has been recreated " + restarts + " times.");
                        log.warn("Assuming it is a connection to an old server, and will not restart");
                        this.controlConnectionRestartsMap.remove(listenerId);
                        continue;
                    }
                    log.warn(this + ": detected failure on control connection " + t + ": requesting new control connection");
                }
                Thread t2 = new Thread(this, listenerId, locator){
                    private final /* synthetic */ String val$listenerId;
                    private final /* synthetic */ Object val$locator;
                    private final /* synthetic */ ControlMonitorTimerTask this$0;
                    {
                        this.this$0 = this$0;
                        this.val$listenerId = val$listenerId;
                        this.val$locator = val$locator;
                    }

                    public void run() {
                        if (!ControlMonitorTimerTask.access$1700(this.this$0)) {
                            return;
                        }
                        try {
                            ControlMonitorTimerTask.access$1800(this.this$0).createControlConnection(this.val$listenerId, false);
                        }
                        catch (ClientUnavailableException e) {
                            BisocketServerInvoker.access$000().debug("Unable to recreate control connection: " + this.val$locator, e);
                        }
                        catch (IOException e) {
                            if (ControlMonitorTimerTask.access$1700(this.this$0)) {
                                BisocketServerInvoker.access$000().error("Unable to recreate control connection: " + this.val$locator, e);
                            }
                            BisocketServerInvoker.access$000().debug("Unable to recreate control connection: " + this.val$locator, e);
                        }
                    }
                };
                t2.setName("controlConnectionRecreate:" + t.getName());
                t2.start();
            }
        }

        static /* synthetic */ boolean access$1700(ControlMonitorTimerTask x0) {
            return x0.running;
        }

        static /* synthetic */ BisocketServerInvoker access$1800(ControlMonitorTimerTask x0) {
            return x0.invoker;
        }
    }

    class SecondaryServerSocketThread
    extends Thread {
        private ServerSocket secondaryServerSocket;
        boolean running = true;

        SecondaryServerSocketThread(ServerSocket secondaryServerSocket) throws IOException {
            this.secondaryServerSocket = secondaryServerSocket;
        }

        void shutdown() {
            this.running = false;
            this.interrupt();
        }

        public void run() {
            block6: while (this.running) {
                try {
                    Socket socket = this.secondaryServerSocket.accept();
                    log.debug("accepted: " + socket);
                    DataInputStream dis = new DataInputStream(socket.getInputStream());
                    int action = dis.read();
                    String listenerId = dis.readUTF();
                    switch (action) {
                        case 2: {
                            BisocketClientInvoker invoker = BisocketClientInvoker.getBisocketCallbackClientInvoker(listenerId);
                            if (invoker == null) {
                                log.debug("SecondaryServerSocketThread: transferring socket: " + listenerId);
                                BisocketClientInvoker.transferSocket(listenerId, socket);
                                continue block6;
                            }
                            invoker.replaceControlSocket(socket);
                            log.debug("SecondaryServerSocketThread: created secondary socket: " + listenerId);
                            continue block6;
                        }
                        case 3: {
                            BisocketClientInvoker.transferSocket(listenerId, socket);
                            log.debug("SecondaryServerSocketThread: transferred socket: " + listenerId);
                            continue block6;
                        }
                    }
                    log.error("unrecognized action: " + action);
                }
                catch (IOException e) {
                    if (this.running) {
                        log.error("Failed to accept socket connection", e);
                        continue;
                    }
                    return;
                }
            }
        }

        ServerSocket getServerSocket() {
            return this.secondaryServerSocket;
        }
    }

    class ControlConnectionThread
    extends Thread {
        private static final int MAX_INITIAL_ATTEMPTS = 5;
        private Socket controlSocket;
        private String listenerId;
        private DataInputStream dis;
        private boolean running;
        private int errorCount;
        private long lastPing = -1L;
        private int initialAttempts;

        ControlConnectionThread(Socket socket, String listenerId) throws IOException {
            this.controlSocket = socket;
            this.listenerId = listenerId;
            this.dis = new DataInputStream(socket.getInputStream());
        }

        void shutdown() {
            this.running = false;
            try {
                this.controlSocket.close();
            }
            catch (IOException e) {
                log.warn("unable to close controlSocket");
            }
            this.interrupt();
        }

        boolean checkConnection() {
            if (this.lastPing < 0L && this.initialAttempts++ < 5) {
                return true;
            }
            if (this.lastPing < 0L) {
                return false;
            }
            long currentTime = System.currentTimeMillis();
            if (log.isTraceEnabled()) {
                log.trace("elapsed: " + (currentTime - this.lastPing));
            }
            return currentTime - this.lastPing <= (long)BisocketServerInvoker.this.pingWindow;
        }

        String getListenerId() {
            return this.listenerId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.running = true;
            while (this.running) {
                Socket socket;
                block27: {
                    socket = null;
                    try {
                        int action = this.dis.read();
                        this.lastPing = System.currentTimeMillis();
                        switch (action) {
                            case 3: {
                                InvokerLocator locator = (InvokerLocator)BisocketServerInvoker.this.listenerIdToInvokerLocatorMap.get(this.listenerId);
                                IOException savedException = null;
                                for (int i = 0; i < BisocketServerInvoker.this.socketCreationRetries; ++i) {
                                    try {
                                        socket = BisocketServerInvoker.this.socketFactory != null ? BisocketServerInvoker.this.socketFactory.createSocket(locator.getHost(), locator.getPort()) : new Socket(locator.getHost(), locator.getPort());
                                    }
                                    catch (IOException e) {
                                        log.debug("Error creating a socket", e);
                                        savedException = e;
                                    }
                                    if (socket != null) break;
                                    try {
                                        Thread.sleep(1000L);
                                        continue;
                                    }
                                    catch (InterruptedException e) {
                                        if (this.running) {
                                            log.warn("received unexpected interrupt");
                                            continue;
                                        }
                                        return;
                                    }
                                }
                                if (socket == null) {
                                    log.error("Unable to create socket after " + BisocketServerInvoker.this.socketCreationRetries + " retries", savedException);
                                    break;
                                }
                                DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
                                dos.write(3);
                                dos.writeUTF(this.listenerId);
                                break block27;
                            }
                            case 1: {
                                break;
                            }
                            case -1: {
                                this.shutdown();
                                return;
                            }
                            default: {
                                log.error("unrecognized action: " + action);
                                break;
                            }
                        }
                        continue;
                    }
                    catch (IOException e) {
                        if (this.running) {
                            if ("socket closed".equals(e.getMessage()) || "Socket is closed".equals(e.getMessage()) || "Connection reset".equals(e.getMessage())) {
                                this.shutdown();
                                return;
                            }
                            log.error("Unable to process control connection: " + e.getMessage(), e);
                            if (++this.errorCount <= 5) continue;
                            this.shutdown();
                            return;
                        }
                        return;
                    }
                }
                LRUPool lRUPool = BisocketServerInvoker.this.clientpool;
                synchronized (lRUPool) {
                    if (BisocketServerInvoker.this.clientpool.size() < BisocketServerInvoker.this.maxPoolSize) {
                        ServerThread thread = null;
                        try {
                            thread = new ServerThread(socket, BisocketServerInvoker.this, BisocketServerInvoker.this.clientpool, BisocketServerInvoker.this.threadpool, BisocketServerInvoker.this.getTimeout(), BisocketServerInvoker.this.serverSocketClass);
                            thread.start();
                            if (log.isDebugEnabled()) {
                                log.debug("created: " + thread);
                            }
                        }
                        catch (Exception e) {
                            log.error("Unable to create new ServerThread: " + e.getMessage());
                            e.printStackTrace();
                        }
                        LinkedList linkedList = BisocketServerInvoker.this.threadpool;
                        synchronized (linkedList) {
                            BisocketServerInvoker.this.threadpool.add(thread);
                        }
                    }
                }
            }
        }
    }
}

