/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.jci.listeners.NotificationListener;
import org.apache.commons.jci.listeners.ReloadingListener;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.ResourceStoreClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadingClassLoader
extends ClassLoader
implements NotificationListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$ReloadingClassLoader == null ? (class$org$apache$commons$jci$ReloadingClassLoader = ReloadingClassLoader.class$("org.apache.commons.jci.ReloadingClassLoader")) : class$org$apache$commons$jci$ReloadingClassLoader));
    private final ClassLoader parent;
    private ResourceStore[] stores = new ResourceStore[0];
    private ClassLoader delegate;
    static /* synthetic */ Class class$org$apache$commons$jci$ReloadingClassLoader;

    public ReloadingClassLoader(ClassLoader pParent) {
        super(pParent);
        this.parent = pParent;
        this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
    }

    public void addListener(ReloadingListener pListener) {
        pListener.setNotificationListener(this);
        this.addResourceStore(pListener.getStore());
    }

    public void removeListener(ReloadingListener pListener) {
        this.removeResourceStore(pListener.getStore());
        pListener.setNotificationListener(null);
    }

    private boolean addResourceStore(ResourceStore pStore) {
        try {
            int n = this.stores.length;
            ResourceStore[] newStores = new ResourceStore[n + 1];
            System.arraycopy(this.stores, 0, newStores, 0, n);
            newStores[n] = pStore;
            this.stores = newStores;
            this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean removeResourceStore(ResourceStore pStore) {
        try {
            int i;
            int n = this.stores.length;
            for (i = 0; i <= n && this.stores[i] != pStore; ++i) {
            }
            if (i == n) {
                throw new Exception("pStore was not found");
            }
            if (n > 1) {
                ResourceStore[] newStores = new ResourceStore[n - 1];
                System.arraycopy(this.stores, 0, newStores, 0, i - 1);
                System.arraycopy(this.stores, i, newStores, i, newStores.length - 1);
                this.stores = newStores;
                this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
            } else {
                this.stores = new ResourceStore[0];
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void handleNotification() {
        log.debug((Object)"reloading");
        this.delegate = new ResourceStoreClassLoader(this.parent, this.stores);
    }

    public static String clazzName(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        int p = absFileName.lastIndexOf(46);
        String relFileName = absFileName.substring(rootLength + 1, p);
        String clazzName = relFileName.replace(File.separatorChar, '.');
        return clazzName;
    }

    public void clearAssertionStatus() {
        this.delegate.clearAssertionStatus();
    }

    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.delegate.getResourceAsStream(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.delegate.loadClass(name);
    }

    public void setClassAssertionStatus(String className, boolean enabled) {
        this.delegate.setClassAssertionStatus(className, enabled);
    }

    public void setDefaultAssertionStatus(boolean enabled) {
        this.delegate.setDefaultAssertionStatus(enabled);
    }

    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegate.setPackageAssertionStatus(packageName, enabled);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

