/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.registry;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.AbstractRegistry;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.error.UnsupportedException;
import org.apache.juddi.function.FunctionMaker;
import org.apache.juddi.function.IFunction;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.Loader;
import org.apache.juddi.util.jdbc.ConnectionManager;

public class RegistryEngine
extends AbstractRegistry {
    private static final String PROPFILE_NAME = "juddi.properties";
    public static final String PROPNAME_OPERATOR_NAME = "juddi.operatorName";
    public static final String PROPNAME_I18N_LANGUAGE_CODE = "juddi.i18n.languageCode";
    public static final String PROPNAME_I18N_COUNTRY_CODE = "juddi.i18n.countryCode";
    public static final String PROPNAME_DISCOVERY_URL = "juddi.discoveryURL";
    public static final String PROPNAME_ADMIN_EMAIL_ADDRESS = "juddi.adminEmailAddress";
    public static final String PROPNAME_DATASOURCE_NAME = "juddi.dataSource";
    public static final String PROPNAME_IS_USE_DATASOURCE = "juddi.isUseDataSource";
    public static final String PROPNAME_JDBC_DRIVER = "juddi.jdbcDriver";
    public static final String PROPNAME_JDBC_URL = "juddi.jdbcUrl";
    public static final String PROPNAME_JDBC_USERNAME = "juddi.jdbcUsername";
    public static final String PROPNAME_JDBC_PASSWORD = "juddi.jdbcPassword";
    public static final String PROPNAME_IS_CREATE_DATABASE = "juddi.isCreateDatabase";
    public static final String PROPNAME_DB_EXISTS_SQL = "juddi.databaseExistsSql";
    public static final String PROPNAME_SQL_FILES = "juddi.sqlFiles";
    public static final String PROPNAME_TABLE_PREFIX = "juddi.tablePrefix";
    public static final String PROPNAME_JAVA_NAMING_FACTORY_INITIAL = "java.naming.factory.initial";
    public static final String PROPNAME_JAVA_NAMING_PROVIDER_URL = "java.naming.provider.url";
    public static final String PROPNAME_JAVA_NAMING_FACTORY_URL_PKGS = "java.naming.factory.url.pkgs";
    public static final String PROPNAME_AUTH_CLASS_NAME = "juddi.auth";
    public static final String PROPNAME_DATASTORE_CLASS_NAME = "juddi.dataStore";
    public static final String PROPNAME_CRYPTOR_CLASS_NAME = "juddi.cryptor";
    public static final String PROPNAME_UUIDGEN_CLASS_NAME = "juddi.uuidgen";
    public static final String PROPNAME_VALIDATOR_CLASS_NAME = "juddi.validator";
    public static final String PROPNAME_MAX_NAME_ELEMENTS = "juddi.maxNameElementsAllowed";
    public static final String PROPNAME_MAX_NAME_LENGTH = "juddi.maxNameLengthAllowed";
    public static final String PROPNAME_MAX_BUSINESSES_PER_PUBLISHER = "juddi.maxBusinessesPerPublisher";
    public static final String PROPNAME_MAX_SERVICES_PER_BUSINESS = "juddi.maxServicesPerBusiness";
    public static final String PROPNAME_MAX_BINDINGS_PER_SERVICE = "juddi.maxBindingsPerService";
    public static final String PROPNAME_MAX_TMODELS_PER_PUBLISHER = "juddi.maxTModelsPerPublisher";
    public static final String PROPNAME_MAX_MESSAGE_SIZE = "juddi.maxMessageSize";
    public static final String PROPNAME_MAX_ROWS_LIMIT = "juddi.maxRowsLimit";
    public static final String DEFAULT_OPERATOR_NAME = "Apache.org";
    public static final String DEFAULT_I18N_LANGUAGE_CODE = "en";
    public static final String DEFAULT_I18N_COUNTRY_CODE = "US";
    public static final String DEFAULT_DISCOVERY_URL = "http://localhost:8080/juddi/uddiget.jsp?";
    public static final String DEFAULT_ADMIN_EMAIL_ADDRESS = "nobody@apache.org";
    public static final String DEFAULT_DATASOURCE_NAME = "java:comp/env/jdbc/juddiDB";
    public static final Boolean DEFAULT_IS_USE_DATASOURCE = Boolean.TRUE;
    public static final String DEFAULT_JDBC_DRIVER = "com.mysql.jdbc.Driver";
    public static final String DEFAULT_JDBC_URL = "jdbc:mysql://localhost/juddi";
    public static final String DEFAULT_JDBC_USERNAME = "juddi";
    public static final String DEFAULT_JDBC_PASSWORD = "juddi";
    public static final Boolean DEFAULT_IS_CREATE_DATABASE = Boolean.FALSE;
    public static final String DEFAULT_DB_EXISTS_SQL = "select * from BUSINESS_ENTITY";
    public static final String DEFAULT_SQL_FILES = "sql/derby/create_database.sql,sql/insert_publishers.sql";
    public static final String DEFAULT_TABLE_PREFIX = "";
    public static final String DEFAULT_AUTH_CLASS_NAME = "org.apache.juddi.auth.DefaultAuthenticator";
    public static final String DEFAULT_DATASTORE_CLASS_NAME = "org.apache.juddi.datastore.jdbc.JDBCDataStore";
    public static final String DEFAULT_CRYPTOR_CLASS_NAME = "org.apache.juddi.cryptor.DefaultCryptor";
    public static final String DEFAULT_UUIDGEN_CLASS_NAME = "org.apache.juddi.uuidgen.DefaultUUIDGen";
    public static final String DEFAULT_VALIDATOR_CLASS_NAME = "org.apache.juddi.validator.DefaultValidator";
    public static final String DEFAULT_JAVA_NAMING_FACTORY_INITIAL = "org.jnp.interfaces.NamingContextFactory";
    public static final String DEFAULT_JAVA_NAMING_PROVIDER_URL = "jnp://localhost:1099";
    public static final String DEFAULT_JAVA_NAMING_FACTORY_URL_PKGS = "org.jboss.naming";
    public static final int DEFAULT_MAX_NAME_ELEMENTS = 5;
    public static final int DEFAULT_MAX_NAME_LENGTH = 255;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x200000;
    public static final int DEFAULT_MAX_BUSINESSES_PER_PUBLISHER = -1;
    public static final int DEFAULT_MAX_SERVICES_PER_BUSINESS = -1;
    public static final int DEFAULT_MAX_BINDINGS_PER_SERVICE = -1;
    public static final int DEFAULT_MAX_TMODELS_PER_PUBLISHER = -1;
    public static final int DEFAULT_MAX_ROWS_LIMIT = 10;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$registry$RegistryEngine == null ? (class$org$apache$juddi$registry$RegistryEngine = RegistryEngine.class$("org.apache.juddi.registry.RegistryEngine")) : class$org$apache$juddi$registry$RegistryEngine));
    private FunctionMaker maker = null;
    private boolean isAvailable = false;
    static /* synthetic */ Class class$org$apache$juddi$registry$RegistryEngine;

    public RegistryEngine() {
        try {
            InputStream stream = Loader.getResourceAsStream(PROPFILE_NAME);
            if (stream != null) {
                Properties props = new Properties();
                props.load(stream);
                Config.addProperties(props);
            }
        }
        catch (IOException ioex) {
            log.error((Object)"An error occured while loading properties from: juddi.properties", (Throwable)ioex);
        }
    }

    public RegistryEngine(Properties props) {
        if (props != null) {
            Config.addProperties(props);
        }
    }

    public void init() {
        this.isAvailable = false;
        this.maker = new FunctionMaker(this);
        if (Config.getBooleanProperty(PROPNAME_IS_CREATE_DATABASE, DEFAULT_IS_CREATE_DATABASE)) {
            this.initializeDatabase();
        }
        this.isAvailable = true;
    }

    public void dispose() {
        this.isAvailable = false;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public RegistryObject execute(RegistryObject request) throws RegistryException {
        String className = request.getClass().getName();
        IFunction function = this.maker.lookup(className);
        if (function == null) {
            throw new UnsupportedException(className);
        }
        RegistryObject response = function.execute(request);
        return response;
    }

    private void initializeDatabase() {
        String dbExistsSql = Config.getStringProperty(PROPNAME_DB_EXISTS_SQL, DEFAULT_DB_EXISTS_SQL);
        String sqlFiles = Config.getStringProperty(PROPNAME_SQL_FILES, DEFAULT_SQL_FILES);
        String tablePrefix = Config.getStringProperty(PROPNAME_TABLE_PREFIX, DEFAULT_TABLE_PREFIX);
        try {
            Connection conn = ConnectionManager.acquireConnection();
            boolean create = false;
            Statement st = conn.createStatement();
            ResultSet rs = null;
            try {
                dbExistsSql = dbExistsSql.trim().replaceAll("\\$\\{prefix}", tablePrefix);
                rs = st.executeQuery(dbExistsSql);
                rs.close();
            }
            catch (SQLException e) {
                create = true;
            }
            st.close();
            if (!create) {
                log.debug((Object)"jUDDI Database is already initialized");
                return;
            }
            log.info((Object)"Initializing jUDDI database from listed sql files");
            String[] list = sqlFiles.split(",");
            for (int i = 0; i < list.length; ++i) {
                this.executeSql(list[i].trim(), conn, tablePrefix);
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not create jUDDI database " + e.getMessage()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSql(String resource, Connection conn, String tablePrefix) throws Exception {
        InputStream is = Loader.getResourceAsStream(resource);
        if (is == null) {
            log.debug((Object)"Trying the classloader of the class itself. (workaround for maven2)");
            Loader loader = new Loader();
            is = loader.getResourceAsStreamFromClass(resource);
        }
        String sql = RegistryEngine.getString(is);
        sql = sql.replaceAll("(?m)^--([^\n]+)?$", DEFAULT_TABLE_PREFIX);
        sql = sql.replaceAll("\\$\\{prefix}", tablePrefix);
        is.close();
        String[] statements = sql.split(";");
        for (int i = 0; i < statements.length; ++i) {
            String statement = statements[i].trim();
            Statement sqlStatement = null;
            if (DEFAULT_TABLE_PREFIX.equals(statement)) continue;
            try {
                sqlStatement = conn.createStatement();
                sqlStatement.executeUpdate(statement);
                continue;
            }
            catch (Exception e) {
                if (statement.toUpperCase().startsWith("DROP")) continue;
                throw e;
            }
            finally {
                sqlStatement.close();
            }
        }
    }

    public static String getString(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.setProperty(PROPNAME_OPERATOR_NAME, "jUDDI.org");
        props.setProperty(PROPNAME_MAX_NAME_ELEMENTS, "5");
        props.setProperty(PROPNAME_MAX_NAME_LENGTH, "255");
        props.setProperty(PROPNAME_DISCOVERY_URL, "http://localhost/juddi");
        props.setProperty(PROPNAME_ADMIN_EMAIL_ADDRESS, "admin@juddi.org");
        props.setProperty(PROPNAME_MAX_MESSAGE_SIZE, "2097152");
        props.setProperty(PROPNAME_AUTH_CLASS_NAME, DEFAULT_AUTH_CLASS_NAME);
        props.setProperty(PROPNAME_CRYPTOR_CLASS_NAME, DEFAULT_CRYPTOR_CLASS_NAME);
        props.setProperty(PROPNAME_UUIDGEN_CLASS_NAME, DEFAULT_UUIDGEN_CLASS_NAME);
        props.setProperty("juddi.useConnectionPool", "true");
        props.setProperty(PROPNAME_JDBC_DRIVER, DEFAULT_JDBC_DRIVER);
        props.setProperty("juddi.jdbcURL", DEFAULT_JDBC_URL);
        props.setProperty("juddi.jdbcUser", "juddi");
        props.setProperty(PROPNAME_JDBC_PASSWORD, "juddi");
        props.setProperty("juddi.jdbcMaxActive", "10");
        props.setProperty("juddi.jdbcMaxIdle", "10");
        RegistryEngine registry = new RegistryEngine(props);
        registry.init();
        System.out.println(Config.getProperties());
        AuthToken authToken = registry.getAuthToken("sviens", "password");
        AuthInfo authInfo = authToken.getAuthInfo();
        System.out.println("AuthToken: " + authInfo.getValue());
        registry.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

