/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.binding.HostingRedirector;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class HostingRedirectorHandler
extends AbstractHandler {
    public static final String TAG_NAME = "hostingRedirector";

    protected HostingRedirectorHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        HostingRedirector obj = new HostingRedirector();
        obj.setBindingKey(element.getAttribute("bindingKey"));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        HostingRedirector redirector = (HostingRedirector)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String bindingKey = redirector.getBindingKey();
        if (bindingKey != null) {
            element.setAttribute("bindingKey", bindingKey);
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        HostingRedirector redirector = new HostingRedirector();
        redirector.setBindingKey("92658289-0bd7-443c-8948-0bb4460b44c0");
        System.out.println();
        RegistryObject regObject = redirector;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

