/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.GetRegistryInfo;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class GetRegistryInfoHandler
extends AbstractHandler {
    public static final String TAG_NAME = "get_registryInfo";

    protected GetRegistryInfoHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        GetRegistryInfo obj = new GetRegistryInfo();
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        GetRegistryInfo request = (GetRegistryInfo)object;
        String generic = request.getGeneric();
        generic = this.getGeneric(generic);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        element.setAttribute("generic", generic);
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        GetRegistryInfo service = new GetRegistryInfo();
        System.out.println();
        RegistryObject regObject = service;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

