/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AuthInfoHandler
extends AbstractHandler {
    public static final String TAG_NAME = "authInfo";

    protected AuthInfoHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        AuthInfo obj = new AuthInfo();
        obj.setValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        AuthInfo info = (AuthInfo)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String infoValue = info.getValue();
        if (infoValue != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(infoValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AuthInfo object = new AuthInfo();
        object.setValue("authToken:c9613c3c-fe55-4f34-a3da-b3167afbca4a");
        System.out.println();
        RegistryObject regObject = object;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

