/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import org.apache.juddi.datatype.AddressLine;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class AddressLineHandler
extends AbstractHandler {
    public static final String TAG_NAME = "addressLine";

    protected AddressLineHandler(HandlerMaker maker) {
    }

    public RegistryObject unmarshal(Element element) {
        String keyValue;
        AddressLine obj = new AddressLine();
        String keyName = element.getAttribute("keyName");
        if (keyName != null && keyName.trim().length() > 0) {
            obj.setKeyName(keyName);
        }
        if ((keyValue = element.getAttribute("keyValue")) != null && keyValue.trim().length() > 0) {
            obj.setKeyValue(keyValue);
        }
        obj.setLineValue(XMLUtils.getText(element));
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        String lineValue;
        String keyValue;
        AddressLine line = (AddressLine)object;
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element element = parent.getOwnerDocument().createElementNS(namespace, TAG_NAME);
        String keyName = line.getKeyName();
        if (keyName != null && keyName.trim().length() > 0) {
            element.setAttribute("keyName", keyName);
        }
        if ((keyValue = line.getKeyValue()) != null && keyValue.trim().length() > 0) {
            element.setAttribute("keyValue", keyValue);
        }
        if ((lineValue = line.getLineValue()) != null) {
            element.appendChild(parent.getOwnerDocument().createTextNode(lineValue));
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AddressLine object = new AddressLine("AddressLine1", "keyNameAttr", "keyValueAttr");
        System.out.println();
        RegistryObject regObject = object;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

