/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.gui.GuiUtils;
import org.apache.ftpserver.gui.PluginPanel;
import org.apache.ftpserver.gui.PluginPanelContainer;
import org.apache.ftpserver.interfaces.FtpServerContext;
import org.apache.ftpserver.interfaces.MessageResource;

public class MessagePanel
extends PluginPanel {
    private static final long serialVersionUID = -68038181884794057L;
    private FtpServerContext serverContext;
    private JComboBox comboBox;
    private JList list;
    private JTextArea txtArea;
    private String[] languages;
    private Vector messageKeys;
    private Properties messageProps;
    private int oldKeySelIndex = -1;

    public MessagePanel(PluginPanelContainer container) {
        super(container);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel comboPanel = new JPanel(new FlowLayout(1));
        this.add((Component)comboPanel, "North");
        JLabel label = new JLabel("Language : ");
        comboPanel.add(label);
        this.comboBox = new JComboBox();
        this.comboBox.setPreferredSize(new Dimension(100, 22));
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.changeLanguage();
            }
        });
        comboPanel.add(this.comboBox);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerSize(0);
        this.add((Component)splitPane, "Center");
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                MessagePanel.this.changeKey();
            }
        });
        JScrollPane listScroller = new JScrollPane(this.list);
        splitPane.setLeftComponent(listScroller);
        this.txtArea = new JTextArea();
        JScrollPane txtPane = new JScrollPane(this.txtArea, 20, 30);
        splitPane.setRightComponent(txtPane);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.add((Component)buttonPanel, "South");
        JButton saveBtn = new JButton("Save");
        saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.save();
            }
        });
        buttonPanel.add(saveBtn);
        JButton reloadBtn = new JButton("Reload");
        reloadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessagePanel.this.changeLanguage();
            }
        });
        buttonPanel.add(reloadBtn);
    }

    public void changeLanguage() {
        this.oldKeySelIndex = -1;
        int selIdx = this.comboBox.getSelectedIndex();
        if (selIdx == -1) {
            return;
        }
        String language = null;
        if (selIdx >= 1) {
            language = this.languages[selIdx - 1];
        }
        MessageResource msgRes = this.serverContext.getMessageResource();
        Properties prop = msgRes.getMessages(language);
        Vector<String> keyList = new Vector<String>();
        Enumeration<?> keys = prop.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            keyList.add(key);
        }
        Collections.sort(keyList);
        this.messageKeys = keyList;
        this.messageProps = prop;
        this.list.removeAll();
        this.list.setListData(keyList);
        this.list.setSelectedIndex(0);
    }

    public void changeKey() {
        int selIdx = this.list.getSelectedIndex();
        if (selIdx == -1) {
            return;
        }
        if (this.oldKeySelIndex != -1) {
            String oldKey = (String)this.messageKeys.get(this.oldKeySelIndex);
            String oldTxt = this.txtArea.getText();
            this.messageProps.setProperty(oldKey, oldTxt);
        }
        this.oldKeySelIndex = selIdx;
        String key = (String)this.messageKeys.get(selIdx);
        String val = this.messageProps.getProperty(key);
        this.txtArea.setText(val);
        this.txtArea.setCaretPosition(0);
    }

    private void save() {
        int selIdx = this.comboBox.getSelectedIndex();
        if (selIdx == -1) {
            return;
        }
        String language = null;
        if (selIdx >= 1) {
            language = this.languages[selIdx - 1];
        }
        String key = this.list.getSelectedValue().toString();
        String val = this.txtArea.getText();
        this.messageProps.setProperty(key, val);
        try {
            this.serverContext.getMessageResource().save(this.messageProps, language);
        }
        catch (FtpException ex) {
            GuiUtils.showErrorMessage(this, "Cannot save messages.");
        }
    }

    public void refresh(FtpServerContext serverContext) {
        this.serverContext = serverContext;
        this.comboBox.removeAllItems();
        this.list.removeAll();
        this.oldKeySelIndex = -1;
        if (this.serverContext == null) {
            return;
        }
        MessageResource msgRes = this.serverContext.getMessageResource();
        this.languages = msgRes.getAvailableLanguages();
        this.comboBox.addItem("<default>");
        if (this.languages != null) {
            for (int i = 0; i < this.languages.length; ++i) {
                this.comboBox.addItem(this.languages[i]);
            }
        }
        this.comboBox.setSelectedIndex(0);
    }

    public boolean canBeDisplayed() {
        return this.serverContext != null;
    }

    public String toString() {
        return "Messages";
    }
}

