/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom.serialize;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.ResourceConfigurationNotFoundException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryUnitConfigMap;
import org.milyn.delivery.ContentDeliveryUnitConfigMapTable;
import org.milyn.delivery.dom.DOMContentDeliveryConfig;
import org.milyn.delivery.dom.serialize.DefaultSerializationUnit;
import org.milyn.delivery.dom.serialize.SerializationUnit;
import org.milyn.xml.DomUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Serializer {
    private static Log logger = LogFactory.getLog(Serializer.class);
    private Node node;
    private ExecutionContext executionContext;
    private DOMContentDeliveryConfig deliveryConfig;
    private ContentDeliveryUnitConfigMapTable serializationUnits;
    private List defaultSUs;

    public Serializer(Node node, ExecutionContext executionContext) {
        if (node == null) {
            throw new IllegalArgumentException("null 'node' arg passed in method call.");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("null 'executionContext' arg passed in method call.");
        }
        this.node = node;
        this.executionContext = executionContext;
        this.deliveryConfig = (DOMContentDeliveryConfig)executionContext.getDeliveryConfig();
        this.serializationUnits = this.deliveryConfig.getSerailizationUnits();
        this.defaultSUs = this.serializationUnits.getMappings("*");
        if (this.defaultSUs == null) {
            SmooksResourceConfiguration resourceConfig = new SmooksResourceConfiguration("*", "*", DefaultSerializationUnit.class.getName());
            this.defaultSUs = new Vector();
            this.defaultSUs.add(new ContentDeliveryUnitConfigMap(new DefaultSerializationUnit(resourceConfig), resourceConfig));
        }
    }

    public void serailize(Writer writer) throws ResourceConfigurationNotFoundException, IOException {
        if (writer == null) {
            throw new IllegalArgumentException("null 'writer' arg passed in method call.");
        }
        if (this.node instanceof Document) {
            Document doc = (Document)this.node;
            Element rootElement = doc.getDocumentElement();
            String rootElementName = DomUtils.getName(rootElement);
            SmooksResourceConfiguration docTypeSmooksResourceConfiguration = null;
            List<ContentDeliveryUnitConfigMap> docTypeUDs = this.deliveryConfig.getSmooksResourceConfigurations("doctype");
            if (docTypeUDs != null && docTypeUDs.size() > 0) {
                docTypeSmooksResourceConfiguration = (SmooksResourceConfiguration)((Object)docTypeUDs.get(0));
            }
            if (docTypeSmooksResourceConfiguration != null && docTypeSmooksResourceConfiguration.getBoolParameter("override", true)) {
                String path = docTypeSmooksResourceConfiguration.getResource();
                if (path != null) {
                    writer.write(new String(docTypeSmooksResourceConfiguration.getBytes()));
                } else {
                    String publicId = docTypeSmooksResourceConfiguration.getStringParameter("publicId", "!!publicId undefined - fix smooks-resource!!");
                    String systemId = docTypeSmooksResourceConfiguration.getStringParameter("systemId", "!!systemId undefined - fix smooks-resource!!");
                    String xmlns = docTypeSmooksResourceConfiguration.getStringParameter("xmlns");
                    this.serializeDoctype(publicId, systemId, rootElementName, writer);
                    if (xmlns != null) {
                        rootElement.setAttribute("xmlns", xmlns);
                    } else {
                        rootElement.removeAttribute("xmlns");
                    }
                }
            } else {
                DocumentType docType = doc.getDoctype();
                if (docType != null) {
                    this.serializeDoctype(docType.getPublicId(), docType.getSystemId(), rootElementName, writer);
                }
            }
            this.recursiveDOMWrite(rootElement, writer, true);
        } else {
            NodeList deliveryNodes = this.node.getChildNodes();
            int nodeCount = deliveryNodes.getLength();
            boolean isRoot = this.node == this.node.getOwnerDocument().getDocumentElement();
            for (int i = 0; i < nodeCount; ++i) {
                Node childNode = deliveryNodes.item(i);
                if (childNode.getNodeType() != 1) continue;
                this.recursiveDOMWrite((Element)childNode, writer, isRoot);
            }
        }
    }

    private void serializeDoctype(String publicId, String systemId, String rootElement, Writer writer) throws IOException {
        writer.write("<!DOCTYPE ");
        writer.write(rootElement);
        writer.write(32);
        if (publicId != null) {
            writer.write("PUBLIC \"");
            writer.write(publicId);
            writer.write("\" ");
        }
        if (systemId != null) {
            writer.write(34);
            writer.write(systemId);
            writer.write(34);
        }
        writer.write(62);
        writer.write(10);
    }

    private void recursiveDOMWrite(Element element, Writer writer, boolean isRoot) throws IOException {
        NodeList children = element.getChildNodes();
        SerializationUnit elementSU = this.getSerializationUnit(element, isRoot);
        try {
            elementSU.writeElementStart(element, writer, this.executionContext);
            if (children != null && children.getLength() > 0) {
                int childCount = children.getLength();
                block9: for (int i = 0; i < childCount; ++i) {
                    Node childNode = children.item(i);
                    switch (childNode.getNodeType()) {
                        case 4: {
                            elementSU.writeElementCDATA((CDATASection)childNode, writer, this.executionContext);
                            continue block9;
                        }
                        case 8: {
                            elementSU.writeElementComment((Comment)childNode, writer, this.executionContext);
                            continue block9;
                        }
                        case 1: {
                            if (!elementSU.writeChildElements()) continue block9;
                            this.recursiveDOMWrite((Element)childNode, writer, false);
                            continue block9;
                        }
                        case 5: {
                            elementSU.writeElementEntityRef((EntityReference)childNode, writer, this.executionContext);
                            continue block9;
                        }
                        case 3: {
                            elementSU.writeElementText((Text)childNode, writer, this.executionContext);
                            continue block9;
                        }
                        default: {
                            elementSU.writeElementNode(childNode, writer, this.executionContext);
                        }
                    }
                }
            }
            elementSU.writeElementEnd(element, writer, this.executionContext);
        }
        catch (Throwable thrown) {
            logger.error((Object)("Failed to apply serialization unit [" + elementSU.getClass().getName() + "] to [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "]."), thrown);
        }
    }

    private SerializationUnit getSerializationUnit(Element element, boolean isRoot) {
        String elementName = DomUtils.getName(element);
        List<ContentDeliveryUnitConfigMap> elementSUs = isRoot ? this.serializationUnits.getMappings(new String[]{elementName, "$document"}) : this.serializationUnits.getMappings(elementName);
        if (elementSUs == null || elementSUs.isEmpty()) {
            elementSUs = this.defaultSUs;
        }
        int numSUs = elementSUs.size();
        for (int i = 0; i < numSUs; ++i) {
            ContentDeliveryUnitConfigMap configMap = elementSUs.get(i);
            SmooksResourceConfiguration config = configMap.getResourceConfig();
            if (!config.isTargetedAtElement(element)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applying serialisation resource [" + config + "] to element [" + DomUtils.getXPath(element) + "]."));
            }
            return (SerializationUnit)configMap.getContentDeliveryUnit();
        }
        throw new IllegalStateException("At least 1 SerializationUnit needs to be configured for an element. " + element.getTagName() + " has no configured SerializationUnit.");
    }
}

