/*
 * Decompiled with CFR 0.152.
 */
package org.milyn;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.Smooks;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.standalone.StandaloneExecutionContext;
import org.milyn.profile.DefaultProfileStore;
import org.milyn.profile.ProfileSet;
import org.milyn.profile.UnknownProfileMemberException;

public abstract class SmooksUtil {
    private static Log logger = LogFactory.getLog(Smooks.class);

    private SmooksUtil() {
    }

    public static void registerProfileSet(ProfileSet profileSet, Smooks smooks) {
        AssertArgument.isNotNull((Object)profileSet, (String)"profileSet");
        DefaultProfileStore profileStore = smooks.getApplicationContext().getProfileStore();
        try {
            profileStore.getProfileSet(profileSet.getBaseProfile());
            logger.warn((Object)("ProfileSet [" + profileSet.getBaseProfile() + "] already registered.  Not registering new profile set."));
        }
        catch (UnknownProfileMemberException e) {
            profileStore.addProfileSet(profileSet);
            profileStore.expandProfiles();
        }
    }

    public static void registerResource(SmooksResourceConfiguration resourceConfig, Smooks smooks) {
        if (resourceConfig == null) {
            throw new IllegalArgumentException("null 'resourceConfig' arg in method call.");
        }
        smooks.getApplicationContext().getStore().registerResource(resourceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String filterAndSerialize(StandaloneExecutionContext executionContext, InputStream stream, Smooks smooks) throws SmooksException {
        String responseBuf = null;
        CharArrayWriter writer = new CharArrayWriter();
        try {
            smooks.filter(new StreamSource(stream), new StreamResult(writer), executionContext);
            responseBuf = writer.toString();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    new SmooksException("Failed to close stream...", e);
                }
            }
            writer.close();
        }
        return responseBuf;
    }
}

