/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.wsdl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.core.jaxrpc.Style;
import org.jboss.ws.core.utils.DOMUtils;
import org.jboss.ws.core.utils.DOMWriter;
import org.jboss.ws.core.utils.ResourceURL;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingMessageReference;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLMIMEPart;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.XSModelTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.JavaToXSD;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL11Reader {
    private static final Logger log = Logger.getLogger(WSDL11Reader.class);
    private WSDLDefinitions destWsdl;
    private Map<String, QName> messagePartToElementMap = new HashMap<String, QName>();
    private Map<String, URL> schemaLocationsMap = new HashMap<String, URL>();
    private LinkedHashMap<QName, Binding> allBindings;
    private LinkedHashMap<QName, Binding> portTypeBindings;
    private List<File> tempFiles = new ArrayList<File>();
    private Map<QName, List<String>> skippedSWAParts = new HashMap<QName, List<String>>();

    public WSDLDefinitions processDefinition(Definition srcWsdl, URL wsdlLoc) throws IOException, WSDLException {
        log.trace((Object)("processDefinition: " + wsdlLoc));
        this.destWsdl = new WSDLDefinitions();
        this.destWsdl.setWsdlTypes(new XSModelTypes());
        this.destWsdl.setWsdlOneOneDefinition(srcWsdl);
        this.destWsdl.setWsdlNamespace("http://schemas.xmlsoap.org/wsdl/");
        this.processNamespaces(srcWsdl);
        this.processTypes(srcWsdl, wsdlLoc);
        this.processServices(srcWsdl);
        if (this.getAllDefinedBindings(srcWsdl).size() != this.destWsdl.getBindings().length) {
            this.processUnreachableBindings(srcWsdl);
        }
        this.cleanupTemporaryFiles();
        return this.destWsdl;
    }

    private void cleanupTemporaryFiles() {
        for (File current : this.tempFiles) {
            current.delete();
        }
    }

    private void processUnreachableBindings(Definition srcWsdl) throws WSDLException {
        log.trace((Object)"processUnreachableBindings");
        for (Binding srcBinding : this.getAllDefinedBindings(srcWsdl).values()) {
            QName srcQName = srcBinding.getQName();
            WSDLBinding destBinding = this.destWsdl.getBinding(srcQName);
            if (destBinding != null) continue;
            this.processBinding(srcWsdl, srcBinding);
        }
    }

    private void processNamespaces(Definition srcWsdl) {
        String targetNS = srcWsdl.getTargetNamespace();
        this.destWsdl.setTargetNamespace(targetNS);
        Map nsMap = srcWsdl.getNamespaces();
        for (Map.Entry entry : nsMap.entrySet()) {
            String prefix = (String)entry.getKey();
            String nsURI = (String)entry.getValue();
            this.destWsdl.registerNamespaceURI(nsURI, prefix);
        }
    }

    private void processTypes(Definition srcWsdl, URL wsdlLoc) throws IOException, WSDLException {
        log.trace((Object)("BEGIN processTypes: " + wsdlLoc));
        WSDLTypes destTypes = this.destWsdl.getWsdlTypes();
        Types srcTypes = srcWsdl.getTypes();
        if (srcTypes != null && srcTypes.getExtensibilityElements().size() > 0) {
            List extElements = srcTypes.getExtensibilityElements();
            int len = extElements.size();
            for (int i = 0; i < len; ++i) {
                Element domElement;
                ExtensibilityElement extElement = (ExtensibilityElement)extElements.get(i);
                if (extElement instanceof Schema) {
                    domElement = ((Schema)extElement).getElement();
                } else if (extElement instanceof UnknownExtensibilityElement) {
                    domElement = ((UnknownExtensibilityElement)extElement).getElement();
                } else {
                    throw new WSDLException("OTHER_ERROR", "Unsupported extensibility element: " + extElement);
                }
                Element domElementClone = (Element)domElement.cloneNode(true);
                this.copyParentNamespaceDeclarations(domElementClone, domElement);
                String localname = domElementClone.getLocalName();
                try {
                    if ("import".equals(localname)) {
                        this.processSchemaImport(destTypes, wsdlLoc, domElementClone);
                        continue;
                    }
                    if ("schema".equals(localname)) {
                        this.processSchemaInclude(destTypes, wsdlLoc, domElementClone);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsuported schema element: " + localname);
                }
                catch (IOException e) {
                    throw new WSDLException("OTHER_ERROR", "Cannot extract schema definition", (Throwable)e);
                }
            }
            if (len > 0) {
                JavaToXSD jxsd = new JavaToXSD();
                JBossXSModel xsmodel = jxsd.parseSchema(this.schemaLocationsMap);
                WSDLUtils.addSchemaModel(destTypes, this.destWsdl.getTargetNamespace(), xsmodel);
            }
        } else {
            log.trace((Object)"Empty wsdl types element, processing imports");
            for (List srcImports : srcWsdl.getImports().values()) {
                for (Import srcImport : srcImports) {
                    Definition impDefinition = srcImport.getDefinition();
                    String impLoc = impDefinition.getDocumentBaseURI();
                    this.processTypes(impDefinition, new URL(impLoc));
                }
            }
        }
        log.trace((Object)("END processTypes: " + wsdlLoc + "\n" + destTypes));
    }

    private void copyParentNamespaceDeclarations(Element destElement, Element srcElement) {
        for (Node parent = srcElement.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!parent.hasAttributes()) continue;
            NamedNodeMap attributes = parent.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (!name.startsWith("xmlns:") || destElement.hasAttribute(name)) continue;
                destElement.setAttribute(name, value);
            }
        }
    }

    private void processSchemaImport(WSDLTypes types, URL wsdlLoc, Element importEl) throws IOException, WSDLException {
        Element rootElement;
        if (wsdlLoc == null) {
            throw new IllegalArgumentException("Cannot process import, parent location not set");
        }
        log.trace((Object)("processSchemaImport: " + wsdlLoc));
        String location = this.getOptionalAttribute(importEl, "schemaLocation");
        if (location == null) {
            throw new IllegalArgumentException("schemaLocation is null for xsd:import");
        }
        URL locationURL = this.getLocationURL(wsdlLoc, location);
        URL newloc = this.processSchemaInclude(types, locationURL, rootElement = DOMUtils.parse(new ResourceURL(locationURL).openStream()));
        if (newloc != null) {
            importEl.setAttribute("schemaLocation", newloc.toExternalForm());
        }
    }

    private URL processSchemaInclude(WSDLTypes types, URL wsdlLoc, Element schemaEl) throws IOException, WSDLException {
        if (wsdlLoc == null) {
            throw new IllegalArgumentException("Cannot process iclude, parent location not set");
        }
        File tmpFile = null;
        if (wsdlLoc == null) {
            throw new IllegalArgumentException("Cannot process include, parent location not set");
        }
        log.trace((Object)("processSchemaInclude: " + wsdlLoc));
        String schemaPrefix = schemaEl.getPrefix();
        String importTag = schemaPrefix == null ? "import" : schemaPrefix + ":import";
        Element importElement = schemaEl.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", importTag);
        importElement.setAttribute("namespace", "http://schemas.xmlsoap.org/soap/encoding/");
        schemaEl.insertBefore(importElement, DOMUtils.getFirstChildElement(schemaEl));
        Iterator it = DOMUtils.getChildElements((Node)schemaEl, new QName("http://www.w3.org/2001/XMLSchema", "include"));
        while (it.hasNext()) {
            Element rootElement;
            Element includeEl = (Element)it.next();
            String location = this.getOptionalAttribute(includeEl, "schemaLocation");
            if (location == null) {
                throw new IllegalArgumentException("schemaLocation is null for xsd:include");
            }
            URL locationURL = this.getLocationURL(wsdlLoc, location);
            URL newloc = this.processSchemaInclude(types, locationURL, rootElement = DOMUtils.parse(new ResourceURL(locationURL).openStream()));
            if (newloc == null) continue;
            includeEl.setAttribute("schemaLocation", newloc.toExternalForm());
        }
        String targetNS = this.getOptionalAttribute(schemaEl, "targetNamespace");
        if (targetNS != null) {
            log.trace((Object)("processSchemaInclude: [targetNS=" + targetNS + ",parentURL=" + wsdlLoc + "]"));
            tmpFile = SchemaUtils.getSchemaTempFile(targetNS);
            this.tempFiles.add(tmpFile);
            FileWriter fwrite = new FileWriter(tmpFile);
            new DOMWriter(fwrite).setPrettyprint(true).print(schemaEl);
            fwrite.close();
            this.schemaLocationsMap.put(targetNS, tmpFile.toURL());
        }
        if (targetNS == null) {
            log.trace((Object)("Schema element without target namespace in: " + wsdlLoc));
        }
        this.handleSchemaImports(schemaEl, wsdlLoc);
        return tmpFile != null ? tmpFile.toURL() : null;
    }

    private void handleSchemaImports(Element schemaEl, URL wsdlLoc) throws MalformedURLException, WSDLException {
        if (wsdlLoc == null) {
            throw new IllegalArgumentException("Cannot process import, parent location not set");
        }
        Iterator it = DOMUtils.getChildElements((Node)schemaEl, new QName("http://www.w3.org/2001/XMLSchema", "import"));
        while (it.hasNext()) {
            Element includeEl = (Element)it.next();
            String schemaLocation = this.getOptionalAttribute(includeEl, "schemaLocation");
            String namespace = this.getOptionalAttribute(includeEl, "namespace");
            log.trace((Object)("handleSchemaImport: [namespace=" + namespace + ",schemaLocation=" + schemaLocation + "]"));
            if (namespace != null && schemaLocation != null) {
                URL currLoc = this.getLocationURL(wsdlLoc, schemaLocation);
                this.schemaLocationsMap.put(namespace, currLoc);
                continue;
            }
            log.trace((Object)("Skip schema import: [namespace=" + namespace + ",schemaLocation=" + schemaLocation + "]"));
        }
    }

    private URL getLocationURL(URL parentURL, String location) throws MalformedURLException, WSDLException {
        log.trace((Object)("getLocationURL: [location=" + location + ",parent=" + parentURL + "]"));
        URL locationURL = null;
        try {
            locationURL = new URL(location);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (locationURL == null) {
            if (location.startsWith("/")) {
                location = location.substring(1);
            }
            String path = parentURL.toExternalForm();
            path = path.substring(0, path.lastIndexOf("/"));
            while (location.startsWith("../")) {
                path = path.substring(0, path.lastIndexOf("/"));
                location = location.substring(3);
            }
            locationURL = new URL(path + "/" + location);
        }
        log.trace((Object)("Modified schemaLocation: " + locationURL));
        return locationURL;
    }

    private void processPortType(Definition srcWsdl, PortType srcPortType) throws WSDLException {
        log.trace((Object)("processPortType: " + srcPortType.getQName()));
        QName qname = srcPortType.getQName();
        if (this.destWsdl.getInterface(qname) == null) {
            WSDLInterface destInterface = new WSDLInterface(this.destWsdl, qname);
            QName eventSourceProp = (QName)srcPortType.getExtensionAttribute(Constants.WSDL_ATTRIBUTE_WSE_EVENTSOURCE);
            if (eventSourceProp != null && eventSourceProp.getLocalPart().equals(Boolean.TRUE.toString())) {
                destInterface.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wse/isEventSource", eventSourceProp.getLocalPart()));
            }
            this.destWsdl.addInterface(destInterface);
            this.processPortTypeOperations(srcWsdl, destInterface, srcPortType);
        }
    }

    private void processPortTypeOperations(Definition srcWsdl, WSDLInterface destInterface, PortType srcPortType) throws WSDLException {
        for (Operation srcOperation : srcPortType.getOperations()) {
            WSDLInterfaceOperation destOperation = new WSDLInterfaceOperation(destInterface, srcOperation.getName());
            destOperation.setStyle(this.getOperationStyle(srcWsdl, srcPortType, srcOperation));
            if (srcOperation.getStyle() != null && !OperationType.NOTIFICATION.equals(srcOperation.getStyle())) {
                this.processOperationInput(srcWsdl, srcOperation, destOperation, srcPortType);
            }
            this.processOperationOutput(srcWsdl, srcOperation, destOperation, srcPortType);
            this.processOperationFaults(srcOperation, destOperation, destInterface);
            destInterface.addOperation(destOperation);
        }
    }

    private void processOperationInput(Definition srcWsdl, Operation srcOperation, WSDLInterfaceOperation destOperation, PortType srcPortType) throws WSDLException {
        Input srcInput = srcOperation.getInput();
        if (srcInput != null) {
            List paramOrder;
            Message srcMessage = srcInput.getMessage();
            if (srcMessage == null) {
                throw new WSDLException("INVALID_WSDL", "Cannot find input message on operation " + srcOperation.getName() + " on port type: " + srcPortType.getQName());
            }
            log.trace((Object)("processOperationInput: " + srcMessage.getQName()));
            QName wsaAction = (QName)srcInput.getExtensionAttribute(Constants.WSDL_ATTRIBUTE_WSA_ACTION);
            if (wsaAction != null) {
                destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wsa/actionIn", wsaAction.getLocalPart()));
            }
            if ((paramOrder = srcOperation.getParameterOrdering()) != null) {
                for (String name : paramOrder) {
                    if (srcMessage.getPart(name) == null) continue;
                    destOperation.addRpcSignatureItem(new WSDLRPCSignatureItem(name));
                }
            }
            WSDLInterfaceOperationInput rpcInput = new WSDLInterfaceOperationInput(destOperation);
            for (Part srcPart : srcMessage.getOrderedParts(paramOrder)) {
                if (this.ignorePart(srcPortType, srcPart)) continue;
                if ("http://www.w3.org/2004/03/wsdl/style/iri" == destOperation.getStyle()) {
                    WSDLInterfaceOperationInput destInput = new WSDLInterfaceOperationInput(destOperation);
                    QName elementName = this.messagePartToElementName(srcMessage, srcPart, destOperation);
                    destInput.setElement(elementName);
                    destInput.setMessageName(srcMessage.getQName());
                    destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename/in", srcMessage.getQName().getLocalPart()));
                    destInput.setPartName(srcPart.getName());
                    destOperation.addInput(destInput);
                    continue;
                }
                QName xmlType = srcPart.getTypeName();
                if (xmlType != null) {
                    rpcInput.addChildPart(new WSDLRPCPart(srcPart.getName(), this.destWsdl.registerQName(xmlType)));
                    continue;
                }
                this.messagePartToElementName(srcMessage, srcPart, destOperation);
            }
            if ("http://www.w3.org/2004/03/wsdl/style/rpc" == destOperation.getStyle()) {
                rpcInput.setElement(destOperation.getName());
                rpcInput.setMessageName(srcMessage.getQName());
                destOperation.addInput(rpcInput);
            }
        }
    }

    private boolean ignorePart(PortType srcPortType, Part srcPart) {
        boolean canBeSkipped = false;
        QName parentName = srcPortType.getQName();
        if (this.skippedSWAParts.containsKey(parentName) && this.skippedSWAParts.get(parentName).contains(srcPart.getName())) {
            log.trace((Object)("Skip attachment part: " + parentName + "->" + srcPart.getName()));
            canBeSkipped = true;
        }
        return canBeSkipped;
    }

    private void processOperationOutput(Definition srcWsdl, Operation srcOperation, WSDLInterfaceOperation destOperation, PortType srcPortType) throws WSDLException {
        List paramOrder;
        Output srcOutput = srcOperation.getOutput();
        if (srcOutput == null) {
            destOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-only");
            return;
        }
        Message srcMessage = srcOutput.getMessage();
        if (srcMessage == null) {
            throw new WSDLException("INVALID_WSDL", "Cannot find output message on operation " + srcOperation.getName() + " on port type: " + srcPortType.getQName());
        }
        log.trace((Object)("processOperationOutput: " + srcMessage.getQName()));
        destOperation.setPattern("http://www.w3.org/2004/08/wsdl/in-out");
        QName wsaAction = (QName)srcOutput.getExtensionAttribute(Constants.WSDL_ATTRIBUTE_WSA_ACTION);
        if (wsaAction != null) {
            destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/wsa/actionOut", wsaAction.getLocalPart()));
        }
        if ((paramOrder = srcOperation.getParameterOrdering()) != null) {
            for (Object name : paramOrder) {
                if (srcMessage.getPart((String)name) == null) continue;
                WSDLRPCSignatureItem item = destOperation.getRpcSignatureitem((String)name);
                if (item != null) {
                    item.setDirection(WSDLRPCSignatureItem.Direction.INOUT);
                    continue;
                }
                destOperation.addRpcSignatureItem(new WSDLRPCSignatureItem((String)name, WSDLRPCSignatureItem.Direction.OUT));
            }
        }
        WSDLInterfaceOperationOutput rpcOutput = new WSDLInterfaceOperationOutput(destOperation);
        for (Part srcPart : srcMessage.getOrderedParts(null)) {
            if (this.ignorePart(srcPortType, srcPart)) continue;
            if ("http://www.w3.org/2004/03/wsdl/style/iri" == destOperation.getStyle()) {
                WSDLInterfaceOperationOutput destOutput = new WSDLInterfaceOperationOutput(destOperation);
                QName elementName = this.messagePartToElementName(srcMessage, srcPart, destOperation);
                destOutput.setElement(elementName);
                destOutput.setMessageName(srcMessage.getQName());
                destOperation.addProperty(new WSDLProperty("http://www.jboss.org/jbossws/messagename/out", srcMessage.getQName().getLocalPart()));
                destOutput.setPartName(srcPart.getName());
                destOperation.addOutput(destOutput);
                continue;
            }
            QName xmlType = srcPart.getTypeName();
            if (xmlType != null) {
                rpcOutput.addChildPart(new WSDLRPCPart(srcPart.getName(), this.destWsdl.registerQName(xmlType)));
                continue;
            }
            this.messagePartToElementName(srcMessage, srcPart, destOperation);
        }
        if ("http://www.w3.org/2004/03/wsdl/style/rpc" == destOperation.getStyle()) {
            Object name;
            name = destOperation.getName();
            rpcOutput.setElement(new QName(((QName)name).getNamespaceURI(), ((QName)name).getLocalPart() + "Response"));
            rpcOutput.setMessageName(srcMessage.getQName());
            destOperation.addOutput(rpcOutput);
        }
    }

    private void processOperationFaults(Operation srcOperation, WSDLInterfaceOperation destOperation, WSDLInterface destInterface) throws WSDLException {
        Map faults = srcOperation.getFaults();
        for (Fault srcFault : faults.values()) {
            this.processOperationFault(destOperation, destInterface, srcFault);
        }
    }

    private void processOperationFault(WSDLInterfaceOperation destOperation, WSDLInterface destInterface, Fault srcFault) throws WSDLException {
        String faultName = srcFault.getName();
        log.trace((Object)("processOperationFault: " + faultName));
        WSDLInterfaceFault destFault = new WSDLInterfaceFault(destInterface, faultName);
        Message message = srcFault.getMessage();
        QName messageName = message.getQName();
        Map partsMap = message.getParts();
        if (partsMap.size() != 1) {
            throw new WSDLException("INVALID_WSDL", "Unsupported number of fault parts in message " + messageName);
        }
        Part part = (Part)partsMap.values().iterator().next();
        QName xmlName = part.getElementName();
        if (xmlName != null) {
            destFault.setElement(xmlName);
        } else {
            destFault.setElement(messageName);
            log.warn((Object)("Unsupported fault message part in message: " + messageName));
        }
        destInterface.addFault(destFault);
        WSDLInterfaceOperationOutfault opOutFault = new WSDLInterfaceOperationOutfault(destOperation);
        opOutFault.setRef(destFault.getName());
        destOperation.addOutfault(opOutFault);
    }

    private QName messagePartToElementName(Message srcMessage, Part srcPart, WSDLInterfaceOperation destOperation) throws WSDLException {
        QName xmlName;
        if (srcPart.getTypeName() != null && srcPart.getElementName() != null) {
            throw new WSDLException("INVALID_WSDL", "Message parts must not define an element name and type name: " + srcMessage.getQName());
        }
        String style = destOperation.getStyle();
        if ("http://www.w3.org/2004/03/wsdl/style/rpc".equals(style)) {
            if (srcPart.getName() == null) {
                throw new WSDLException("INVALID_WSDL", "RPC style message parts must define a typy name: " + srcMessage.getQName());
            }
            xmlName = srcPart.getElementName();
            if (xmlName == null) {
                xmlName = new QName(srcPart.getName());
            }
        } else {
            if (srcPart.getElementName() == null) {
                throw new WSDLException("INVALID_WSDL", "Document style message parts must define an element name: " + srcMessage.getQName());
            }
            xmlName = srcPart.getElementName();
        }
        xmlName = this.destWsdl.registerQName(xmlName);
        String key = srcMessage.getQName() + "->" + srcPart.getName();
        this.messagePartToElementMap.put(key, xmlName);
        return xmlName;
    }

    private BindingOperation getBindingOperation(Definition srcWsdl, PortType srcPortType, Operation srcOperation) throws WSDLException {
        Binding srcBinding = this.getPortTypeBindings(srcWsdl).get(srcPortType.getQName());
        if (srcBinding == null) {
            throw new WSDLException("INVALID_WSDL", "Cannot find binding for: " + srcPortType.getQName());
        }
        String srcOperationName = srcOperation.getName();
        BindingOperation srcBindingOperation = srcBinding.getBindingOperation(srcOperationName, null, null);
        if (srcBindingOperation == null) {
            throw new WSDLException("INVALID_WSDL", "Cannot find binding operation for: " + srcOperationName);
        }
        return srcBindingOperation;
    }

    private String getOperationStyle(Definition srcWsdl, PortType srcPortType, Operation srcOperation) throws WSDLException {
        QName elementType;
        Binding srcBinding = this.getPortTypeBindings(srcWsdl).get(srcPortType.getQName());
        BindingOperation srcBindingOperation = this.getBindingOperation(srcWsdl, srcPortType, srcOperation);
        String operationStyle = null;
        List extList = srcBindingOperation.getExtensibilityElements();
        for (ExtensibilityElement extElement : extList) {
            SOAPOperation soapOp;
            elementType = extElement.getElementType();
            if (extElement instanceof SOAPOperation) {
                soapOp = (SOAPOperation)extElement;
                operationStyle = soapOp.getStyle();
                continue;
            }
            if (!(extElement instanceof SOAP12Operation)) continue;
            soapOp = (SOAP12Operation)extElement;
            operationStyle = soapOp.getStyle();
        }
        if (operationStyle == null) {
            for (ExtensibilityElement extElement : srcBinding.getExtensibilityElements()) {
                SOAPBinding soapBinding;
                elementType = extElement.getElementType();
                if (extElement instanceof SOAPBinding) {
                    soapBinding = (SOAPBinding)extElement;
                    operationStyle = soapBinding.getStyle();
                    continue;
                }
                if (!(extElement instanceof SOAP12Binding)) continue;
                soapBinding = (SOAP12Binding)extElement;
                operationStyle = soapBinding.getStyle();
            }
        }
        return "rpc".equals(operationStyle) ? "http://www.w3.org/2004/03/wsdl/style/rpc" : "http://www.w3.org/2004/03/wsdl/style/iri";
    }

    private boolean processBinding(Definition srcWsdl, Binding srcBinding) throws WSDLException {
        QName srcBindingQName = srcBinding.getQName();
        log.trace((Object)("processBinding: " + srcBindingQName));
        if (this.destWsdl.getBinding(srcBindingQName) == null) {
            PortType srcPortType = srcBinding.getPortType();
            if (srcPortType == null) {
                throw new WSDLException("INVALID_WSDL", "Cannot find port type for binding: " + srcBindingQName);
            }
            String bindingType = null;
            List extList = srcBinding.getExtensibilityElements();
            for (ExtensibilityElement extElement : extList) {
                QName elementType = extElement.getElementType();
                if (extElement instanceof SOAPBinding) {
                    bindingType = "http://schemas.xmlsoap.org/wsdl/soap/";
                    continue;
                }
                if (extElement instanceof SOAP12Binding) {
                    bindingType = "http://schemas.xmlsoap.org/wsdl/soap12/";
                    continue;
                }
                if (!"binding".equals(elementType.getLocalPart())) continue;
                log.warn((Object)("Unsupported binding: " + elementType));
                bindingType = elementType.getNamespaceURI();
            }
            if (bindingType == null) {
                throw new WSDLException("INVALID_WSDL", "Cannot obtain binding type for: " + srcBindingQName);
            }
            if (!"http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType) && !"http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)) {
                return false;
            }
            WSDLBinding destBinding = new WSDLBinding(this.destWsdl, srcBindingQName);
            destBinding.setInterfaceName(srcPortType.getQName());
            destBinding.setType(bindingType);
            this.destWsdl.addBinding(destBinding);
            this.preProcessSWAParts(srcBinding, srcWsdl);
            this.processPortType(srcWsdl, srcPortType);
            String bindingStyle = Style.getDefaultStyle().toString();
            for (ExtensibilityElement extElement : extList) {
                SOAPBinding soapBinding;
                QName elementType = extElement.getElementType();
                if (extElement instanceof SOAPBinding) {
                    soapBinding = (SOAPBinding)extElement;
                    bindingStyle = soapBinding.getStyle();
                    continue;
                }
                if (!(extElement instanceof SOAP12Binding)) continue;
                soapBinding = (SOAP12Binding)extElement;
                bindingStyle = soapBinding.getStyle();
            }
            this.processBindingOperations(srcWsdl, destBinding, srcBinding, bindingStyle);
        }
        return true;
    }

    private void preProcessSWAParts(Binding srcBinding, Definition srcWsdl) {
        for (BindingOperation bindingOperation : srcBinding.getBindingOperations()) {
            if (bindingOperation.getBindingInput() != null) {
                this.markSWAParts(bindingOperation.getBindingInput().getExtensibilityElements(), srcBinding, srcWsdl);
            }
            if (bindingOperation.getBindingOutput() == null) continue;
            this.markSWAParts(bindingOperation.getBindingOutput().getExtensibilityElements(), srcBinding, srcWsdl);
        }
    }

    private void markSWAParts(List extensions, Binding srcBinding, Definition srcWsdl) {
        for (Object o : extensions) {
            if (!(o instanceof MIMEMultipartRelated)) continue;
            QName portTypeName = srcBinding.getPortType().getQName();
            if (log.isTraceEnabled()) {
                log.trace((Object)("SWA found on portType" + portTypeName));
            }
            MIMEMultipartRelated mrel = (MIMEMultipartRelated)o;
            for (MIMEPart mimePartDesc : mrel.getMIMEParts()) {
                List mimePartExt = mimePartDesc.getExtensibilityElements();
                if (mimePartExt.isEmpty() || !(mimePartExt.get(0) instanceof MIMEContent)) continue;
                MIMEContent mimeContent = (MIMEContent)mimePartExt.get(0);
                if (this.skippedSWAParts.get(portTypeName) == null) {
                    this.skippedSWAParts.put(portTypeName, new ArrayList());
                }
                this.skippedSWAParts.get(portTypeName).add(mimeContent.getPart());
            }
        }
    }

    private Map<QName, Binding> getPortTypeBindings(Definition srcWsdl) {
        this.getAllDefinedBindings(srcWsdl);
        return this.portTypeBindings;
    }

    private Map<QName, Binding> getAllDefinedBindings(Definition srcWsdl) {
        if (this.allBindings != null) {
            return this.allBindings;
        }
        this.allBindings = new LinkedHashMap();
        this.portTypeBindings = new LinkedHashMap();
        Map srcBindings = srcWsdl.getBindings();
        for (Binding srcBinding : srcBindings.values()) {
            this.allBindings.put(srcBinding.getQName(), srcBinding);
            this.portTypeBindings.put(srcBinding.getPortType().getQName(), srcBinding);
        }
        for (Service srcService : srcWsdl.getServices().values()) {
            for (Port srcPort : srcService.getPorts().values()) {
                Binding srcBinding = srcPort.getBinding();
                this.allBindings.put(srcBinding.getQName(), srcBinding);
                this.portTypeBindings.put(srcBinding.getPortType().getQName(), srcBinding);
            }
        }
        return this.allBindings;
    }

    private void processBindingOperations(Definition srcWsdl, WSDLBinding destBinding, Binding srcBinding, String bindingStyle) throws WSDLException {
        for (BindingOperation srcBindingOperation : srcBinding.getBindingOperations()) {
            this.processBindingOperation(srcWsdl, destBinding, bindingStyle, srcBindingOperation);
        }
    }

    private void processBindingOperation(Definition srcWsdl, WSDLBinding destBinding, String bindingStyle, BindingOperation srcBindingOperation) throws WSDLException {
        BindingOutput srcBindingOutput;
        String srcOperationName = srcBindingOperation.getName();
        log.trace((Object)("processBindingOperation: " + srcOperationName));
        WSDLInterface destInterface = destBinding.getInterface();
        String namespaceURI = destInterface.getName().getNamespaceURI();
        WSDLBindingOperation destBindingOperation = new WSDLBindingOperation(destBinding);
        QName refQName = new QName(namespaceURI, srcOperationName);
        destBindingOperation.setRef(refQName);
        destBinding.addOperation(destBindingOperation);
        String opName = srcOperationName;
        WSDLInterfaceOperation destIntfOperation = destInterface.getOperation(opName);
        List extList = srcBindingOperation.getExtensibilityElements();
        for (ExtensibilityElement extElement : extList) {
            SOAPOperation soapOp;
            if (extElement instanceof SOAPOperation) {
                soapOp = (SOAPOperation)extElement;
                destBindingOperation.setSOAPAction(soapOp.getSoapActionURI());
                continue;
            }
            if (!(extElement instanceof SOAP12Operation)) continue;
            soapOp = (SOAP12Operation)extElement;
            destBindingOperation.setSOAPAction(soapOp.getSoapActionURI());
        }
        BindingInput srcBindingInput = srcBindingOperation.getBindingInput();
        if (srcBindingInput != null) {
            this.processBindingInput(srcWsdl, destBindingOperation, destIntfOperation, srcBindingOperation, srcBindingInput);
        }
        if ((srcBindingOutput = srcBindingOperation.getBindingOutput()) != null) {
            this.processBindingOutput(srcWsdl, destBindingOperation, destIntfOperation, srcBindingOperation, srcBindingOutput);
        }
    }

    private void processBindingInput(Definition srcWsdl, WSDLBindingOperation destBindingOperation, final WSDLInterfaceOperation destIntfOperation, final BindingOperation srcBindingOperation, BindingInput srcBindingInput) throws WSDLException {
        log.trace((Object)"processBindingInput");
        List extList = srcBindingInput.getExtensibilityElements();
        WSDLBindingOperationInput input = new WSDLBindingOperationInput(destBindingOperation);
        destBindingOperation.addInput(input);
        ReferenceCallback cb = new ReferenceCallback(){

            public QName getXmlType(String partName) {
                return srcBindingOperation.getOperation().getInput().getMessage().getPart(partName).getTypeName();
            }

            public void removeReference(QName element) {
                WSDLInterfaceOperationInput destIntfInput = destIntfOperation.getInput(element);
                if (destIntfInput != null) {
                    destIntfOperation.removeInput(element);
                }
            }

            public void removeRPCPart(String partName) {
                WSDLInterfaceOperationInput operationInput = destIntfOperation.getInput(destIntfOperation.getName());
                operationInput.removeChildPart(partName);
            }
        };
        this.processBindingReference(srcWsdl, destBindingOperation, destIntfOperation, extList, input, srcBindingOperation, cb);
    }

    private void processBindingOutput(Definition srcWsdl, WSDLBindingOperation destBindingOperation, final WSDLInterfaceOperation destIntfOperation, final BindingOperation srcBindingOperation, BindingOutput srcBindingOutput) throws WSDLException {
        log.trace((Object)"processBindingInput");
        List extList = srcBindingOutput.getExtensibilityElements();
        WSDLBindingOperationOutput output = new WSDLBindingOperationOutput(destBindingOperation);
        destBindingOperation.addOutput(output);
        ReferenceCallback cb = new ReferenceCallback(){

            public QName getXmlType(String partName) {
                return srcBindingOperation.getOperation().getOutput().getMessage().getPart(partName).getTypeName();
            }

            public void removeReference(QName element) {
                WSDLInterfaceOperationOutput destIntfOutput = destIntfOperation.getOutput(element);
                if (destIntfOutput != null) {
                    destIntfOperation.removeInput(element);
                }
            }

            public void removeRPCPart(String partName) {
                QName name = destIntfOperation.getName();
                WSDLInterfaceOperationOutput operationOutput = destIntfOperation.getOutput(new QName(name.getNamespaceURI(), name.getLocalPart() + "Response"));
                operationOutput.removeChildPart(partName);
            }
        };
        this.processBindingReference(srcWsdl, destBindingOperation, destIntfOperation, extList, output, srcBindingOperation, cb);
    }

    private void processBindingReference(Definition srcWsdl, WSDLBindingOperation destBindingOperation, WSDLInterfaceOperation destIntfOperation, List<ExtensibilityElement> extList, WSDLBindingMessageReference reference, BindingOperation srcBindingOperation, ReferenceCallback callback) throws WSDLException {
        for (ExtensibilityElement extElement : extList) {
            String namespaceURI;
            SOAPBody body;
            if (extElement instanceof SOAPBody) {
                body = (SOAPBody)extElement;
                this.processEncodingStyle((ExtensibilityElement)body, destBindingOperation);
                namespaceURI = body.getNamespaceURI();
                destBindingOperation.setNamespaceURI(namespaceURI);
                continue;
            }
            if (extElement instanceof SOAP12Body) {
                body = (SOAP12Body)extElement;
                this.processEncodingStyle((ExtensibilityElement)body, destBindingOperation);
                namespaceURI = body.getNamespaceURI();
                destBindingOperation.setNamespaceURI(namespaceURI);
                continue;
            }
            if (extElement instanceof SOAPHeader) {
                SOAPHeader header = (SOAPHeader)extElement;
                QName headerMessageName = header.getMessage();
                String headerPartName = header.getPart();
                String key = headerMessageName + "->" + headerPartName;
                QName elementName = this.messagePartToElementMap.get(key);
                boolean isImplicitHeader = false;
                Message srcMessage = srcWsdl.getMessage(headerMessageName);
                if (elementName == null && srcMessage != null) {
                    for (Part srcPart : srcMessage.getParts().values()) {
                        String partName = srcPart.getName();
                        if (!partName.equals(headerPartName)) continue;
                        isImplicitHeader = true;
                        elementName = srcPart.getElementName();
                    }
                }
                if (elementName == null) {
                    throw new WSDLException("INVALID_WSDL", "Could not determine element name from header: " + key);
                }
                WSDLSOAPHeader soapHeader = new WSDLSOAPHeader(elementName, headerPartName);
                soapHeader.setIncludeInSignature(!isImplicitHeader);
                reference.addSoapHeader(soapHeader);
                if ("http://www.w3.org/2004/03/wsdl/style/iri" == destIntfOperation.getStyle()) {
                    callback.removeReference(elementName);
                    continue;
                }
                callback.removeRPCPart(headerPartName);
                continue;
            }
            if (!(extElement instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated related = (MIMEMultipartRelated)extElement;
            for (MIMEPart part : related.getMIMEParts()) {
                Iterator j = part.getExtensibilityElements().iterator();
                String name = null;
                String types = null;
                while (j.hasNext()) {
                    ExtensibilityElement inner = (ExtensibilityElement)j.next();
                    if (!(inner instanceof MIMEContent)) continue;
                    MIMEContent content = (MIMEContent)inner;
                    name = content.getPart();
                    if (types == null) {
                        types = content.getType();
                        continue;
                    }
                    types = types + "," + content.getType();
                }
                if (name == null) continue;
                QName xmlType = callback.getXmlType(name);
                reference.addMimePart(new WSDLMIMEPart(name, xmlType, types));
                if ("http://www.w3.org/2004/03/wsdl/style/iri" == destIntfOperation.getStyle()) {
                    callback.removeReference(new QName(name));
                    continue;
                }
                callback.removeRPCPart(name);
            }
        }
    }

    private void processEncodingStyle(ExtensibilityElement extElement, WSDLBindingOperation destBindingOperation) {
        SOAPBody body;
        log.trace((Object)"processEncodingStyle");
        String encStyle = null;
        if (extElement instanceof SOAPBody) {
            body = (SOAPBody)extElement;
            List encStyleList = body.getEncodingStyles();
            if (encStyleList != null) {
                if (encStyleList.size() > 1) {
                    log.warn((Object)("Multiple encoding styles not supported: " + encStyleList));
                }
                if (encStyleList.size() > 0) {
                    encStyle = (String)encStyleList.get(0);
                }
            }
        } else if (extElement instanceof SOAP12Body) {
            body = (SOAP12Body)extElement;
            encStyle = body.getEncodingStyle();
        }
        if (encStyle != null) {
            String setStyle = destBindingOperation.getEncodingStyle();
            if (!encStyle.equals(setStyle)) {
                log.warn((Object)("Encoding style '" + encStyle + "' not supported for: " + destBindingOperation.getRef()));
            }
            destBindingOperation.setEncodingStyle(encStyle);
        }
    }

    private void processServices(Definition srcWsdl) throws WSDLException {
        log.trace((Object)("BEGIN processServices: " + srcWsdl.getDocumentBaseURI()));
        this.allBindings = null;
        if (srcWsdl.getServices().size() > 0) {
            for (Service srcService : srcWsdl.getServices().values()) {
                QName qname = srcService.getQName();
                WSDLService destService = new WSDLService(this.destWsdl, qname);
                this.destWsdl.addService(destService);
                this.processPorts(srcWsdl, destService, srcService);
            }
        } else {
            log.trace((Object)"Empty wsdl services, processing imports");
            for (List srcImports : srcWsdl.getImports().values()) {
                for (Import srcImport : srcImports) {
                    Definition importDefinition = srcImport.getDefinition();
                    this.processServices(importDefinition);
                }
            }
            this.allBindings = null;
        }
        log.trace((Object)("END processServices: " + srcWsdl.getDocumentBaseURI()));
    }

    private void processPorts(Definition srcWsdl, WSDLService destService, Service srcService) throws WSDLException {
        for (Port srcPort : srcService.getPorts().values()) {
            this.processPort(srcWsdl, destService, srcPort);
        }
    }

    private void processPort(Definition srcWsdl, WSDLService destService, Port srcPort) throws WSDLException {
        log.trace((Object)("processPort: " + srcPort.getName()));
        Binding srcBinding = srcPort.getBinding();
        QName endpointName = new QName(srcWsdl.getTargetNamespace(), srcPort.getName());
        WSDLEndpoint destEndpoint = new WSDLEndpoint(destService, endpointName);
        destEndpoint.setBinding(srcBinding.getQName());
        destEndpoint.setAddress(this.getSOAPAddress(srcPort));
        if (this.processBinding(srcWsdl, srcBinding)) {
            destService.addEndpoint(destEndpoint);
        }
    }

    private String getSOAPAddress(Port srcPort) throws WSDLException {
        String soapAddress = "dummy";
        for (ExtensibilityElement extElement : srcPort.getExtensibilityElements()) {
            QName elementType = extElement.getElementType();
            if (extElement instanceof SOAPAddress) {
                SOAPAddress addr = (SOAPAddress)extElement;
                soapAddress = addr.getLocationURI();
                break;
            }
            if (extElement instanceof SOAP12Address) {
                SOAP12Address addr = (SOAP12Address)extElement;
                soapAddress = addr.getLocationURI();
                break;
            }
            if (!"address".equals(elementType.getLocalPart())) continue;
            log.warn((Object)("Unprocessed extension element: " + elementType));
        }
        if (soapAddress == null) {
            throw new WSDLException("INVALID_WSDL", "Cannot obtain SOAP address");
        }
        return soapAddress;
    }

    private String getOptionalAttribute(Element domElement, String attrName) {
        String attrValue = domElement.getAttribute(attrName);
        return attrValue.length() > 0 ? attrValue : null;
    }

    static interface ReferenceCallback {
        public void removeReference(QName var1);

        public void removeRPCPart(String var1);

        public QName getXmlType(String var1);
    }
}

