/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.helpers;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.holders.Holder;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.Style;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PortMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceInterfaceMapping;
import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.ws.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.WsdlReturnValueMapping;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.XSModelTypes;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.JavaToXSD;
import org.jboss.ws.tools.interfaces.JavaToXSDIntf;
import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;
import org.jboss.ws.tools.wsdl.WSDLGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaToWSDLHelper
extends WSDLGenerator {
    private JavaToXSDIntf javaToXSD = new JavaToXSD();
    private JavaWsdlMapping javaWsdlMapping = new JavaWsdlMapping();
    private Map<QName, JavaXmlTypeMapping> mappedTypes = new HashMap<QName, JavaXmlTypeMapping>();
    private Set<String> mappedPackages = new HashSet<String>();
    private Map<String, String> packageNamespaceMap = new HashMap<String, String>();
    private Set<String> mappedExceptions = new HashSet<String>();

    @Override
    protected void processTypes() {
        this.wsdl.setWsdlTypes(new XSModelTypes());
    }

    @Override
    protected void processOperation(WSDLInterface wsdlInterface, WSDLBinding wsdlBinding, OperationMetaData operation) {
        super.processOperation(wsdlInterface, wsdlBinding, operation);
        try {
            for (ParameterMetaData paramMetaData : operation.getParameters()) {
                this.generateTypesForXSD(paramMetaData);
            }
            for (FaultMetaData faultMetaData : operation.getFaults()) {
                this.generateTypesForXSD(faultMetaData);
            }
            ParameterMetaData returnMetaData = operation.getReturnParameter();
            if (returnMetaData != null) {
                this.generateTypesForXSD(returnMetaData);
            }
        }
        catch (IOException io) {
            throw new WSException(io);
        }
    }

    public void generateTypesForXSD(ParameterMetaData pmd) throws IOException {
        QName xmlType = pmd.getXmlType();
        if (!xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            this.generateType(xmlType, pmd.getJavaType(), this.buildElementNameMap(pmd));
        }
        if (pmd.getOperationMetaData().getStyle() == Style.DOCUMENT || pmd.isInHeader()) {
            this.generateElement(pmd.getXmlName(), xmlType);
        }
        if (pmd.isSwA()) {
            this.wsdl.registerNamespaceURI("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        }
    }

    private Map<String, QName> buildElementNameMap(ParameterMetaData pmd) {
        List<WrappedParameter> wrappedParameters = pmd.getWrappedParameters();
        if (wrappedParameters == null) {
            return null;
        }
        LinkedHashMap<String, QName> map = new LinkedHashMap<String, QName>(wrappedParameters.size());
        for (WrappedParameter param : wrappedParameters) {
            map.put(param.getVariable(), param.getName());
        }
        return map;
    }

    public void generateTypesForXSD(FaultMetaData fmd) throws IOException {
        SchemaCreatorIntf sc = this.javaToXSD.getSchemaCreator();
        QName xmlType = fmd.getXmlType();
        if (!xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            this.generateType(xmlType, fmd.getJavaType(), null);
        }
    }

    @Override
    public void processEndpoint(WSDLService service, EndpointMetaData endpoint) {
        super.processEndpoint(service, endpoint);
        this.buildServiceMapping(endpoint);
    }

    private void buildServiceMapping(EndpointMetaData endpoint) {
        QName origQName = endpoint.getServiceMetaData().getServiceName();
        String serviceInterfaceName = endpoint.getServiceEndpointInterface().getPackage().getName() + "." + origQName.getLocalPart();
        QName serviceQName = new QName(origQName.getNamespaceURI(), origQName.getLocalPart(), "serviceNS");
        ServiceInterfaceMapping serviceMapping = new ServiceInterfaceMapping(this.javaWsdlMapping);
        serviceMapping.setServiceInterface(serviceInterfaceName);
        serviceMapping.setWsdlServiceName(serviceQName);
        String endpointName = endpoint.getPortName().getLocalPart();
        PortMapping portMapping = new PortMapping(serviceMapping);
        portMapping.setJavaPortName(endpointName);
        portMapping.setPortName(endpointName);
        serviceMapping.addPortMapping(portMapping);
        this.javaWsdlMapping.addServiceInterfaceMappings(serviceMapping);
        String interfaceName = endpoint.getPortTypeName().getLocalPart();
        ServiceEndpointInterfaceMapping seiMapping = new ServiceEndpointInterfaceMapping(this.javaWsdlMapping);
        seiMapping.setServiceEndpointInterface(endpoint.getServiceEndpointInterfaceName());
        seiMapping.setWsdlPortType(new QName(this.wsdl.getTargetNamespace(), interfaceName, "portTypeNS"));
        seiMapping.setWsdlBinding(new QName(this.wsdl.getTargetNamespace(), interfaceName + "Binding", "bindingNS"));
        for (OperationMetaData operation : endpoint.getOperations()) {
            Object name;
            ServiceEndpointMethodMapping methodMapping = new ServiceEndpointMethodMapping(seiMapping);
            methodMapping.setJavaMethodName(operation.getJavaName());
            methodMapping.setWsdlOperation(operation.getQName().getLocalPart());
            boolean isWrapped = operation.isDocumentWrapped();
            methodMapping.setWrappedElement(isWrapped);
            int i = 0;
            for (ParameterMetaData param : operation.getParameters()) {
                if (isWrapped && !param.isInHeader()) {
                    List<WrappedParameter> wrappedParameters = param.getWrappedParameters();
                    for (WrappedParameter wrapped : wrappedParameters) {
                        String type = JavaUtils.convertJVMNameToSourceName(wrapped.getType(), endpoint.getClassLoader());
                        name = wrapped.getName().getLocalPart();
                        this.buildParamMapping(methodMapping, interfaceName, operation, (String)name, type, "IN", false, i++);
                    }
                    continue;
                }
                String name2 = param.getXmlName().getLocalPart();
                String type = JavaUtils.convertJVMNameToSourceName(param.getJavaTypeName(), endpoint.getClassLoader());
                this.buildParamMapping(methodMapping, interfaceName, operation, name2, type, param.getMode().toString(), param.isInHeader(), i++);
            }
            ParameterMetaData returnParam = operation.getReturnParameter();
            if (!(returnParam == null || isWrapped && returnParam.getWrappedParameters().isEmpty())) {
                String type;
                String name3;
                if (isWrapped) {
                    WrappedParameter wrappedParameter = returnParam.getWrappedParameters().get(0);
                    name3 = wrappedParameter.getName().getLocalPart();
                    type = wrappedParameter.getType();
                } else {
                    name3 = returnParam.getXmlName().getLocalPart();
                    type = returnParam.getJavaTypeName();
                }
                type = JavaUtils.convertJVMNameToSourceName(type, endpoint.getClassLoader());
                this.buildReturnParamMapping(methodMapping, interfaceName, operation, name3, type);
            }
            seiMapping.addServiceEndpointMethodMapping(methodMapping);
            for (FaultMetaData fmd : operation.getFaults()) {
                String javaTypeName;
                JavaXmlTypeMapping typeMapping = this.mappedTypes.get(fmd.getXmlType());
                if (typeMapping == null || this.mappedExceptions.contains(javaTypeName = fmd.getJavaTypeName())) continue;
                this.mappedExceptions.add(javaTypeName);
                ExceptionMapping mapping = new ExceptionMapping(this.javaWsdlMapping);
                mapping.setExceptionType(javaTypeName);
                name = new QName(this.wsdl.getTargetNamespace(), fmd.getXmlName().getLocalPart());
                mapping.setWsdlMessage((QName)name);
                for (VariableMapping variableMapping : typeMapping.getVariableMappings()) {
                    mapping.addConstructorParameter(variableMapping.getXmlElementName());
                }
                this.javaWsdlMapping.addExceptionMappings(mapping);
            }
        }
        this.javaWsdlMapping.addServiceEndpointInterfaceMappings(seiMapping);
        String name = endpoint.getServiceEndpointInterface().getPackage().getName();
        String namespace = this.packageNamespaceMap.get(name);
        if (namespace == null) {
            WSDLUtils.getInstance();
            namespace = WSDLUtils.getTypeNamespace(name);
        }
        this.addPackageMapping(name, namespace);
    }

    private void buildParamMapping(ServiceEndpointMethodMapping methodMapping, String interfaceName, OperationMetaData operation, String name, String type, String mode, boolean header, int position) {
        MethodParamPartsMapping paramMapping = new MethodParamPartsMapping(methodMapping);
        paramMapping.setParamPosition(position);
        paramMapping.setParamType(type);
        WsdlMessageMapping messageMapping = new WsdlMessageMapping(paramMapping);
        messageMapping.setWsdlMessagePartName(name);
        String messageName = interfaceName + "_" + operation.getQName().getLocalPart();
        if ("OUT".equals(mode)) {
            messageName = messageName + "Response";
        }
        QName messageQName = new QName(this.wsdl.getTargetNamespace(), messageName, "wsdlMsgNS");
        messageMapping.setWsdlMessage(messageQName);
        messageMapping.setParameterMode(mode);
        messageMapping.setSoapHeader(header);
        paramMapping.setWsdlMessageMapping(messageMapping);
        methodMapping.addMethodParamPartsMapping(paramMapping);
    }

    private void buildReturnParamMapping(ServiceEndpointMethodMapping methodMapping, String interfaceName, OperationMetaData operation, String name, String type) {
        WsdlReturnValueMapping returnMapping = new WsdlReturnValueMapping(methodMapping);
        returnMapping.setMethodReturnValue(type);
        returnMapping.setWsdlMessagePartName(name);
        String messageName = interfaceName + "_" + operation.getQName().getLocalPart() + "Response";
        QName messageQName = new QName(this.wsdl.getTargetNamespace(), messageName, "wsdlMsgNS");
        returnMapping.setWsdlMessage(messageQName);
        methodMapping.setWsdlReturnValueMapping(returnMapping);
    }

    public TypeMapping getTypeMapping() {
        return this.javaToXSD.getSchemaCreator().getTypeMapping();
    }

    public void setPackageNamespaceMap(Map<String, String> map) {
        this.packageNamespaceMap = map;
        this.javaToXSD.setPackageNamespaceMap(map);
    }

    public void setJavaToXSD(JavaToXSDIntf jxsd) {
        this.javaToXSD = jxsd;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    protected void generateType(QName xmlType, Class javaType, Map<String, QName> elementNames) throws IOException {
        Iterator iter;
        JBossXSModel xsModel;
        if (Holder.class.isAssignableFrom(javaType)) {
            javaType = WSDLUtils.getInstance().getJavaTypeForHolder(javaType);
        }
        if ((xsModel = this.javaToXSD.generateForSingleType(xmlType, javaType, elementNames)) == null) {
            throw new WSException("XSModel is null");
        }
        WSDLTypes wsdlTypes = this.wsdl.getWsdlTypes();
        WSDLUtils.addSchemaModel(wsdlTypes, xmlType.getNamespaceURI(), xsModel);
        this.wsdl.registerNamespaceURI(xmlType.getNamespaceURI(), null);
        SchemaCreatorIntf schemaCreator = this.javaToXSD.getSchemaCreator();
        this.mergeJavaWsdlMapping(schemaCreator.getJavaWsdlMapping());
        HashMap map = schemaCreator.getCustomNamespaceMap();
        Set keys = map != null ? map.keySet() : null;
        Iterator iterator = iter = keys != null && !keys.isEmpty() ? keys.iterator() : null;
        while (iter != null && iter.hasNext()) {
            String pref = (String)iter.next();
            String ns = (String)map.get(pref);
            if (ns == null) continue;
            this.wsdl.registerNamespaceURI(ns, null);
        }
    }

    private void mergeJavaWsdlMapping(JavaWsdlMapping source) {
        Object name;
        for (PackageMapping packageMapping : source.getPackageMappings()) {
            name = packageMapping.getPackageType();
            String namespaceURI = packageMapping.getNamespaceURI();
            this.addPackageMapping((String)name, namespaceURI);
        }
        for (Serializable serializable : source.getJavaXmlTypeMappings()) {
            name = ((JavaXmlTypeMapping)serializable).getRootTypeQName();
            if (name == null) {
                name = ((JavaXmlTypeMapping)serializable).getAnonymousTypeQName();
            }
            if (this.mappedTypes.containsKey(name)) continue;
            this.mappedTypes.put((QName)name, (JavaXmlTypeMapping)serializable);
            JavaXmlTypeMapping typeCopy = new JavaXmlTypeMapping(this.javaWsdlMapping);
            typeCopy.setQNameScope(((JavaXmlTypeMapping)serializable).getQnameScope());
            typeCopy.setAnonymousTypeQName(((JavaXmlTypeMapping)serializable).getAnonymousTypeQName());
            typeCopy.setJavaType(((JavaXmlTypeMapping)serializable).getJavaType());
            typeCopy.setRootTypeQName(((JavaXmlTypeMapping)serializable).getRootTypeQName());
            for (VariableMapping variable : ((JavaXmlTypeMapping)serializable).getVariableMappings()) {
                VariableMapping variableCopy = new VariableMapping(typeCopy);
                variableCopy.setDataMember(variable.isDataMember());
                variableCopy.setJavaVariableName(variable.getJavaVariableName());
                variableCopy.setXmlAttributeName(variable.getXmlAttributeName());
                variableCopy.setXmlElementName(variable.getXmlElementName());
                variableCopy.setXmlWildcard(variable.getXmlWildcard());
                typeCopy.addVariableMapping(variableCopy);
            }
            this.javaWsdlMapping.addJavaXmlTypeMappings(typeCopy);
        }
    }

    private void addPackageMapping(String name, String namespaceURI) {
        if (this.mappedPackages.contains(name)) {
            return;
        }
        this.mappedPackages.add(name);
        PackageMapping copy = new PackageMapping(this.javaWsdlMapping);
        copy.setPackageType(name);
        copy.setNamespaceURI(namespaceURI);
        this.javaWsdlMapping.addPackageMapping(copy);
    }

    protected void generateElement(QName xmlName, QName xmlType) {
        WSDLTypes types = this.wsdl.getWsdlTypes();
        String namespaceURI = xmlType.getNamespaceURI();
        JBossXSModel schemaModel = WSDLUtils.getSchemaModel(types);
        JBossXSTypeDefinition type = "http://www.w3.org/2001/XMLSchema".equals(namespaceURI) ? SchemaUtils.getInstance().getSchemaBasicType(xmlType.getLocalPart()) : schemaModel.getTypeDefinition(xmlType.getLocalPart(), namespaceURI);
        WSSchemaUtils utils = WSSchemaUtils.getInstance(schemaModel.getNamespaceRegistry(), null);
        JBossXSElementDeclaration element = utils.createGlobalXSElementDeclaration(xmlName.getLocalPart(), type, xmlName.getNamespaceURI());
        schemaModel.addXSElementDeclaration(element);
        this.wsdl.registerNamespaceURI(xmlName.getNamespaceURI(), null);
    }
}

