/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.config.binding;

import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.config.EndpointProperty;
import org.jboss.ws.metadata.config.jaxrpc.ClientConfigJAXRPC;
import org.jboss.ws.metadata.config.jaxrpc.CommonConfigJAXRPC;
import org.jboss.ws.metadata.config.jaxrpc.ConfigRootJAXRPC;
import org.jboss.ws.metadata.config.jaxrpc.EndpointConfigJAXRPC;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class OMFactoryJAXRPC
implements ObjectModelFactory {
    private final Logger log = Logger.getLogger(OMFactoryJAXRPC.class);

    public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs) {
        return new ConfigRootJAXRPC();
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName) {
        return root;
    }

    public Object newChild(ConfigRootJAXRPC config, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        this.log.trace((Object)("WSConfig newChild: " + localName));
        if ("endpoint-config".equals(localName)) {
            EndpointConfigJAXRPC wsEndpointConfig = new EndpointConfigJAXRPC();
            config.getEndpointConfig().add(wsEndpointConfig);
            return wsEndpointConfig;
        }
        if ("client-config".equals(localName)) {
            ClientConfigJAXRPC clientConfig = new ClientConfigJAXRPC();
            config.getClientConfig().add(clientConfig);
            return clientConfig;
        }
        return null;
    }

    public void setValue(CommonConfigJAXRPC commonConfig, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("CommonConfig setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        if (localName.equals("config-name")) {
            commonConfig.setConfigName(value);
        }
        if (localName.equals("feature")) {
            commonConfig.setFeature(value, true);
        }
        if ("property-name".equals(localName)) {
            commonConfig.addProperty(value, null);
        } else if ("property-value".equals(localName)) {
            int lastEntry = commonConfig.getProperties().isEmpty() ? 0 : commonConfig.getProperties().size() - 1;
            EndpointProperty p = commonConfig.getProperties().get(lastEntry);
            p.value = value;
        }
    }

    public Object newChild(CommonConfigJAXRPC commonConfig, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        this.log.trace((Object)("CommonConfig newChild: " + localName));
        if ("pre-handler-chain".equals(localName)) {
            UnifiedHandlerChainMetaData preHandlerChain = new UnifiedHandlerChainMetaData(null);
            commonConfig.setPreHandlerChain(preHandlerChain);
            return preHandlerChain;
        }
        if ("post-handler-chain".equals(localName)) {
            UnifiedHandlerChainMetaData postHandlerChain = new UnifiedHandlerChainMetaData(null);
            commonConfig.setPostHandlerChain(postHandlerChain);
            return postHandlerChain;
        }
        return null;
    }

    public Object newChild(UnifiedHandlerChainMetaData UnifiedHandlerChainMetaData2, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        this.log.trace((Object)("WSHandlerChainConfig newChild: " + localName));
        if ("handler".equals(localName)) {
            UnifiedHandlerMetaData handler = new UnifiedHandlerMetaData(UnifiedHandlerChainMetaData2);
            List<UnifiedHandlerMetaData> handlers = UnifiedHandlerChainMetaData2.getHandlers();
            handlers.add(handler);
            return handler;
        }
        return null;
    }

    public void setValue(UnifiedHandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("UnifiedHandlerMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        if (localName.equals("handler-name")) {
            handler.setHandlerName(value);
        } else if (localName.equals("handler-class")) {
            handler.setHandlerClass(value);
        } else if (localName.equals("soap-header")) {
            handler.addSoapHeader(navigator.resolveQName(value));
        } else if (localName.equals("soap-role")) {
            handler.addSoapRole(value);
        } else if (localName.equals("port-name")) {
            handler.addPortName(value);
        }
    }

    public void setValue(UnifiedInitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("UnifiedInitParamMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        if (localName.equals("param-name")) {
            param.setParamName(value);
        } else if (localName.equals("param-value")) {
            param.setParamValue(value);
        }
    }
}

