/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.server.UnifiedDeploymentInfo;
import org.jboss.ws.metadata.builder.jaxws.JAXWSServerMetaDataBuilder;
import org.jboss.ws.metadata.j2ee.UnifiedWebMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;

public class JAXWSMetaDataBuilderJSE {
    private final Logger log = Logger.getLogger(JAXWSMetaDataBuilderJSE.class);

    public UnifiedMetaData buildMetaData(UnifiedDeploymentInfo udi) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("START buildMetaData: [name=" + udi.getCanonicalName() + "]"));
        }
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData(udi.vfRoot);
            wsMetaData.setDeploymentName(udi.getCanonicalName());
            wsMetaData.setClassLoader(udi.classLoader);
            if (udi.classLoader == null) {
                throw new WSException("Deployment class loader not initialized");
            }
            UnifiedWebMetaData webMetaData = (UnifiedWebMetaData)udi.metaData;
            Map<String, String> servletClassMap = webMetaData.getServletClassNames();
            for (String servletName : servletClassMap.keySet()) {
                String servletClassName = servletClassMap.get(servletName);
                try {
                    Class<?> beanClass = udi.classLoader.loadClass(servletClassName);
                    JAXWSServerMetaDataBuilder.setupProviderOrWebService(wsMetaData, udi, beanClass, servletName);
                }
                catch (ClassNotFoundException ex) {
                    this.log.warn((Object)("Cannot load service endpoint class: " + servletClassName));
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            }
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }
}

