/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.dom.DOMSource;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.Style;
import org.jboss.ws.core.soap.EnvelopeBuilder;
import org.jboss.ws.core.soap.HRefInlineHandler;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPBodyElementDoc;
import org.jboss.ws.core.soap.SOAPBodyElementMessage;
import org.jboss.ws.core.soap.SOAPBodyElementRpc;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.ws.core.soap.SOAPFaultImpl;
import org.jboss.ws.core.soap.SOAPHeaderElementImpl;
import org.jboss.ws.core.soap.SOAPPartImpl;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.ws.core.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EnvelopeBuilderDOM
implements EnvelopeBuilder {
    private static Logger log = Logger.getLogger(EnvelopeBuilderDOM.class);
    private Style style = Style.DOCUMENT;

    public EnvelopeBuilderDOM(Style style) {
        this.style = style;
    }

    public SOAPEnvelope build(SOAPMessage soapMessage, InputStream ins, boolean ignoreParseError) throws IOException, SOAPException {
        Element domEnv = null;
        try {
            domEnv = DOMUtils.parse(ins);
        }
        catch (IOException ex) {
            if (ignoreParseError) {
                return null;
            }
            throw ex;
        }
        return this.build(soapMessage, domEnv);
    }

    public SOAPEnvelope build(SOAPMessage soapMessage, Reader reader, boolean ignoreParseError) throws IOException, SOAPException {
        Element domEnv = null;
        try {
            domEnv = DOMUtils.parse(new InputSource(reader));
        }
        catch (IOException ex) {
            if (ignoreParseError) {
                return null;
            }
            throw ex;
        }
        return this.build(soapMessage, domEnv);
    }

    public SOAPEnvelope build(SOAPMessage soapMessage, Element domEnv) throws SOAPException {
        boolean attachHRefElements;
        String envNS = domEnv.getNamespaceURI();
        String envPrefix = domEnv.getPrefix();
        SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
        SOAPPartImpl soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
        SOAPEnvelopeImpl soapEnv = new SOAPEnvelopeImpl(soapPart, soapFactory.createElement(domEnv, false));
        DOMUtils.copyAttributes((Element)((Object)soapEnv), domEnv);
        Element domHeader = DOMUtils.getFirstChildElement((Node)domEnv, new QName(envNS, "Header"));
        if (domHeader != null) {
            SOAPHeader soapHeader = soapEnv.getHeader();
            DOMUtils.copyAttributes((Element)soapHeader, domHeader);
            Iterator it = DOMUtils.getChildElements(domHeader);
            while (it.hasNext()) {
                Element srcElement = (Element)it.next();
                XMLFragment xmlFragment = new XMLFragment(new DOMSource(srcElement));
                NameImpl name = new NameImpl(srcElement.getLocalName(), srcElement.getPrefix(), srcElement.getNamespaceURI());
                SOAPHeaderElementImpl destElement = new SOAPHeaderElementImpl(name);
                soapHeader.addChildElement((SOAPElement)destElement);
                DOMUtils.copyAttributes((Element)((Object)destElement), srcElement);
                destElement.setXMLFragment(xmlFragment);
            }
        }
        Element domBody = DOMUtils.getFirstChildElement((Node)domEnv, new QName(envNS, "Body"));
        SOAPBodyImpl soapBody = (SOAPBodyImpl)soapEnv.getBody();
        DOMUtils.copyAttributes((Element)((Object)soapBody), domBody);
        Iterator itBody = DOMUtils.getChildElements(domBody);
        if (itBody.hasNext()) {
            String nsURI;
            String prefix;
            Element domBodyElement = (Element)itBody.next();
            String localName = domBodyElement.getLocalName();
            NameImpl beName = new NameImpl(localName, prefix = domBodyElement.getPrefix(), nsURI = domBodyElement.getNamespaceURI());
            if (((Object)beName).equals(new NameImpl("Fault", envPrefix, envNS))) {
                SOAPFaultImpl soapFault = new SOAPFaultImpl(envPrefix, envNS);
                soapBody.addChildElement(soapFault);
                DOMUtils.copyAttributes((Element)((Object)soapFault), domBodyElement);
                XMLFragment xmlFragment = new XMLFragment(new DOMSource(domBodyElement));
                soapFault.setXMLFragment(xmlFragment);
            } else if (this.style == Style.RPC) {
                this.buildBodyElementRpc(soapBody, domBodyElement);
            } else if (this.style == Style.DOCUMENT) {
                this.buildBodyElementDoc(soapBody, domBodyElement);
            } else if (this.style == null) {
                SOAPBodyElementMessage soapBodyElement = new SOAPBodyElementMessage(beName);
                soapBodyElement = (SOAPBodyElementMessage)soapBody.addChildElement(soapBodyElement);
                DOMUtils.copyAttributes((Element)((Object)soapBodyElement), domBodyElement);
                NodeList nlist = domBodyElement.getChildNodes();
                for (int i = 0; i < nlist.getLength(); ++i) {
                    String nodeValue;
                    Node child = nlist.item(i);
                    short childType = child.getNodeType();
                    if (childType == 1) {
                        SOAPElement soapElement = soapFactory.createElement((Element)child);
                        soapBodyElement.addChildElement(soapElement);
                        continue;
                    }
                    if (childType == 3) {
                        nodeValue = child.getNodeValue();
                        soapBodyElement.addTextNode(nodeValue);
                        continue;
                    }
                    if (childType == 4) {
                        nodeValue = child.getNodeValue();
                        soapBodyElement.addTextNode(nodeValue);
                        continue;
                    }
                    log.warn((Object)("Ignore child type: " + childType));
                }
            } else {
                throw new WSException("Unsupported message style: " + this.style);
            }
        }
        attachHRefElements = (attachHRefElements = "http://schemas.xmlsoap.org/soap/encoding/".equals(soapEnv.getAttributeNS(envNS, "encodingStyle"))) || "http://schemas.xmlsoap.org/soap/encoding/".equals(soapBody.getAttributeNS(envNS, "encodingStyle"));
        boolean bl = attachHRefElements = attachHRefElements && itBody.hasNext();
        while (attachHRefElements && itBody.hasNext()) {
            Element srcElement = (Element)itBody.next();
            soapBody.addChildElement(soapFactory.createElement(srcElement, true));
        }
        if (attachHRefElements) {
            HRefInlineHandler inlineHandler = new HRefInlineHandler(soapBody);
            inlineHandler.processHRefs();
        }
        return soapEnv;
    }

    public void buildBodyElementDoc(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException {
        soapBody.removeContents();
        Element srcElement = domBodyElement;
        QName beName = DOMUtils.getElementQName(domBodyElement);
        SOAPContentElement destElement = new SOAPBodyElementDoc(beName);
        destElement = (SOAPContentElement)soapBody.addChildElement(destElement);
        DOMUtils.copyAttributes((Element)((Object)destElement), srcElement);
        XMLFragment xmlFragment = new XMLFragment(new DOMSource(srcElement));
        destElement.setXMLFragment(xmlFragment);
    }

    public void buildBodyElementRpc(SOAPBodyImpl soapBody, Element domBodyElement) throws SOAPException {
        soapBody.removeContents();
        QName beName = DOMUtils.getElementQName(domBodyElement);
        SOAPBodyElementRpc soapBodyElement = new SOAPBodyElementRpc(beName);
        soapBodyElement = (SOAPBodyElementRpc)soapBody.addChildElement(soapBodyElement);
        DOMUtils.copyAttributes((Element)((Object)soapBodyElement), domBodyElement);
        Iterator itBodyElement = DOMUtils.getChildElements(domBodyElement);
        while (itBodyElement.hasNext()) {
            Element srcElement = (Element)itBodyElement.next();
            NameImpl name = new NameImpl(srcElement.getLocalName(), srcElement.getPrefix(), srcElement.getNamespaceURI());
            SOAPContentElement destElement = new SOAPContentElement(name);
            destElement = (SOAPContentElement)soapBodyElement.addChildElement(destElement);
            DOMUtils.copyAttributes((Element)((Object)destElement), srcElement);
            XMLFragment xmlFragment = new XMLFragment(new DOMSource(srcElement));
            destElement.setXMLFragment(xmlFragment);
        }
    }
}

