/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import javax.management.ObjectName;
import org.jboss.ws.WSException;
import org.jboss.ws.core.server.ServiceEndpoint;
import org.jboss.ws.core.server.ServiceEndpointInvoker;
import org.jboss.ws.core.server.UnifiedDeploymentInfo;
import org.jboss.ws.metadata.j2ee.UnifiedApplicationMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedBeanMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedMessageDrivenMetaData;
import org.jboss.ws.metadata.j2ee.UnifiedSessionMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;

public class ServiceEndpointInfo {
    private UnifiedDeploymentInfo udi;
    private EndpointType type;
    private ServerEndpointMetaData sepMetaData;
    private ServiceEndpointInvoker seInvoker;
    private ServiceEndpoint.State state;

    public ServiceEndpointInfo(UnifiedDeploymentInfo udi, ServerEndpointMetaData sepMetaData) {
        this.udi = udi;
        this.sepMetaData = sepMetaData;
        if (udi.type == UnifiedDeploymentInfo.DeploymentType.JAXRPC_JSE || udi.type == UnifiedDeploymentInfo.DeploymentType.JAXWS_JSE) {
            this.type = EndpointType.JSE;
        } else if (udi.type == UnifiedDeploymentInfo.DeploymentType.JAXRPC_EJB21) {
            String ejbName = sepMetaData.getLinkName();
            if (ejbName == null) {
                throw new WSException("Cannot obtain ejb-link from port component");
            }
            UnifiedApplicationMetaData applMetaData = (UnifiedApplicationMetaData)udi.metaData;
            UnifiedBeanMetaData beanMetaData = applMetaData.getBeanByEjbName(ejbName);
            if (beanMetaData == null) {
                throw new WSException("Cannot obtain ejb meta data for: " + ejbName);
            }
            if (beanMetaData instanceof UnifiedSessionMetaData) {
                this.type = EndpointType.SLSB21;
            } else if (beanMetaData instanceof UnifiedMessageDrivenMetaData) {
                this.type = EndpointType.MDB21;
            }
        } else if (udi.type == UnifiedDeploymentInfo.DeploymentType.JAXRPC_EJB3 || udi.type == UnifiedDeploymentInfo.DeploymentType.JAXWS_EJB3) {
            this.type = EndpointType.SLSB30;
        }
        if (this.type == null) {
            throw new WSException("Unsupported endpoint type: " + (Object)((Object)this.type));
        }
    }

    public ServerEndpointMetaData getServerEndpointMetaData() {
        return this.sepMetaData;
    }

    public ObjectName getServiceEndpointID() {
        return this.sepMetaData.getServiceEndpointID();
    }

    public UnifiedDeploymentInfo getUnifiedDeploymentInfo() {
        return this.udi;
    }

    public EndpointType getType() {
        return this.type;
    }

    public ServiceEndpointInvoker getInvoker() {
        return this.seInvoker;
    }

    public void setInvoker(ServiceEndpointInvoker seInvoker) {
        this.seInvoker = seInvoker;
    }

    public ServiceEndpoint.State getState() {
        return this.state;
    }

    public void setState(ServiceEndpoint.State state) {
        this.state = state;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("[id=" + this.getServiceEndpointID() + "state=" + (Object)((Object)this.state) + "]");
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EndpointType {
        JSE,
        SLSB21,
        SLSB30,
        MDB21;

    }
}

