/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.HTTPMessageImpl;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.MessageTrace;
import org.jboss.ws.core.jaxrpc.binding.BindingException;
import org.jboss.ws.core.server.EndpointContext;
import org.jboss.ws.core.server.MimeHeaderSource;
import org.jboss.ws.core.server.ServiceEndpointInfo;
import org.jboss.ws.core.server.ServiceEndpointInvoker;
import org.jboss.ws.core.server.ServiceEndpointManager;
import org.jboss.ws.core.server.ServiceEndpointManagerFactory;
import org.jboss.ws.core.server.ServiceEndpointMetrics;
import org.jboss.ws.core.server.WSDLRequestHandler;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.MessageFactoryImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.utils.DOMWriter;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.w3c.dom.Document;

public class ServiceEndpoint {
    private static Logger log = Logger.getLogger(ServiceEndpoint.class);
    protected ServiceEndpointInfo seInfo;
    protected ServiceEndpointMetrics seMetrics;

    public ServiceEndpoint(ServiceEndpointInfo seInfo) {
        this.seInfo = seInfo;
        this.seInfo.setState(State.CREATED);
        this.seMetrics = new ServiceEndpointMetrics(seInfo.getServiceEndpointID());
    }

    public State getState() {
        return this.seInfo.getState();
    }

    public ServiceEndpointInfo getServiceEndpointInfo() {
        return this.seInfo;
    }

    public ServiceEndpointMetrics getServiceEndpointMetrics() {
        return this.seMetrics;
    }

    public void create() throws Exception {
        this.seInfo.setState(State.CREATED);
    }

    public void start() throws Exception {
        ServerEndpointMetaData epMetaData = this.seInfo.getServerEndpointMetaData();
        UnifiedMetaData wsMetaData = epMetaData.getServiceMetaData().getUnifiedMetaData();
        wsMetaData.eagerInitialize();
        this.seMetrics.start();
        this.seInfo.setState(State.STARTED);
    }

    public void stop() {
        this.seMetrics.stop();
        this.seInfo.setState(State.STOPED);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stop Endpoint" + this.seMetrics));
        }
    }

    public void destroy() {
        this.seInfo.setState(State.DESTROYED);
    }

    public void handleWSDLRequest(OutputStream outStream, URL reqURL, String resPath) throws IOException {
        ServiceEndpointInfo sepInfo = this.getServiceEndpointInfo();
        ServerEndpointMetaData epMetaData = sepInfo.getServerEndpointMetaData();
        String wsdlHost = reqURL.getProtocol() + "://" + reqURL.getHost() + ":" + reqURL.getPort();
        ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
        ServiceEndpointManager epManager = factory.getServiceEndpointManager();
        if (!epManager.getWebServiceHost().equals(ServiceEndpointManager.UNDEFINED_HOSTNAME)) {
            wsdlHost = epManager.getWebServiceHost();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("WSDL request, using host: " + wsdlHost));
        }
        WSDLRequestHandler wsdlRequestHandler = new WSDLRequestHandler(epMetaData);
        Document document = wsdlRequestHandler.getDocumentForPath(reqURL, wsdlHost, resPath);
        OutputStreamWriter writer = new OutputStreamWriter(outStream);
        new DOMWriter(writer).setPrettyprint(true).print(document.getDocumentElement());
        outStream.flush();
        outStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public MessageAbstraction processRequest(MimeHeaderSource headerSource, EndpointContext context, InputStream inputStream) throws BindingException {
        MessageAbstraction reqMessage;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        ServerEndpointMetaData sepMetaData = this.seInfo.getServerEndpointMetaData();
        long beginProcessing = 0L;
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        State state = this.seInfo.getState();
        if (state != State.STARTED) {
            QName faultCode = Constants.SOAP11_FAULT_CODE_SERVER;
            String faultString = "Endpoint cannot handle requests in state: " + (Object)((Object)state);
            throw new SOAPFaultException(faultCode, faultString, null, null);
        }
        log.debug((Object)("BEGIN handleRequest: " + this.seInfo.getServiceEndpointID()));
        beginProcessing = this.seMetrics.processRequestMessage();
        MimeHeaders headers = headerSource != null ? headerSource.getMimeHeaders() : null;
        String bindingID = sepMetaData.getBindingId();
        if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID)) {
            reqMessage = new HTTPMessageImpl(headers, inputStream);
        } else {
            MessageFactoryImpl msgFactory = new MessageFactoryImpl();
            msgFactory.setServiceMode(sepMetaData.getServiceMode());
            msgFactory.setStyle(sepMetaData.getStyle());
            reqMessage = (SOAPMessageImpl)msgFactory.createMessage(headers, inputStream);
        }
        msgContext.setMessageAbstraction(reqMessage);
        MessageTrace.traceMessage("Incoming Request Message", reqMessage);
        ClassLoader classLoader = sepMetaData.getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        ServiceEndpointInvoker seInvoker = this.seInfo.getInvoker();
        MessageAbstraction resMessage = seInvoker.invoke(context);
        if (resMessage != null) {
            this.postProcessResponse(headerSource, resMessage);
        }
        MessageAbstraction messageAbstraction = resMessage;
        Object var18_22 = null;
        try {
            MessageAbstraction resMessage2 = msgContext.getMessageAbstraction();
            if (resMessage2 != null) {
                if (resMessage2.isFaultMessage()) {
                    this.seMetrics.processFaultMessage(beginProcessing);
                } else {
                    this.seMetrics.processResponseMessage(beginProcessing);
                }
            }
        }
        catch (Exception ex2) {
            log.error((Object)"Cannot process metrics", (Throwable)ex2);
        }
        Thread.currentThread().setContextClassLoader(ctxClassLoader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("END handleRequest: " + this.seInfo.getServiceEndpointID()));
        }
        return messageAbstraction;
        catch (Exception ex) {
            MessageAbstraction messageAbstraction2;
            try {
                MessageAbstraction resMessage3 = msgContext.getMessageAbstraction();
                if (resMessage3 == null || !resMessage3.isFaultMessage()) {
                    CommonBindingProvider bindingProvider = this.getCommonBindingProvider();
                    CommonBinding binding = bindingProvider.getCommonBinding();
                    resMessage3 = binding.bindFaultMessage(ex);
                }
                if (resMessage3 != null) {
                    this.postProcessResponse(headerSource, resMessage3);
                }
                messageAbstraction2 = resMessage3;
                Object var18_23 = null;
            }
            catch (Throwable throwable) {
                block27: {
                    Object var18_24 = null;
                    try {
                        MessageAbstraction resMessage2 = msgContext.getMessageAbstraction();
                        if (resMessage2 != null) {
                            if (resMessage2.isFaultMessage()) {
                                this.seMetrics.processFaultMessage(beginProcessing);
                            } else {
                                this.seMetrics.processResponseMessage(beginProcessing);
                            }
                        }
                    }
                    catch (Exception ex2) {
                        log.error((Object)"Cannot process metrics", (Throwable)ex2);
                    }
                    Thread.currentThread().setContextClassLoader(ctxClassLoader);
                    if (!log.isDebugEnabled()) break block27;
                    log.debug((Object)("END handleRequest: " + this.seInfo.getServiceEndpointID()));
                }
                throw throwable;
            }
            try {
                MessageAbstraction resMessage2 = msgContext.getMessageAbstraction();
                if (resMessage2 != null) {
                    if (resMessage2.isFaultMessage()) {
                        this.seMetrics.processFaultMessage(beginProcessing);
                    } else {
                        this.seMetrics.processResponseMessage(beginProcessing);
                    }
                }
            }
            catch (Exception ex2) {
                log.error((Object)"Cannot process metrics", (Throwable)ex2);
            }
            Thread.currentThread().setContextClassLoader(ctxClassLoader);
            if (log.isDebugEnabled()) {
                log.debug((Object)("END handleRequest: " + this.seInfo.getServiceEndpointID()));
            }
            return messageAbstraction2;
        }
    }

    private void postProcessResponse(MimeHeaderSource headerSource, MessageAbstraction resMessage) {
        try {
            if (headerSource != null && resMessage instanceof SOAPMessage) {
                XOPContext.eagerlyCreateAttachments();
                ((SOAPMessage)resMessage).saveChanges();
                headerSource.setMimeHeaders(resMessage.getMimeHeaders());
            }
            MessageTrace.traceMessage("Outgoing Response Message", resMessage);
        }
        catch (Exception ex) {
            WSException.rethrow("Faild to post process response message", ex);
        }
    }

    private CommonBindingProvider getCommonBindingProvider() {
        return new CommonBindingProvider(this.seInfo.getServerEndpointMetaData());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.seInfo.toString());
        buffer.append("\n state=" + (Object)((Object)this.seInfo.getState()));
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CREATED,
        STARTED,
        STOPED,
        DESTROYED;

    }
}

