/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Servlet;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.server.UnifiedDeploymentInfo;
import org.jboss.ws.core.utils.DOMUtils;
import org.jboss.ws.core.utils.DOMWriter;
import org.jboss.ws.core.utils.IOUtils;
import org.jboss.ws.core.utils.JavaUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractServiceEndpointPublisher {
    private static Logger log = Logger.getLogger(AbstractServiceEndpointPublisher.class);
    public static final String BEAN_NAME = "ServiceEndpointPublisher";
    public static final String INIT_PARAM_SERVICE_ENDPOINT_IMPL = "ServiceEndpointImpl";
    private String servletName;

    public String getServiceEndpointServlet() {
        return this.servletName;
    }

    public void setServiceEndpointServlet(String servletName) {
        this.servletName = servletName;
    }

    public abstract String publishServiceEndpoint(UnifiedDeploymentInfo var1) throws Exception;

    public abstract String destroyServiceEndpoint(UnifiedDeploymentInfo var1) throws Exception;

    public RewriteResults rewriteWebXml(UnifiedDeploymentInfo udi) {
        URL warURL = udi.webappURL;
        File warFile = new File(warURL.getFile());
        if (!warFile.isDirectory()) {
            throw new WSException("Expected a war directory: " + warURL);
        }
        File webXML = new File(warURL.getFile() + "/WEB-INF/web.xml");
        if (!webXML.isFile()) {
            throw new WSException("Cannot find web.xml: " + webXML);
        }
        try {
            File orgWebXML = new File(webXML.getCanonicalPath() + ".org");
            orgWebXML.delete();
            if (!webXML.renameTo(orgWebXML)) {
                throw new WSException("Cannot rename web.xml: " + orgWebXML);
            }
            FileInputStream stream = new FileInputStream(orgWebXML);
            return this.rewriteWebXml(stream, webXML, udi.classLoader);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSException(e);
        }
    }

    public RewriteResults rewriteWebXml(InputStream source, File dest, ClassLoader loader) throws Exception {
        if (dest == null) {
            dest = File.createTempFile("jbossws-alt-web", "xml", IOUtils.createTempDirectory());
            dest.deleteOnExit();
        }
        Element root = DOMUtils.parse(source);
        RewriteResults results = this.modifyServletConfig(root, loader);
        results.webXML = dest.toURL();
        FileOutputStream fos = new FileOutputStream(dest);
        new DOMWriter(fos).setPrettyprint(true).print(root);
        fos.flush();
        fos.close();
        return results;
    }

    private RewriteResults modifyServletConfig(Element root, ClassLoader loader) throws ClassNotFoundException {
        RewriteResults results = new RewriteResults();
        Iterator itServlets = DOMUtils.getChildElements((Node)root, "servlet");
        while (itServlets.hasNext()) {
            Element servletElement = (Element)itServlets.next();
            String linkName = DOMUtils.getTextContent(DOMUtils.getFirstChildElement((Node)servletElement, "servlet-name"));
            Element classElement = DOMUtils.getFirstChildElement((Node)servletElement, "servlet-class");
            if (classElement == null) continue;
            String servletClassName = DOMUtils.getTextContent(classElement).trim();
            Class<?> servletClass = null;
            if (loader != null) {
                try {
                    servletClass = loader.loadClass(servletClassName);
                }
                catch (ClassNotFoundException ex) {
                    log.warn((Object)("Cannot load servlet class: " + servletClassName));
                }
            }
            String targetBeanName = null;
            if (this.isAlreadyModified(servletElement)) {
                Iterator itParams = DOMUtils.getChildElements((Node)servletElement, "init-param");
                while (itParams.hasNext()) {
                    Element elParam = (Element)itParams.next();
                    Element elParamName = DOMUtils.getFirstChildElement((Node)elParam, "param-name");
                    Element elParamValue = DOMUtils.getFirstChildElement((Node)elParam, "param-value");
                    if (!INIT_PARAM_SERVICE_ENDPOINT_IMPL.equals(DOMUtils.getTextContent(elParamName))) continue;
                    targetBeanName = DOMUtils.getTextContent(elParamValue);
                }
            } else {
                if (servletClass != null && JavaUtils.isAssignableFrom(Servlet.class, servletClass)) {
                    log.info((Object)("Ignore servlet: " + servletClassName));
                    continue;
                }
                if (servletClassName.endsWith("Servlet")) {
                    log.info((Object)("Ignore <servlet-class> that ends with 'Servlet': " + servletClassName));
                    continue;
                }
                boolean startDetach = false;
                ArrayList<Element> detachedElements = new ArrayList<Element>();
                Iterator itDetached = DOMUtils.getChildElements(servletElement);
                while (itDetached.hasNext()) {
                    Element el = (Element)itDetached.next();
                    if (startDetach) {
                        detachedElements.add(el);
                        servletElement.removeChild(el);
                    }
                    if (!el.equals(classElement)) continue;
                    servletElement.removeChild(el);
                    startDetach = true;
                }
                classElement = DOMUtils.createElement("servlet-class");
                classElement.appendChild(DOMUtils.createTextNode(this.servletName));
                classElement = (Element)servletElement.getOwnerDocument().importNode(classElement, true);
                servletElement.appendChild(classElement);
                if (!servletClassName.equals(this.servletName)) {
                    Element paramElement = DOMUtils.createElement("init-param");
                    paramElement.appendChild(DOMUtils.createElement("param-name")).appendChild(DOMUtils.createTextNode(INIT_PARAM_SERVICE_ENDPOINT_IMPL));
                    paramElement.appendChild(DOMUtils.createElement("param-value")).appendChild(DOMUtils.createTextNode(servletClassName));
                    paramElement = (Element)servletElement.getOwnerDocument().importNode(paramElement, true);
                    servletElement.appendChild(paramElement);
                    targetBeanName = servletClassName;
                }
                for (Element el : detachedElements) {
                    servletElement.appendChild(el);
                }
            }
            if (targetBeanName == null) {
                throw new IllegalStateException("Cannot obtain service endpoint bean for: " + linkName);
            }
            results.sepTargetMap.put(linkName, targetBeanName.trim());
        }
        return results;
    }

    private boolean isAlreadyModified(Element servletElement) {
        Iterator itParams = DOMUtils.getChildElements((Node)servletElement, "init-param");
        while (itParams.hasNext()) {
            Element elParam = (Element)itParams.next();
            Element elParamName = DOMUtils.getFirstChildElement((Node)elParam, "param-name");
            if (!INIT_PARAM_SERVICE_ENDPOINT_IMPL.equals(DOMUtils.getTextContent(elParamName))) continue;
            return true;
        }
        return false;
    }

    public class RewriteResults {
        public URL webXML;
        public Map<String, String> sepTargetMap = new HashMap<String, String>();
    }
}

