/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxrpc.SOAPFaultHelperJAXRPC;
import org.jboss.ws.core.jaxrpc.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.binding.BindingException;
import org.jboss.ws.core.jaxrpc.binding.DeserializerFactoryBase;
import org.jboss.ws.core.jaxrpc.binding.DeserializerSupport;
import org.jboss.ws.core.jaxrpc.binding.SerializationContext;
import org.jboss.ws.core.jaxrpc.binding.SerializerFactoryBase;
import org.jboss.ws.core.jaxrpc.binding.SerializerSupport;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPFactoryImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPFaultHelperJAXWS {
    private static Logger log = Logger.getLogger(SOAPFaultHelperJAXWS.class);

    public static javax.xml.ws.soap.SOAPFaultException getSOAPFaultException(SOAPFault soapFault) {
        javax.xml.ws.soap.SOAPFaultException faultEx = new javax.xml.ws.soap.SOAPFaultException(soapFault);
        Detail detail = soapFault.getDetail();
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (detail != null && msgContext != null) {
            log.debug((Object)"Processing detail");
            SerializationContext serContext = msgContext.getSerializationContext();
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            Iterator it = detail.getDetailEntries();
            while (it.hasNext()) {
                DetailEntry deElement = (DetailEntry)it.next();
                QName xmlName = deElement.getElementQName();
                log.debug((Object)("Processing detail entry: " + xmlName));
                OperationMetaData opMetaData = msgContext.getOperationMetaData();
                FaultMetaData faultMetaData = opMetaData.getFault(xmlName);
                if (faultMetaData != null) {
                    String nsURI;
                    log.debug((Object)("Deserialize fault: " + faultMetaData));
                    QName xmlType = faultMetaData.getXmlType();
                    Class faultBeanClass = faultMetaData.getFaultBean();
                    DeserializerFactoryBase desFactory = (DeserializerFactoryBase)typeMapping.getDeserializer(faultBeanClass, xmlType);
                    if (desFactory == null) {
                        throw new WebServiceException("Cannot obtain deserializer factory: xmlType=" + xmlType + ", javaType=" + faultBeanClass);
                    }
                    String prefix = deElement.getPrefix();
                    if (prefix != null && prefix.length() > 0 && (nsURI = deElement.getNamespaceURI()).length() > 0 && deElement.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix).length() == 0) {
                        try {
                            deElement.addNamespaceDeclaration(prefix, nsURI);
                        }
                        catch (SOAPException e) {
                            log.warn((Object)"Declaration of detail entry namespace failed", (Throwable)e);
                        }
                    }
                    try {
                        Class[] types = opMetaData.getEndpointMetaData().getRegisteredTypes().toArray(new Class[0]);
                        serContext.setProperty("org.jboss.ws.jaxrpc.binding.contextTypes", types);
                        DOMSource source = new DOMSource((Node)deElement);
                        DeserializerSupport des = desFactory.getDeserializer();
                        Object faultBean = des.deserialize(xmlName, xmlType, source, serContext);
                        Exception serviceEx = faultMetaData.toServiceException(faultBean, soapFault.getFaultString());
                        faultEx.initCause((Throwable)serviceEx);
                        continue;
                    }
                    catch (BindingException e) {
                        throw new WebServiceException((Throwable)e);
                    }
                }
                log.debug((Object)("Cannot find fault meta data for: " + xmlName));
            }
        }
        return faultEx;
    }

    public static SOAPMessageImpl exceptionToFaultMessage(Exception reqEx) {
        log.error((Object)"SOAP request exception", (Throwable)reqEx);
        try {
            SOAPMessageImpl faultMessage = reqEx instanceof javax.xml.ws.soap.SOAPFaultException ? SOAPFaultHelperJAXWS.toSOAPMessage((javax.xml.ws.soap.SOAPFaultException)reqEx) : (reqEx instanceof SOAPFaultException ? SOAPFaultHelperJAXRPC.exceptionToFaultMessage(reqEx) : SOAPFaultHelperJAXWS.toSOAPMessage(reqEx));
            return faultMessage;
        }
        catch (SOAPException ex) {
            log.error((Object)"Error creating SOAPFault message", (Throwable)ex);
            throw new WebServiceException("Cannot create SOAPFault message for: " + reqEx);
        }
    }

    private static SOAPMessageImpl toSOAPMessage(javax.xml.ws.soap.SOAPFaultException faultEx) throws SOAPException {
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)factory.createMessage();
        SOAPBody soapBody = soapMessage.getSOAPBody();
        SOAPFaultHelperJAXWS.populateSOAPFault(soapBody, faultEx);
        Detail detail = faultEx.getFault().getDetail();
        if (detail != null) {
            soapBody.getFault().addChildElement((SOAPElement)detail);
        }
        return soapMessage;
    }

    private static void populateSOAPFault(SOAPBody soapBody, javax.xml.ws.soap.SOAPFaultException faultEx) throws SOAPException {
        SOAPFault sourceFault = faultEx.getFault();
        Name faultCode = sourceFault.getFaultCodeAsName();
        faultCode = faultCode != null ? new NameImpl(faultCode.getLocalName(), "codeNS", faultCode.getURI()) : SOAPFaultHelperJAXWS.getFallbackFaultCode();
        String faultString = sourceFault.getFaultString();
        if (faultString == null) {
            faultString = SOAPFaultHelperJAXWS.getFallbackFaultString((Exception)faultEx);
        }
        SOAPFault targetFault = soapBody.addFault(faultCode, faultString);
        String faultActor = sourceFault.getFaultActor();
        if (faultActor != null) {
            targetFault.setFaultActor(faultActor);
        }
    }

    private static SOAPMessageImpl toSOAPMessage(Exception ex) throws SOAPException {
        SOAPFault soapFault;
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)factory.createMessage();
        SOAPBody soapBody = soapMessage.getSOAPBody();
        Throwable cause = ex.getCause();
        if (cause instanceof javax.xml.ws.soap.SOAPFaultException) {
            SOAPFaultHelperJAXWS.populateSOAPFault(soapBody, (javax.xml.ws.soap.SOAPFaultException)cause);
            soapFault = soapBody.getFault();
        } else {
            soapFault = soapBody.addFault(SOAPFaultHelperJAXWS.getFallbackFaultCode(), SOAPFaultHelperJAXWS.getFallbackFaultString(ex));
        }
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        SerializationContext serContext = msgContext.getSerializationContext();
        NameImpl faultCode = (NameImpl)soapFault.getFaultCodeAsName();
        if (faultCode.getURI().length() > 0) {
            serContext.getNamespaceRegistry().registerQName(faultCode.toQName());
        }
        OperationMetaData opMetaData = msgContext.getOperationMetaData();
        Class<?> exClass = ex.getClass();
        if (opMetaData != null && opMetaData.getFault(exClass) != null) {
            FaultMetaData faultMetaData = opMetaData.getFault(exClass);
            Object faultBean = faultMetaData.toFaultBean(ex);
            Detail detail = soapFault.addDetail();
            SOAPElement detailEntry = SOAPFaultHelperJAXWS.toDetailEntry(faultBean, serContext, faultMetaData);
            detail.addChildElement(detailEntry);
        } else {
            log.debug((Object)("Cannot obtain fault meta data for: " + exClass));
        }
        return soapMessage;
    }

    private static Name getFallbackFaultCode() {
        return new NameImpl(Constants.SOAP11_FAULT_CODE_SERVER);
    }

    private static String getFallbackFaultString(Exception ex) {
        String faultString = ex.getMessage();
        if (faultString == null) {
            faultString = ex.toString();
        }
        return faultString;
    }

    private static SOAPElement toDetailEntry(Object faultObject, SerializationContext serContext, FaultMetaData faultMetaData) throws SOAPException {
        QName xmlName = faultMetaData.getXmlName();
        xmlName = serContext.getNamespaceRegistry().registerQName(xmlName);
        QName xmlType = faultMetaData.getXmlType();
        Class javaType = faultMetaData.getFaultBean();
        serContext.setJavaType(javaType);
        SerializerFactoryBase serFactory = (SerializerFactoryBase)serContext.getTypeMapping().getSerializer(javaType, xmlType);
        if (serFactory == null) {
            throw new WebServiceException("Cannot obtain serializer factory: xmlType=" + xmlType + ", javaType=" + javaType);
        }
        try {
            SerializerSupport ser = serFactory.getSerializer();
            Result result = ser.serialize(xmlName, xmlType, faultObject, serContext, null);
            XMLFragment xmlFragment = new XMLFragment(result);
            Element domElement = xmlFragment.toElement();
            SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
            return soapFactory.createElement(domElement);
        }
        catch (BindingException e) {
            throw new WebServiceException((Throwable)e);
        }
    }
}

