/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.Style;
import org.jboss.ws.core.jaxrpc.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.binding.JBossXBDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.JBossXBSerializerFactory;
import org.jboss.ws.core.utils.HolderUtils;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterWrapping {
    private static Logger log = Logger.getLogger(ParameterWrapping.class);

    private static void assertOperationMetaData(OperationMetaData opMetaData) {
        if (opMetaData.getStyle() != Style.DOCUMENT) {
            throw new WSException("Unexpected style: " + opMetaData.getStyle());
        }
        if (opMetaData.getParameterStyle() != SOAPBinding.ParameterStyle.WRAPPED) {
            throw new WSException("Unexpected parameter style: " + opMetaData.getParameterStyle());
        }
    }

    private static Object holderValue(Object holder) {
        if (holder == null) {
            return null;
        }
        if (!HolderUtils.isHolderType(holder.getClass())) {
            return holder;
        }
        return HolderUtils.getHolderValue(holder);
    }

    public static Class getWrappedType(String variable, Class wrapperType) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(variable, wrapperType);
            Method method = pd.getWriteMethod();
            return method.getParameterTypes()[0];
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid request wrapper: " + ex));
            }
            return null;
        }
    }

    public static Object wrapRequestParameters(ParameterMetaData request, Object[] methodParams) {
        ParameterWrapping.assertOperationMetaData(request.getOperationMetaData());
        Class reqStructType = request.getJavaType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("wrapRequestParameters: " + reqStructType.getName()));
        }
        List<WrappedParameter> wrappedParameters = request.getWrappedParameters();
        try {
            Object reqStruct = reqStructType.newInstance();
            for (WrappedParameter param : wrappedParameters) {
                Object value = ParameterWrapping.holderValue(methodParams[param.getIndex()]);
                param.accessor().set(reqStruct, value);
            }
            return reqStruct;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSException("Cannot wrap request structure: " + e);
        }
    }

    public static Map<Integer, Object> unwrapRequestParameters(ParameterMetaData request, Object reqStruct, Object[] methodParams) {
        OperationMetaData opMetaData = request.getOperationMetaData();
        ParameterWrapping.assertOperationMetaData(opMetaData);
        if (reqStruct == null) {
            throw new IllegalArgumentException("Request struct cannot be null");
        }
        Class<?>[] targetParameterTypes = opMetaData.getJavaMethod().getParameterTypes();
        HashMap<Integer, Object> outParameters = new HashMap<Integer, Object>(targetParameterTypes.length);
        List<WrappedParameter> wrappedParameters = request.getWrappedParameters();
        Class<?> reqStructType = reqStruct.getClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("unwrapRequestParameters: " + reqStructType.getName()));
        }
        try {
            for (WrappedParameter param : wrappedParameters) {
                Class<?> targetType = targetParameterTypes[param.getIndex()];
                Object value = param.accessor().get(reqStruct);
                if (HolderUtils.isHolderType(targetType)) {
                    value = HolderUtils.createHolderInstance(value, targetType);
                    outParameters.put(param.getIndex(), value);
                }
                methodParams[param.getIndex()] = value;
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot unwrap request structure: " + e);
        }
        return outParameters;
    }

    public static Object wrapResponseParameters(ParameterMetaData returnMetaData, Object returnValue, Map<Integer, Object> outParameters) {
        ParameterWrapping.assertOperationMetaData(returnMetaData.getOperationMetaData());
        Class resStructType = returnMetaData.getJavaType();
        if (returnValue != null && returnValue.getClass() == resStructType) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Response parameter already wrapped" + resStructType.getName()));
            }
            return returnValue;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("wrapResponseParameter: " + resStructType.getName()));
        }
        List<WrappedParameter> wrappedParameters = returnMetaData.getWrappedParameters();
        try {
            Object resStruct = resStructType.newInstance();
            for (WrappedParameter param : wrappedParameters) {
                Object value = param.getIndex() < 0 ? returnValue : ParameterWrapping.holderValue(outParameters.get(param.getIndex()));
                param.accessor().set(resStruct, value);
            }
            return resStruct;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WSException("Cannot wrap response structure: " + e);
        }
    }

    public static Object unwrapResponseParameters(ParameterMetaData retMetaData, Object resStruct, Object[] methodParams) {
        OperationMetaData operationMetaData = retMetaData.getOperationMetaData();
        ParameterWrapping.assertOperationMetaData(operationMetaData);
        Object retValue = null;
        if (resStruct != null) {
            Class<?> resStructType = resStruct.getClass();
            if (log.isDebugEnabled()) {
                log.debug((Object)("unwrapResponseParameter: " + resStructType.getName()));
            }
            List<WrappedParameter> wrappedParameters = retMetaData.getWrappedParameters();
            Class<?>[] targetTypes = operationMetaData.getJavaMethod().getParameterTypes();
            try {
                for (WrappedParameter param : wrappedParameters) {
                    Object value = param.accessor().get(resStruct);
                    if (param.getIndex() < 0) {
                        retValue = value;
                        continue;
                    }
                    Class<?> targetType = targetTypes[param.getIndex()];
                    if (HolderUtils.isHolderType(targetType)) {
                        HolderUtils.setHolderValue(methodParams[param.getIndex()], value);
                    }
                    methodParams[param.getIndex()] = value;
                }
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot unwrap request structure: " + e);
            }
        }
        return retValue;
    }

    public static void generateWrapper(ParameterMetaData pmd, boolean addTypeMapping) {
        Class wrapperType;
        List<WrappedParameter> wrappedParameters = pmd.getWrappedParameters();
        OperationMetaData operationMetaData = pmd.getOperationMetaData();
        EndpointMetaData endpointMetaData = operationMetaData.getEndpointMetaData();
        ServiceMetaData serviceMetaData = endpointMetaData.getServiceMetaData();
        ClassLoader loader = serviceMetaData.getUnifiedMetaData().getClassLoader();
        if (!operationMetaData.isDocumentWrapped()) {
            throw new WSException("Operation is not document/literal (wrapped)");
        }
        if (wrappedParameters == null) {
            throw new WSException("Cannot generate a type when their is no wrapped parameters");
        }
        String serviceName = serviceMetaData.getServiceName().getLocalPart();
        String parameterName = pmd.getXmlName().getLocalPart();
        String endpointName = endpointMetaData.getPortName().getLocalPart();
        String packageName = endpointMetaData.getServiceEndpointInterface().getPackage().getName();
        String wrapperName = packageName + "._JBossWS_" + serviceName + "_" + endpointName + "_" + parameterName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating wrapper: " + wrapperName));
        }
        try {
            ClassPool pool = new ClassPool(true);
            pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
            CtClass clazz = pool.makeClass(wrapperName);
            clazz.setSuperclass(pool.get(WrapperType.class.getName()));
            for (WrappedParameter param : wrappedParameters) {
                CtField field = new CtField(pool.get(param.getType()), param.getVariable(), clazz);
                field.setModifiers(2);
                clazz.addField(field);
                clazz.addMethod(CtNewMethod.getter((String)("get" + JavaUtils.capitalize(param.getVariable())), (CtField)field));
                clazz.addMethod(CtNewMethod.setter((String)("set" + JavaUtils.capitalize(param.getVariable())), (CtField)field));
            }
            wrapperType = pool.toClass(clazz, loader);
        }
        catch (Exception e) {
            throw new WSException("Could not generate wrapper type: " + wrapperName, e);
        }
        if (addTypeMapping) {
            QName xmlType = pmd.getXmlType();
            TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, wrapperName);
            typesMetaData.addTypeMapping(tmMetaData);
            TypeMappingImpl typeMapping = serviceMetaData.getTypeMapping();
            typeMapping.register(wrapperType, xmlType, new JBossXBSerializerFactory(), new JBossXBDeserializerFactory());
        }
        pmd.setJavaTypeName(wrapperName);
    }

    public static class WrapperType {
    }
}

