/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.UnMarshallerDecorator;
import org.jboss.remoting.transport.rmi.RMIServerInvokerInf;
import org.jboss.remoting.transport.rmi.RemotingRMIClientSocketFactory;
import org.jboss.remoting.transport.rmi.RemotingRMIServerSocketFactory;

public class RMIServerInvoker
extends ServerInvoker
implements RMIServerInvokerInf {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$rmi$RMIServerInvoker == null ? (class$org$jboss$remoting$transport$rmi$RMIServerInvoker = RMIServerInvoker.class$("org.jboss.remoting.transport.rmi.RMIServerInvoker")) : class$org$jboss$remoting$transport$rmi$RMIServerInvoker);
    private Remote stub;
    public static final int BACKLOG_DEFAULT = 200;
    public static final int DEFAULT_REGISTRY_PORT = 3455;
    public static final String REGISTRY_PORT_KEY = "registryPort";
    private Marshaller marshaller = null;
    private UnMarshaller unmarshaller = null;
    static /* synthetic */ Class class$org$jboss$remoting$transport$rmi$RMIServerInvoker;

    public RMIServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public void start() throws IOException {
        super.start();
        int bindPort = this.getServerBindPort();
        Registry registry = null;
        try {
            registry = this.getRegistry();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        String bindHost = this.getServerBindAddress();
        String clientConnectHost = this.getClientConnectAddress();
        if (clientConnectHost == null) {
            clientConnectHost = bindHost;
        }
        RemotingRMIServerSocketFactory ssf = new RemotingRMIServerSocketFactory(this.getServerSocketFactory(), 200, bindHost, this.getTimeout());
        RMIClientSocketFactory csf = this.getRMIClientSocketFactory(clientConnectHost);
        this.stub = UnicastRemoteObject.exportObject(this, bindPort, csf, ssf);
        log.debug("Binding registry to remoting/RMIServerInvoker/" + bindPort);
        registry.rebind("remoting/RMIServerInvoker/" + bindPort, this);
        this.unmarshaller = MarshalFactory.getUnMarshaller(this.getLocator(), this.getClass().getClassLoader());
        this.marshaller = MarshalFactory.getMarshaller(this.getLocator(), this.getClass().getClassLoader());
    }

    protected RMIClientSocketFactory getRMIClientSocketFactory(String clientConnectHost) {
        HashMap remoteConfig = new HashMap(this.configuration);
        remoteConfig.remove("customServerSocketFactory");
        remoteConfig.remove("socketCreationClientListener");
        remoteConfig.remove("socketCreationServerListener");
        return new RemotingRMIClientSocketFactory(this.locator, clientConnectHost, this.getTimeout(), remoteConfig);
    }

    protected SocketFactory getDefaultSocketFactory() {
        return null;
    }

    public RMIServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    private Registry getRegistry() throws Exception {
        String value;
        Registry registry = null;
        int port = 3455;
        Map params = this.getConfiguration();
        if (params != null && (value = (String)params.get(REGISTRY_PORT_KEY)) != null) {
            try {
                port = Integer.parseInt(value);
                log.debug("Using port " + port + " for rmi registry.");
            }
            catch (NumberFormatException e) {
                throw new Exception("Can not set the RMIServerInvoker RMI registry to port " + value + ".  This is not a valid port number.");
            }
        }
        try {
            log.debug("Creating registry for " + port);
            registry = LocateRegistry.createRegistry(port);
        }
        catch (ExportException exportEx) {
            log.debug("Locating registry for " + port);
            registry = LocateRegistry.getRegistry(port);
        }
        if (log.isTraceEnabled()) {
            log.trace("Got registry: " + registry);
        }
        return registry;
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    public void destroy() {
        super.destroy();
        try {
            try {
                log.debug("unbinding remoting/RMIServerInvoker/" + this.locator.getPort() + " from registry running on port " + (this.locator.getPort() + 1));
                Registry registry = this.getRegistry();
                registry.unbind("remoting/RMIServerInvoker/" + this.locator.getPort());
            }
            catch (Exception e) {
                log.error("Error unbinding RMIServerInvoker from RMI registry.", e);
            }
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public boolean isTransportBiDirectional() {
        return true;
    }

    public final Remote getStub() {
        return this.stub;
    }

    public Object transport(Object invocation) throws RemoteException, IOException {
        Object payload = invocation;
        if (this.unmarshaller != null) {
            if (this.unmarshaller instanceof UnMarshallerDecorator) {
                payload = ((UnMarshallerDecorator)((Object)this.unmarshaller)).removeDecoration(payload);
            } else {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(byteOut);
                oos.writeObject(payload);
                oos.flush();
                ByteArrayInputStream is = new ByteArrayInputStream(byteOut.toByteArray());
                try {
                    oos.close();
                    payload = this.unmarshaller.read(is, null);
                    is.close();
                }
                catch (ClassNotFoundException e) {
                    log.error("Could not unmarshall invocation request" + payload, e);
                    throw new IOException(e.getMessage());
                }
            }
        }
        Object response = this.invoke(payload);
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

