/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.Version;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.marshal.compress.CompressingUnMarshaller;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.transport.http.WebServerError;
import org.jboss.remoting.transport.web.WebUtil;
import org.jboss.util.Base64;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;
import org.jboss.util.threadpool.RunnableTaskWrapper;
import org.jboss.util.threadpool.ThreadPool;

public class HTTPClientInvoker
extends RemoteClientInvoker {
    public static final String MAX_NUM_TIMEOUT_THREADS = "maxNumTimeoutThreads";
    public static final String MAX_TIMEOUT_QUEUE_SIZE = "maxTimeoutQueueSize";
    public static final int MAX_NUM_TIMEOUT_THREADS_DEFAULT = 10;
    protected final Logger log = Logger.getLogger(this.getClass());
    private Object timeoutThreadPoolLock = new Object();
    private ThreadPool timeoutThreadPool;
    static /* synthetic */ Class class$org$jboss$remoting$transport$http$HTTPClientInvoker;
    static /* synthetic */ Class class$java$net$SocketAddress;

    public HTTPClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    public HTTPClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    protected Object transport(String sessionId, final Object invocation, Map metadata, final Marshaller marshaller, final UnMarshaller unmarshaller) throws IOException, ConnectionFailedException {
        Object result;
        HttpURLConnection conn;
        int simulatedTimeout;
        String validatedUrl = this.validateURL(this.getLocator().getLocatorURI());
        if (metadata == null) {
            metadata = new HashMap();
        }
        if ((simulatedTimeout = this.getSimulatedTimeout(this.configuration, metadata, conn = this.createURLConnection(validatedUrl, metadata))) < 0) {
            return this.useHttpURLConnection(conn, invocation, metadata, marshaller, unmarshaller);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("using simulated timeout: " + simulatedTimeout);
        }
        class Holder {
            public Object value;

            Holder() {
            }
        }
        final Holder resultHolder = new Holder();
        final HashMap finalMetadata = metadata;
        Runnable r = new Runnable(){
            {
            }

            public void run() {
                block3: {
                    try {
                        resultHolder.value = HTTPClientInvoker.this.useHttpURLConnection(conn, invocation, finalMetadata, marshaller, unmarshaller);
                        if (HTTPClientInvoker.this.log.isTraceEnabled()) {
                            HTTPClientInvoker.this.log.trace("result: " + resultHolder.value);
                        }
                    }
                    catch (Exception e) {
                        resultHolder.value = e;
                        if (!HTTPClientInvoker.this.log.isTraceEnabled()) break block3;
                        HTTPClientInvoker.this.log.trace("exception: " + e);
                    }
                }
            }
        };
        Thread.interrupted();
        ThreadPool pool = this.getTimeoutThreadPool();
        WaitingTaskWrapper wrapper = new WaitingTaskWrapper(r, simulatedTimeout);
        if (this.log.isTraceEnabled()) {
            this.log.trace("starting task in thread pool");
        }
        pool.runTaskWrapper(wrapper);
        if (this.log.isTraceEnabled()) {
            this.log.trace("task finished in thread pool");
        }
        if ((result = resultHolder.value) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("invocation timed out");
            }
            throw new SocketTimeoutException("timed out");
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof RuntimeException) {
            throw (RuntimeException)result;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("returning result: " + result);
        }
        return result;
    }

    private Object useHttpURLConnection(HttpURLConnection conn, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws WebServerError {
        Object result = null;
        int responseCode = -1;
        try {
            Map header;
            this.setChunked(this.configuration, conn);
            String basicAuth = this.getBasicAuth(metadata);
            if (basicAuth != null) {
                conn.setRequestProperty("Authorization", basicAuth);
            }
            if ((result = this.checkForLeasePing(conn, invocation, metadata)) != null) {
                return result;
            }
            boolean sendingData = true;
            String type = "POST";
            if (metadata != null) {
                type = (String)metadata.get("TYPE");
                if (type != null) {
                    if (!type.equals("POST") && !type.equals("PUT")) {
                        sendingData = false;
                    }
                } else {
                    type = "POST";
                }
            } else {
                metadata = new HashMap<String, Object>();
                header = new HashMap<String, String>();
                header.put("Content-Type", WebUtil.getContentType(invocation));
                metadata.put("HEADER", header);
            }
            if ((header = (Map)metadata.get("HEADER")) != null) {
                Set keys = header.keySet();
                Iterator itr = keys.iterator();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    String value = (String)header.get(key);
                    this.log.debug("Setting request header with " + key + " : " + value);
                    conn.setRequestProperty(key, value);
                }
            } else {
                conn.setRequestProperty("Content-Type", WebUtil.getContentType(invocation));
            }
            conn.setRequestProperty("JBoss-Remoting-Version", new Integer(Version.getDefaultVersion()).toString());
            conn.setRequestProperty("User-Agent", "JBossRemoting - 2.2.0 SP4 (Bluto)");
            if (sendingData) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod(type);
                OutputStream stream = conn.getOutputStream();
                if (marshaller instanceof VersionedMarshaller) {
                    ((VersionedMarshaller)marshaller).write(invocation, stream, Version.getDefaultVersion());
                } else {
                    marshaller.write(invocation, stream);
                }
                responseCode = conn.getResponseCode();
                InputStream is = responseCode < 400 ? conn.getInputStream() : conn.getErrorStream();
                Map<String, List<String>> headers = conn.getHeaderFields();
                if (metadata == null) {
                    metadata = new HashMap();
                }
                if (headers != null) {
                    Iterator<Map.Entry<String, List<String>>> i = headers.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry<String, List<String>> e = i.next();
                        if (e.getKey() == null) continue;
                        metadata.put(e.getKey(), e.getValue());
                    }
                }
                metadata.put("ResponseCodeMessage", conn.getResponseMessage());
                metadata.put("ResponseCode", new Integer(responseCode));
                result = this.readResponse(metadata, headers, unmarshaller, is);
            } else {
                conn.setDoOutput(false);
                conn.setDoInput(true);
                conn.setRequestMethod(type);
                conn.connect();
                InputStream is = conn.getResponseCode() < 400 ? conn.getInputStream() : conn.getErrorStream();
                Map<String, List<String>> headers = conn.getHeaderFields();
                result = this.readResponse(null, headers, unmarshaller, is);
                if (metadata == null) {
                    metadata = new HashMap();
                }
                metadata.putAll(headers);
                metadata.put("ResponseCodeMessage", conn.getResponseMessage());
                responseCode = conn.getResponseCode();
                metadata.put("ResponseCode", new Integer(responseCode));
            }
        }
        catch (Exception e) {
            this.log.debug("Error invoking http client invoker.", e);
            throw new CannotConnectException("Can not connect http client invoker.", e);
        }
        if (responseCode >= 400) {
            WebServerError ex;
            boolean doNotThrow;
            Object configObj;
            if (metadata != null && (configObj = metadata.get("NoThrowOnError")) != null && configObj instanceof String && (doNotThrow = Boolean.valueOf((String)configObj).booleanValue())) {
                if (result instanceof String) {
                    WebServerError ex2 = new WebServerError((String)result);
                    return ex2;
                }
                if (result instanceof InvocationResponse) {
                    return ((InvocationResponse)result).getResult();
                }
                return result;
            }
            if (result instanceof InvocationResponse) {
                return result;
            }
            if (result instanceof String) {
                ex = new WebServerError((String)result);
                throw ex;
            }
            ex = new WebServerError("Error received when calling on web server.  Error returned was " + responseCode);
            throw ex;
        }
        return result;
    }

    private Object checkForLeasePing(HttpURLConnection conn, Object invocation, Map metadata) throws IOException {
        InvocationRequest request;
        Object payload;
        InvocationResponse response = null;
        boolean shouldLease = false;
        long leasePeriod = -1L;
        if (invocation != null && invocation instanceof InvocationRequest && (payload = (request = (InvocationRequest)invocation).getParameter()) != null && payload instanceof String && "$PING$".equalsIgnoreCase((String)payload) && request.getReturnPayload() != null) {
            try {
                conn.setDoOutput(false);
                conn.setDoInput(true);
                conn.setRequestMethod("HEAD");
                conn.setRequestProperty("JBoss-Remoting-Version", new Integer(Version.getDefaultVersion()).toString());
                conn.setRequestProperty("User-Agent", "JBossRemoting - 2.2.0 SP4 (Bluto)");
                conn.setRequestProperty("JBoss-Remoting-Lease-Query", "true");
                conn.setRequestProperty("sessionId", request.getSessionId());
                conn.connect();
                Map<String, List<String>> headers = conn.getHeaderFields();
                if (headers != null) {
                    List<String> leasingPeriod;
                    List<String> leasingEnabled = headers.get("LEASING_ENABLED");
                    if (leasingEnabled != null && leasingEnabled instanceof List) {
                        shouldLease = new Boolean(leasingEnabled.get(0));
                    }
                    if ((leasingPeriod = headers.get("LEASE_PERIOD")) != null && leasingPeriod instanceof List) {
                        leasePeriod = new Long(leasingPeriod.get(0));
                    }
                }
            }
            catch (IOException e) {
                this.log.error("Error checking server for lease information.", e);
            }
            HashMap<String, Long> p = new HashMap<String, Long>();
            p.put("clientLeasePeriod", new Long(leasePeriod));
            InvocationResponse innterResponse = new InvocationResponse(null, new Boolean(shouldLease), false, p);
            response = new InvocationResponse(null, innterResponse, false, null);
        }
        return response;
    }

    private Object readResponse(Map metadata, Map headers, UnMarshaller unmarshaller, InputStream is) throws IOException, ClassNotFoundException {
        String encoding = null;
        Object ceObj = headers.get("Content-Encoding");
        if (ceObj != null && ceObj instanceof List) {
            encoding = (String)((List)ceObj).get(0);
        }
        if (encoding != null && encoding.indexOf("gzip") >= 0) {
            unmarshaller = new CompressingUnMarshaller(MarshalFactory.getUnMarshaller("serializable"));
        }
        Map map = metadata == null ? headers : metadata;
        Object result = unmarshaller instanceof VersionedUnMarshaller ? ((VersionedUnMarshaller)unmarshaller).read(is, map, Version.getDefaultVersion()) : unmarshaller.read(is, map);
        return result;
    }

    private void setChunked(Map metadata, HttpURLConnection conn) {
        String chunkedValue = (String)metadata.get("chunkedLength");
        if (chunkedValue != null && chunkedValue.length() > 0) {
            try {
                int chunkedLength = Integer.parseInt(chunkedValue);
                try {
                    Method setChunkedLengthMethod = conn.getClass().getMethod("setChunkedStreamingMode", Integer.TYPE);
                    setChunkedLengthMethod.invoke((Object)conn, new Integer(chunkedLength));
                }
                catch (NoSuchMethodException e) {
                    this.log.warn("Could not set chunked length (" + chunkedLength + ") on http client transport as method not available with JDK 1.4 (only JDK 1.5 or higher)");
                }
                catch (IllegalAccessException e) {
                    this.log.error("Error setting http client connection chunked length.");
                    this.log.debug(e);
                }
                catch (InvocationTargetException e) {
                    this.log.error("Error setting http client connection chunked length.");
                    this.log.debug(e);
                }
            }
            catch (NumberFormatException e) {
                this.log.error("Could not set chunked length for http client connection because value (" + chunkedValue + ") is not a number.");
            }
        }
    }

    private int getSimulatedTimeout(Map configuration, Map metadata, HttpURLConnection conn) {
        int simulatedTimeout = -1;
        int timeout = -1;
        String connectionTimeout = (String)configuration.get("timeout");
        String invocationTimeout = (String)metadata.get("timeout");
        if (invocationTimeout != null && invocationTimeout.length() > 0) {
            try {
                timeout = Integer.parseInt(invocationTimeout);
            }
            catch (NumberFormatException e) {
                this.log.error("Could not set timeout for current invocation because value (" + invocationTimeout + ") is not a number.");
            }
        }
        if (timeout < 0 && connectionTimeout != null && connectionTimeout.length() > 0) {
            try {
                timeout = Integer.parseInt(connectionTimeout);
            }
            catch (NumberFormatException e) {
                this.log.error("Could not set timeout for http client connection because value (" + connectionTimeout + ") is not a number.");
            }
        }
        if (timeout < 0) {
            return -1;
        }
        try {
            Method setTimeoutMethod = conn.getClass().getMethod("setConnectTimeout", Integer.TYPE);
            setTimeoutMethod.invoke((Object)conn, new Integer(timeout));
            setTimeoutMethod = conn.getClass().getMethod("setReadTimeout", Integer.TYPE);
            setTimeoutMethod.invoke((Object)conn, new Integer(timeout));
        }
        catch (NoSuchMethodException e) {
            simulatedTimeout = timeout;
            this.log.debug("Using older JDK (prior to 1.5): will simulate timeout");
        }
        catch (IllegalAccessException e) {
            simulatedTimeout = timeout;
            this.log.error("Error setting http client connection timeout.");
            this.log.debug(e);
        }
        catch (InvocationTargetException e) {
            simulatedTimeout = timeout;
            this.log.error("Error setting http client connection timeout.");
            this.log.debug(e);
        }
        return simulatedTimeout;
    }

    protected String validateURL(String url) {
        String validatedUrl = url;
        if (validatedUrl.startsWith("servlet")) {
            validatedUrl = "http" + validatedUrl.substring("servlet".length());
        }
        return validatedUrl;
    }

    protected HttpURLConnection createURLConnection(String url, Map metadata) throws IOException {
        URL externalURL = null;
        HttpURLConnection httpURLConn = null;
        String proxyHost = null;
        String proxyportString = null;
        int proxyPort = 80;
        if (metadata != null) {
            proxyHost = (String)metadata.get("http.proxyHost");
            proxyportString = (String)metadata.get("http.proxyPort");
            if (proxyportString != null && proxyportString.length() > 0) {
                try {
                    proxyPort = Integer.parseInt(proxyportString);
                }
                catch (NumberFormatException e) {
                    this.log.warn("Error converting proxy port specified (" + proxyportString + ") to a number.");
                }
            }
        }
        if (proxyHost != null) {
            externalURL = new URL(url);
            try {
                Class proxyClass = ClassLoaderUtility.loadClass("java.net.Proxy", class$org$jboss$remoting$transport$http$HTTPClientInvoker == null ? (class$org$jboss$remoting$transport$http$HTTPClientInvoker = HTTPClientInvoker.class$("org.jboss.remoting.transport.http.HTTPClientInvoker")) : class$org$jboss$remoting$transport$http$HTTPClientInvoker);
                InetSocketAddress proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
                Class<?>[] decalredClasses = proxyClass.getDeclaredClasses();
                Class<?> proxyTypeClass = null;
                for (int x = 0; x < decalredClasses.length; ++x) {
                    Class<?> declaredClass = decalredClasses[x];
                    String className = declaredClass.getName();
                    if (!className.endsWith("Type")) continue;
                    proxyTypeClass = declaredClass;
                    break;
                }
                Object proxyType = null;
                Field[] fields = proxyTypeClass.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    String fieldName = field.getName();
                    if (!fieldName.endsWith("HTTP")) continue;
                    proxyType = field.get(proxyTypeClass);
                    break;
                }
                Constructor proxyConstructor = proxyClass.getConstructor(proxyTypeClass, class$java$net$SocketAddress == null ? (class$java$net$SocketAddress = HTTPClientInvoker.class$("java.net.SocketAddress")) : class$java$net$SocketAddress);
                Object proxy = proxyConstructor.newInstance(proxyType, proxyAddress);
                Method openConnection = externalURL.getClass().getMethod("openConnection", proxyClass);
                httpURLConn = (HttpURLConnection)openConnection.invoke((Object)externalURL, proxy);
            }
            catch (Exception e) {
                this.log.error("Can not set proxy for http invocation (proxy host: " + proxyHost + ", proxy port: " + proxyPort + ") " + "as this configuration requires JDK 1.5 or later.  If running JDK 1.4, can use proxy by setting system properties.");
                this.log.debug(e);
            }
            String proxyAuth = this.getProxyAuth(metadata);
            if (proxyAuth != null) {
                httpURLConn.setRequestProperty("Proxy-Authorization", proxyAuth);
            }
        } else {
            externalURL = new URL(url);
            httpURLConn = (HttpURLConnection)externalURL.openConnection();
        }
        return httpURLConn;
    }

    private String getProxyAuth(Map metadata) {
        String authString = null;
        String username = null;
        String password = null;
        if (metadata != null) {
            username = (String)metadata.get("http.proxy.username");
        }
        if (username == null || username.length() == 0) {
            username = System.getProperty("http.proxy.username");
        }
        if (metadata != null) {
            password = (String)metadata.get("http.proxy.password");
        }
        if (password == null) {
            password = System.getProperty("http.proxy.password");
        }
        if (username != null && password != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(username);
            buffer.append(":");
            buffer.append(password);
            String encoded = Base64.encodeBytes(buffer.toString().getBytes());
            authString = "Basic " + encoded;
        }
        return authString;
    }

    private String getBasicAuth(Map metadata) {
        String authString = null;
        String username = null;
        String password = null;
        if (metadata != null) {
            username = (String)metadata.get("http.basic.username");
        }
        if (username == null || username.length() == 0) {
            username = System.getProperty("http.basic.username");
        }
        if (metadata != null) {
            password = (String)metadata.get("http.basic.password");
        }
        if (password == null) {
            password = System.getProperty("http.basic.password");
        }
        if (username != null && password != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(username);
            buffer.append(":");
            buffer.append(password);
            String encoded = Base64.encodeBytes(buffer.toString().getBytes());
            authString = "Basic " + encoded;
        }
        return authString;
    }

    protected void handleConnect() throws ConnectionFailedException {
    }

    protected void handleDisconnect() {
    }

    protected String getDefaultDataType() {
        return "http";
    }

    public void setTimeoutThreadPool(ThreadPool pool) {
        this.timeoutThreadPool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool getTimeoutThreadPool() {
        Object object = this.timeoutThreadPoolLock;
        synchronized (object) {
            if (this.timeoutThreadPool == null) {
                int maxNumberThreads = 10;
                int maxTimeoutQueueSize = -1;
                BasicThreadPool pool = new BasicThreadPool("HTTP timeout");
                this.log.debug("created new thread pool: " + pool);
                Object param = this.configuration.get(MAX_NUM_TIMEOUT_THREADS);
                if (param instanceof String) {
                    try {
                        maxNumberThreads = Integer.parseInt((String)param);
                    }
                    catch (NumberFormatException e) {
                        this.log.error("maxNumberThreads parameter has invalid format: " + param);
                    }
                } else if (param != null) {
                    this.log.error("maxNumberThreads parameter must be a string in integer format: " + param);
                }
                if ((param = this.configuration.get(MAX_TIMEOUT_QUEUE_SIZE)) instanceof String) {
                    try {
                        maxTimeoutQueueSize = Integer.parseInt((String)param);
                    }
                    catch (NumberFormatException e) {
                        this.log.error("maxTimeoutQueueSize parameter has invalid format: " + param);
                    }
                } else if (param != null) {
                    this.log.error("maxTimeoutQueueSize parameter must be a string in integer format: " + param);
                }
                pool.setMaximumPoolSize(maxNumberThreads);
                if (maxTimeoutQueueSize > 0) {
                    pool.setMaximumQueueSize(maxTimeoutQueueSize);
                }
                pool.setBlockingMode(BlockingMode.RUN);
                this.timeoutThreadPool = pool;
            }
        }
        return this.timeoutThreadPool;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class WaitingTaskWrapper
    extends RunnableTaskWrapper {
        long completeTimeout;

        public WaitingTaskWrapper(Runnable runnable, long completeTimeout) {
            super(runnable, 0L, completeTimeout);
            this.completeTimeout = completeTimeout;
        }

        public int getTaskWaitType() {
            return 2;
        }

        public String toString() {
            return "WaitingTaskWrapper[" + this.completeTimeout + "]";
        }
    }
}

