/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvalidConfigurationException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.transport.ClientFactory;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.transport.ServerFactory;
import org.jboss.remoting.transport.local.LocalClientInvoker;

public class InvokerRegistry {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$InvokerRegistry == null ? (class$org$jboss$remoting$InvokerRegistry = InvokerRegistry.class$("org.jboss.remoting.InvokerRegistry")) : class$org$jboss$remoting$InvokerRegistry);
    private static boolean trace = log.isTraceEnabled();
    private static final Map clientLocators = new HashMap();
    private static final Map serverLocators = new HashMap();
    private static final Set registeredLocators = new HashSet();
    private static final Object serverLock = new Object();
    private static final Object clientLock = new Object();
    private static final Map transportClientFactoryClasses = new HashMap();
    private static final Map transportServerFactoryClasses = new HashMap();
    static /* synthetic */ Class class$org$jboss$remoting$InvokerRegistry;
    static /* synthetic */ Class class$org$jboss$remoting$InvokerLocator;
    static /* synthetic */ Class class$java$util$Map;

    public static final synchronized InvokerLocator[] getRegisteredServerLocators() {
        return registeredLocators.toArray(new InvokerLocator[registeredLocators.size()]);
    }

    public static synchronized InvokerLocator getSuitableServerLocatorForRemote(InvokerLocator remote) {
        Iterator iter = registeredLocators.iterator();
        while (iter.hasNext()) {
            InvokerLocator l = (InvokerLocator)iter.next();
            if (!l.getProtocol().equals(remote.getProtocol())) continue;
            return l;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getRegisteredInvokerTransports() {
        Object object = clientLock;
        synchronized (object) {
            Set set = transportClientFactoryClasses.keySet();
            String[] transports = new String[set.size()];
            return set.toArray(transports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ClientInvoker[] getClientInvokers() {
        Object object = clientLock;
        synchronized (object) {
            if (clientLocators.isEmpty()) {
                return new ClientInvoker[0];
            }
            ArrayList<ClientInvoker> clientInvokerList = new ArrayList<ClientInvoker>();
            Collection collection = clientLocators.values();
            Iterator itr = collection.iterator();
            while (itr.hasNext()) {
                List holderList = (List)itr.next();
                if (holderList == null) continue;
                for (int x = 0; x < holderList.size(); ++x) {
                    ClientInvokerHolder holder = (ClientInvokerHolder)holderList.get(x);
                    clientInvokerList.add(holder.getClientInvoker());
                }
            }
            return clientInvokerList.toArray(new ClientInvoker[clientInvokerList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ServerInvoker[] getServerInvokers() {
        Object object = serverLock;
        synchronized (object) {
            if (serverLocators.isEmpty()) {
                return new ServerInvoker[0];
            }
            Collection collection = serverLocators.values();
            return collection.toArray(new ServerInvoker[collection.size()]);
        }
    }

    public static synchronized void registerInvokerFactories(String transport, Class clientFactory, Class serverFactory) {
        transportClientFactoryClasses.put(transport, clientFactory);
        transportServerFactoryClasses.put(transport, serverFactory);
    }

    public static synchronized void unregisterInvokerFactories(String transport) {
        transportClientFactoryClasses.remove(transport);
        transportServerFactoryClasses.remove(transport);
    }

    public static synchronized void unregisterLocator(InvokerLocator locator) {
        serverLocators.remove(locator);
        registeredLocators.remove(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isClientInvokerRegistered(InvokerLocator locator) {
        Object object = clientLock;
        synchronized (object) {
            return clientLocators.containsKey(locator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyClientInvoker(InvokerLocator locator, Map configuration) {
        Object object = clientLock;
        synchronized (object) {
            ClientInvoker invoker;
            if (trace) {
                log.trace("destroying client invoker " + locator + ", config " + configuration);
            }
            if ((invoker = InvokerRegistry.decrementClientInvokerCounter(locator, configuration)) != null) {
                if (trace) {
                    log.trace("disconnecting " + invoker);
                }
                invoker.disconnect();
                Object var3_3 = null;
            }
        }
    }

    public static ClientInvoker createClientInvoker(InvokerLocator locator) throws Exception {
        return InvokerRegistry.createClientInvoker(locator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientInvoker createClientInvoker(InvokerLocator locator, Map configuration) throws Exception {
        if (locator == null) {
            throw new NullPointerException("locator cannot be null");
        }
        Object object = clientLock;
        synchronized (object) {
            ServerInvoker svrInvoker;
            String value;
            ClientInvoker invoker = InvokerRegistry.getRegisteredClientInvoker(locator, configuration);
            if (invoker != null) {
                if (trace) {
                    log.trace("Found and returning cached client invoker (" + invoker + ")");
                }
                return invoker;
            }
            boolean isForceRemote = false;
            boolean isPassByValue = false;
            Map parameters = locator.getParameters();
            if (parameters != null) {
                value = (String)parameters.get("byvalue");
                if (value != null && Boolean.valueOf(value).booleanValue()) {
                    isPassByValue = true;
                }
                if ((value = (String)parameters.get("force_remote")) != null && Boolean.valueOf(value).booleanValue()) {
                    isForceRemote = true;
                }
            }
            if (configuration != null) {
                value = (String)configuration.get("byvalue");
                if (value != null && Boolean.valueOf(value).booleanValue()) {
                    isPassByValue = true;
                }
                if ((value = (String)configuration.get("force_remote")) != null && Boolean.valueOf(value).booleanValue()) {
                    isForceRemote = true;
                }
            }
            if ((svrInvoker = (ServerInvoker)serverLocators.get(locator)) != null && !isForceRemote) {
                LocalClientInvoker localInvoker = new LocalClientInvoker(locator, configuration, isPassByValue);
                localInvoker.setServerInvoker(svrInvoker);
                invoker = localInvoker;
                InvokerLocator l = invoker.getLocator();
                InvokerRegistry.addRegisteredClientInvoker(invoker, l, configuration);
            } else {
                String protocol = locator.getProtocol();
                if (protocol == null) {
                    throw new NullPointerException("protocol cannot be null for the locator");
                }
                invoker = InvokerRegistry.loadClientInvoker(protocol, locator, configuration);
                InvokerLocator l = invoker.getLocator();
                InvokerRegistry.addRegisteredClientInvoker(invoker, l, configuration);
            }
            return invoker;
        }
    }

    private static void addRegisteredClientInvoker(ClientInvoker invoker, InvokerLocator locator, Map configuration) {
        ClientInvokerHolder holder = new ClientInvokerHolder(invoker, configuration);
        ArrayList<ClientInvokerHolder> holderList = (ArrayList<ClientInvokerHolder>)clientLocators.get(locator);
        if (holderList != null) {
            if (holderList.contains(holder)) {
                throw new RuntimeException("Registering new ClientInvoker (" + invoker + "), but it already exists.");
            }
            holderList.add(holder);
        } else {
            holderList = new ArrayList<ClientInvokerHolder>();
            holderList.add(holder);
            clientLocators.put(locator, holderList);
        }
        InvokerRegistry.incrementClientInvokerCounter(holder);
    }

    private static ClientInvoker getRegisteredClientInvoker(InvokerLocator locator, Map configuration) {
        ClientInvoker invoker = null;
        List holderList = (List)clientLocators.get(locator);
        if (holderList != null) {
            for (int x = 0; x < holderList.size(); ++x) {
                ClientInvokerHolder holder = (ClientInvokerHolder)holderList.get(x);
                if (!InvokerRegistry.sameInvoker(holder, configuration)) continue;
                InvokerRegistry.incrementClientInvokerCounter(holder);
                invoker = holder.getClientInvoker();
            }
        }
        return invoker;
    }

    private static boolean sameInvoker(ClientInvokerHolder holder, Map configuration) {
        boolean isSame = false;
        if (holder != null && holder.getClientInvoker() != null) {
            Map config = holder.getConfig();
            if (config == null && configuration == null) {
                isSame = true;
            } else if (config != null && configuration != null) {
                isSame = ((Object)config).equals(configuration);
            }
        }
        return isSame;
    }

    private static void incrementClientInvokerCounter(ClientInvokerHolder holder) {
        holder.incrementCount();
    }

    private static ClientInvoker loadClientInvoker(String protocol, InvokerLocator locator, Map configuration) throws Exception {
        ClientInvoker clientInvoker = null;
        Class transportFactoryClass = InvokerRegistry.getTransportClientFactory(protocol);
        if (transportFactoryClass == null) {
            throw new ClassNotFoundException("Could not find class " + transportFactoryClass);
        }
        ClientFactory transportFactory = (ClientFactory)transportFactoryClass.newInstance();
        Method getClientInvokerMethod = transportFactoryClass.getMethod("createClientInvoker", class$org$jboss$remoting$InvokerLocator == null ? (class$org$jboss$remoting$InvokerLocator = InvokerRegistry.class$("org.jboss.remoting.InvokerLocator")) : class$org$jboss$remoting$InvokerLocator, class$java$util$Map == null ? (class$java$util$Map = InvokerRegistry.class$("java.util.Map")) : class$java$util$Map);
        clientInvoker = (ClientInvoker)getClientInvokerMethod.invoke((Object)transportFactory, locator, configuration);
        return clientInvoker;
    }

    private static ServerInvoker loadServerInvoker(String protocol, InvokerLocator locator, Map configuration) throws Exception {
        ServerInvoker serverInvoker = null;
        Class transportFactoryClass = InvokerRegistry.getTransportServerFactory(protocol);
        if (transportFactoryClass == null) {
            throw new ClassNotFoundException("Could not find class " + transportFactoryClass);
        }
        ServerFactory transportFactory = (ServerFactory)transportFactoryClass.newInstance();
        Method getClientInvokerMethod = transportFactoryClass.getMethod("createServerInvoker", class$org$jboss$remoting$InvokerLocator == null ? (class$org$jboss$remoting$InvokerLocator = InvokerRegistry.class$("org.jboss.remoting.InvokerLocator")) : class$org$jboss$remoting$InvokerLocator, class$java$util$Map == null ? (class$java$util$Map = InvokerRegistry.class$("java.util.Map")) : class$java$util$Map);
        serverInvoker = (ServerInvoker)getClientInvokerMethod.invoke((Object)transportFactory, locator, configuration);
        return serverInvoker;
    }

    private static Class getTransportClientFactory(String protocol) throws ClassNotFoundException {
        Class transportFactoryClass = (Class)transportClientFactoryClasses.get(protocol);
        if (transportFactoryClass == null) {
            String transportFactoryClassName = "org.jboss.remoting.transport." + protocol + ".TransportClientFactory";
            transportFactoryClass = ClassLoaderUtility.loadClass(class$org$jboss$remoting$InvokerRegistry == null ? (class$org$jboss$remoting$InvokerRegistry = InvokerRegistry.class$("org.jboss.remoting.InvokerRegistry")) : class$org$jboss$remoting$InvokerRegistry, transportFactoryClassName);
            transportClientFactoryClasses.put(protocol, transportFactoryClass);
        }
        return transportFactoryClass;
    }

    private static Class getTransportServerFactory(String protocol) throws ClassNotFoundException {
        Class transportFactoryClass = (Class)transportServerFactoryClasses.get(protocol);
        if (transportFactoryClass == null) {
            String transportFactoryClassName = "org.jboss.remoting.transport." + protocol + ".TransportServerFactory";
            transportFactoryClass = ClassLoaderUtility.loadClass(transportFactoryClassName, class$org$jboss$remoting$InvokerRegistry == null ? (class$org$jboss$remoting$InvokerRegistry = InvokerRegistry.class$("org.jboss.remoting.InvokerRegistry")) : class$org$jboss$remoting$InvokerRegistry);
            transportServerFactoryClasses.put(protocol, transportFactoryClass);
        }
        return transportFactoryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServerInvokerRegistered(InvokerLocator locator) {
        Object object = serverLock;
        synchronized (object) {
            return serverLocators.containsKey(locator);
        }
    }

    public static ServerInvoker createServerInvoker(InvokerLocator locator) throws Exception {
        return InvokerRegistry.createServerInvoker(locator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerInvoker createServerInvoker(InvokerLocator locator, Map configuration) throws Exception {
        ServerInvoker invoker = null;
        Object object = serverLock;
        synchronized (object) {
            invoker = (ServerInvoker)serverLocators.get(locator);
            if (invoker != null) {
                throw new InvalidConfigurationException("The invoker for locator (" + locator + ") is already " + "in use by another Connector.  Either change the locator or " + "add new handlers to existing Connector.");
            }
            String protocol = locator.getProtocol();
            invoker = InvokerRegistry.loadServerInvoker(protocol, locator, configuration);
            serverLocators.put(locator, invoker);
            registeredLocators.add(invoker.getLocator());
        }
        return invoker;
    }

    public static void destroyServerInvoker(ServerInvoker invoker) {
        if (invoker != null) {
            InvokerLocator locator = invoker.getLocator();
            InvokerRegistry.unregisterLocator(locator);
        }
    }

    private static ClientInvoker decrementClientInvokerCounter(InvokerLocator locator, Map configuration) {
        Map config;
        List holderList = (List)clientLocators.get(locator);
        if (holderList == null) {
            log.debug("Could not decrement client invoker counter for locator " + locator + " as does not exist in invoker registry.");
            return null;
        }
        ClientInvokerHolder holder = null;
        for (int x = 0; !(x >= holderList.size() || (holder = (ClientInvokerHolder)holderList.get(x)) != null && ((config = holder.getConfig()) == null && configuration == null || config != null && configuration != null && ((Object)config).equals(configuration))); ++x) {
        }
        if (holder == null) {
            log.debug("Could not decrement client invoker counter for locator " + locator + "as does not exist in invoker registry with matching configuraion map.");
            return null;
        }
        ClientInvoker clientInvoker = null;
        holder.decrementCount();
        if (holder.getCount() == 0) {
            clientInvoker = holder.getClientInvoker();
            holderList.remove(holder);
            if (holderList.isEmpty()) {
                clientLocators.remove(locator);
            }
            log.debug("removed " + clientInvoker + " from registry");
        } else {
            log.debug("decremented " + holder.getClientInvoker() + "'s count, current count " + holder.getCount());
        }
        return clientInvoker;
    }

    public static synchronized void updateServerInvokerLocator(InvokerLocator locator, InvokerLocator newLocator) {
        Object si = serverLocators.get(locator);
        serverLocators.remove(locator);
        registeredLocators.remove(locator);
        serverLocators.put(newLocator, si);
        registeredLocators.add(newLocator);
    }

    public static boolean isSSLSupported(String transport) throws Exception {
        boolean isSSLSupported = false;
        Class transportFactoryClass = null;
        try {
            transportFactoryClass = InvokerRegistry.getTransportClientFactory(transport);
            ClientFactory clientFactory = (ClientFactory)transportFactoryClass.newInstance();
            Method meth = transportFactoryClass.getMethod("supportsSSL", new Class[0]);
            Boolean boolVal = (Boolean)meth.invoke((Object)clientFactory, null);
            isSSLSupported = boolVal;
        }
        catch (ClassNotFoundException e) {
            Exception ex = new Exception("Can not verify transport (" + transport + ") supports SSL because can not find invoker implementation matching transport.");
            ex.initCause(e);
            throw ex;
        }
        catch (NoSuchMethodException e) {
            Exception ex = new Exception("Can not call supportsSSL method on client factory class (" + transportFactoryClass + ") as there is no such method.");
            ex.initCause(e);
            throw ex;
        }
        catch (IllegalAccessException e) {
            Exception ex = new Exception("Can not call create instance of client factory class (" + transportFactoryClass + ").");
            ex.initCause(e);
            throw ex;
        }
        catch (InvocationTargetException e) {
            Exception ex = new Exception("Can not call supportsSSL method on client factory class (" + transportFactoryClass + ").");
            ex.initCause(e);
            throw ex;
        }
        catch (InstantiationException e) {
            Exception ex = new Exception("Can not call supportsSSL method on client factory class (" + transportFactoryClass + ").");
            ex.initCause(e);
            throw ex;
        }
        return isSSLSupported;
    }

    public String toString() {
        return "InvokerRegistry[" + Integer.toHexString(this.hashCode()) + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClientInvokerHolder {
        private ClientInvoker invoker = null;
        private Map config = null;
        private int counter = 0;

        public ClientInvokerHolder(ClientInvoker invoker, Map config) {
            this.invoker = invoker;
            this.config = config;
        }

        public void incrementCount() {
            ++this.counter;
        }

        public void decrementCount() {
            --this.counter;
            if (this.counter < 0) {
                throw new RuntimeException("ClientInvokerHolder decremented to negative number for client invoker " + this.invoker);
            }
        }

        public int getCount() {
            return this.counter;
        }

        public ClientInvoker getClientInvoker() {
            return this.invoker;
        }

        public Map getConfig() {
            return this.config;
        }

        public boolean equals(Object o) {
            ClientInvokerHolder h;
            boolean isEqual = false;
            if (o instanceof ClientInvokerHolder && this.invoker.equals((h = (ClientInvokerHolder)o).getClientInvoker())) {
                Map configuration = h.getConfig();
                if (this.config == null && configuration == null) {
                    isEqual = true;
                } else if (this.config != null && configuration != null) {
                    isEqual = ((Object)this.config).equals(configuration);
                }
            }
            return isEqual;
        }
    }
}

