/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLBindingFault;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLInterface;

public class WSDLBinding
implements Serializable {
    private static final long serialVersionUID = -7699953670233209811L;
    private static final Logger log = Logger.getLogger(WSDLBinding.class);
    private WSDLDefinitions wsdlDefinitions;
    private NCName name;
    private QName qname;
    private QName interfaceName;
    private String type;
    private ArrayList<WSDLBindingFault> faults = new ArrayList();
    private ArrayList<WSDLBindingOperation> operations = new ArrayList();

    public WSDLBinding(WSDLDefinitions wsdlDefinitions) {
        log.debug((Object)"new WSDLBinding");
        this.wsdlDefinitions = wsdlDefinitions;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public NCName getName() {
        return this.name;
    }

    public void setName(NCName name) {
        log.debug((Object)("setName: " + name));
        this.name = name;
    }

    public QName getQName() {
        if (this.qname == null) {
            String tnsURI = this.wsdlDefinitions.getTargetNamespace();
            this.qname = new QName(tnsURI, this.name.toString());
        }
        return this.qname;
    }

    public void setQName(QName qname) {
        log.debug((Object)("setQName: " + qname));
        this.qname = qname;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        log.debug((Object)("setInterfaceName: " + this.name));
        this.interfaceName = interfaceName;
    }

    public WSDLInterface getInterface() {
        WSDLInterface wsdlInterface = this.wsdlDefinitions.getInterface(new NCName(this.interfaceName.getLocalPart()));
        if (wsdlInterface == null) {
            throw new WSException("Cannot get interface for name: " + this.interfaceName);
        }
        return wsdlInterface;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public WSDLBindingFault[] getFaults() {
        WSDLBindingFault[] arr = new WSDLBindingFault[this.faults.size()];
        this.faults.toArray(arr);
        return arr;
    }

    public void addFault(WSDLBindingFault fault) {
        this.faults.add(fault);
    }

    public WSDLBindingOperation[] getOperations() {
        WSDLBindingOperation[] arr = new WSDLBindingOperation[this.operations.size()];
        this.operations.toArray(arr);
        return arr;
    }

    public WSDLBindingOperation getOperationByRef(QName qname) {
        WSDLBindingOperation wsdlBindingOperation = null;
        for (WSDLBindingOperation aux : this.operations) {
            if (!aux.getRef().equals(qname)) continue;
            if (wsdlBindingOperation != null) {
                log.warn((Object)("Multiple binding operations reference: " + qname));
            }
            wsdlBindingOperation = aux;
        }
        if (wsdlBindingOperation == null) {
            log.warn((Object)("Cannot obtain binding operation for ref: " + qname));
        }
        return wsdlBindingOperation;
    }

    public void addOperation(WSDLBindingOperation operation) {
        this.operations.add(operation);
    }
}

