/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.jsr109;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.jsr109.PortComponentMetaData;
import org.jboss.ws.metadata.jsr109.WebservicesMetaData;

public class WebserviceDescriptionMetaData {
    private static final Logger log = Logger.getLogger(WebserviceDescriptionMetaData.class);
    private WebservicesMetaData webservices;
    private String webserviceDescriptionName;
    private String wsdlFile;
    private String jaxrpcMappingFile;
    private ArrayList<PortComponentMetaData> portComponents = new ArrayList();

    public WebserviceDescriptionMetaData(WebservicesMetaData webservices) {
        this.webservices = webservices;
    }

    public WebservicesMetaData getWebservices() {
        return this.webservices;
    }

    public void addPortComponent(PortComponentMetaData portComponent) {
        this.portComponents.add(portComponent);
    }

    public PortComponentMetaData[] getPortComponents() {
        PortComponentMetaData[] array = new PortComponentMetaData[this.portComponents.size()];
        this.portComponents.toArray(array);
        return array;
    }

    public Collection getPortComponentQNames() {
        HashMap<String, QName> map = new HashMap<String, QName>();
        Iterator<PortComponentMetaData> iter = this.portComponents.iterator();
        while (iter != null && iter.hasNext()) {
            PortComponentMetaData pcm = iter.next();
            QName qname = pcm.getWsdlPort();
            map.put(qname.getPrefix(), qname);
        }
        return map.values();
    }

    public PortComponentMetaData getPortComponentByWsdlPort(String name) {
        ArrayList<String> pcNames = new ArrayList<String>();
        for (PortComponentMetaData pc : this.portComponents) {
            String wsdlPortName = pc.getWsdlPort().getLocalPart();
            if (wsdlPortName.equals(name)) {
                return pc;
            }
            pcNames.add(wsdlPortName);
        }
        log.error((Object)("Cannot get port component name '" + name + "', we have: " + pcNames));
        return null;
    }

    public String getWebserviceDescriptionName() {
        return this.webserviceDescriptionName;
    }

    public void setWebserviceDescriptionName(String webserviceDescriptionName) {
        this.webserviceDescriptionName = webserviceDescriptionName;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public void setJaxrpcMappingFile(String jaxrpcMappingFile) {
        this.jaxrpcMappingFile = jaxrpcMappingFile;
    }

    public String serialize() {
        StringBuilder buffer = new StringBuilder("<webservice-description> <webservice-description-name>");
        buffer.append(this.webserviceDescriptionName);
        buffer.append("</webservice-description-name>");
        buffer.append("<wsdl-file>" + this.wsdlFile + "</wsdl-file>");
        buffer.append("<jaxrpc-mapping-file>" + this.jaxrpcMappingFile + "</jaxrpc-mapping-file>");
        for (PortComponentMetaData pm : this.portComponents) {
            buffer.append(pm.serialize());
        }
        buffer.append("</webservice-description></webservices>");
        return buffer.toString();
    }
}

