/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc.encoding;

import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.utils.XMLPredefinedEntityReferenceResolver;

public abstract class DeserializerSupport
implements Deserializer {
    public abstract Object deserialize(QName var1, QName var2, String var3, SerializationContextImpl var4) throws BindingException;

    protected String unwrapValueStr(String xmlFragment) {
        if (this.isEmptyElement(xmlFragment)) {
            return this.isNil(xmlFragment) ? null : "";
        }
        int endOfStartTag = xmlFragment.indexOf(">");
        int startOfEndTag = xmlFragment.lastIndexOf("</");
        if (endOfStartTag < 0 || startOfEndTag < 0) {
            throw new IllegalArgumentException("Invalid XML fragment: " + xmlFragment);
        }
        String valueStr = xmlFragment.substring(endOfStartTag + 1, startOfEndTag);
        return XMLPredefinedEntityReferenceResolver.resolve(valueStr);
    }

    protected boolean isEmptyElement(String xmlFragment) {
        return xmlFragment.startsWith("<") && xmlFragment.endsWith("/>");
    }

    protected boolean isNil(String xmlFragment) {
        boolean isNil = false;
        if (this.isEmptyElement(xmlFragment)) {
            int endOfStartTag = xmlFragment.indexOf(">");
            String startTag = xmlFragment.substring(0, endOfStartTag);
            isNil = startTag.indexOf(":nil='1'") > 0 || startTag.indexOf(":nil=\"1\"") > 0;
            isNil = isNil || startTag.indexOf(":nil='true'") > 0 || startTag.indexOf(":nil=\"true\"") > 0;
        }
        return isNil;
    }

    public String getMechanismType() {
        throw new NotImplementedException();
    }
}

