/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.util.Collections;
import java.util.Map;
import javax.jcr.Credentials;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.core.security.CredentialsCallbackHandler;

public abstract class AuthContext {
    public abstract void login() throws LoginException;

    public abstract Subject getSubject();

    public abstract void logout() throws LoginException;

    public static class Local
    extends AuthContext {
        private final LoginModule module;
        private final Map options;
        private Subject subject;
        private Credentials creds;

        public Local(LoginModule module, Map options, Credentials creds) {
            this.module = module;
            this.options = options;
            this.creds = creds;
        }

        public void login() throws LoginException {
            this.subject = new Subject();
            this.module.initialize(this.subject, new CredentialsCallbackHandler(this.creds), Collections.EMPTY_MAP, this.options);
            LoginException failure = null;
            try {
                if (!this.module.login()) {
                    failure = new LoginException("Login not confirmed");
                }
            }
            catch (LoginException e) {
                failure = e;
            }
            if (failure != null) {
                this.module.abort();
                throw failure;
            }
            this.module.commit();
        }

        public Subject getSubject() {
            return this.subject;
        }

        public void logout() throws LoginException {
            if (this.subject == null) {
                throw new LoginException("Logout called before login");
            }
            this.module.logout();
        }
    }

    public static class JAAS
    extends AuthContext {
        private final LoginContext ctx;

        public JAAS(String name, Credentials creds) throws LoginException {
            this.ctx = new LoginContext(name, new CredentialsCallbackHandler(creds));
        }

        public void login() throws LoginException {
            this.ctx.login();
        }

        public Subject getSubject() {
            return this.ctx.getSubject();
        }

        public void logout() throws LoginException {
            this.ctx.logout();
        }
    }
}

