/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.sql;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.query.AndQueryNode;
import org.apache.jackrabbit.core.query.LocationStepQueryNode;
import org.apache.jackrabbit.core.query.NAryQueryNode;
import org.apache.jackrabbit.core.query.NodeTypeQueryNode;
import org.apache.jackrabbit.core.query.NotQueryNode;
import org.apache.jackrabbit.core.query.OrQueryNode;
import org.apache.jackrabbit.core.query.OrderQueryNode;
import org.apache.jackrabbit.core.query.PathQueryNode;
import org.apache.jackrabbit.core.query.PropertyFunctionQueryNode;
import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryRootNode;
import org.apache.jackrabbit.core.query.RelationQueryNode;
import org.apache.jackrabbit.core.query.TextsearchQueryNode;
import org.apache.jackrabbit.core.query.sql.ASTAndExpression;
import org.apache.jackrabbit.core.query.sql.ASTAscendingOrderSpec;
import org.apache.jackrabbit.core.query.sql.ASTBracketExpression;
import org.apache.jackrabbit.core.query.sql.ASTContainsExpression;
import org.apache.jackrabbit.core.query.sql.ASTDescendingOrderSpec;
import org.apache.jackrabbit.core.query.sql.ASTFromClause;
import org.apache.jackrabbit.core.query.sql.ASTIdentifier;
import org.apache.jackrabbit.core.query.sql.ASTLiteral;
import org.apache.jackrabbit.core.query.sql.ASTLowerFunction;
import org.apache.jackrabbit.core.query.sql.ASTNotExpression;
import org.apache.jackrabbit.core.query.sql.ASTOrExpression;
import org.apache.jackrabbit.core.query.sql.ASTOrderByClause;
import org.apache.jackrabbit.core.query.sql.ASTOrderSpec;
import org.apache.jackrabbit.core.query.sql.ASTPredicate;
import org.apache.jackrabbit.core.query.sql.ASTQuery;
import org.apache.jackrabbit.core.query.sql.ASTSelectList;
import org.apache.jackrabbit.core.query.sql.ASTUpperFunction;
import org.apache.jackrabbit.core.query.sql.ASTWhereClause;
import org.apache.jackrabbit.core.query.sql.DefaultParserVisitor;
import org.apache.jackrabbit.core.query.sql.JCRSQLParser;
import org.apache.jackrabbit.core.query.sql.JCRSQLParserVisitor;
import org.apache.jackrabbit.core.query.sql.Node;
import org.apache.jackrabbit.core.query.sql.ParseException;
import org.apache.jackrabbit.core.query.sql.QueryFormat;
import org.apache.jackrabbit.core.query.sql.SimpleNode;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRSQLQueryBuilder
implements JCRSQLParserVisitor {
    private static final Logger log = LoggerFactory.getLogger((Class)JCRSQLQueryBuilder.class);
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static Map parsers = new ReferenceMap(2, 2);
    private final ASTQuery stmt;
    private QueryRootNode root;
    private NamespaceResolver resolver;
    private final AndQueryNode constraintNode = new AndQueryNode(null);
    private final List pathConstraints = new ArrayList();

    private JCRSQLQueryBuilder(ASTQuery statement, NamespaceResolver resolver) {
        this.stmt = statement;
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryRootNode createQuery(String statement, NamespaceResolver resolver) throws InvalidQueryException {
        try {
            JCRSQLQueryBuilder builder;
            JCRSQLParser parser;
            Map map = parsers;
            synchronized (map) {
                parser = (JCRSQLParser)parsers.get(resolver);
                if (parser == null) {
                    parser = new JCRSQLParser(new StringReader(statement));
                    parser.setNamespaceResolver(resolver);
                    parsers.put(resolver, parser);
                }
            }
            JCRSQLParser jCRSQLParser = parser;
            synchronized (jCRSQLParser) {
                parser.ReInit(new StringReader(statement));
                builder = new JCRSQLQueryBuilder(parser.Query(), resolver);
            }
            return builder.getRootNode();
        }
        catch (ParseException e) {
            throw new InvalidQueryException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidQueryException(e.getMessage());
        }
        catch (Throwable t) {
            throw new InvalidQueryException(t.getMessage());
        }
    }

    public static String toString(QueryRootNode root, NamespaceResolver resolver) throws InvalidQueryException {
        return QueryFormat.toString(root, resolver);
    }

    private QueryRootNode getRootNode() {
        if (this.root == null) {
            this.stmt.jjtAccept(this, null);
        }
        return this.root;
    }

    public Object visit(SimpleNode node, Object data) {
        return data;
    }

    public Object visit(ASTQuery node, Object data) {
        this.root = new QueryRootNode();
        this.root.setLocationNode(new PathQueryNode(this.root));
        node.childrenAccept(this, this.root);
        PathQueryNode pathNode = this.root.getLocationNode();
        pathNode.setAbsolute(true);
        if (this.pathConstraints.size() == 0) {
            pathNode.addPathStep(new LocationStepQueryNode(pathNode, null, true));
        } else {
            MergingPathQueryNode path;
            try {
                while (this.pathConstraints.size() > 1) {
                    path = null;
                    Iterator it = this.pathConstraints.iterator();
                    while (it.hasNext() && !(path = (MergingPathQueryNode)it.next()).needsMerge()) {
                        path = null;
                    }
                    if (path == null) {
                        throw new IllegalArgumentException("Invalid combination of jcr:path clauses");
                    }
                    this.pathConstraints.remove(path);
                    MergingPathQueryNode[] paths = this.pathConstraints.toArray(new MergingPathQueryNode[this.pathConstraints.size()]);
                    paths = path.doMerge(paths);
                    this.pathConstraints.clear();
                    this.pathConstraints.addAll(Arrays.asList(paths));
                }
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException("Invalid combination of jcr:path clauses");
            }
            path = (MergingPathQueryNode)this.pathConstraints.get(0);
            LocationStepQueryNode[] steps = path.getPathSteps();
            for (int i = 0; i < steps.length; ++i) {
                LocationStepQueryNode step = new LocationStepQueryNode(pathNode, steps[i].getNameTest(), steps[i].getIncludeDescendants());
                step.setIndex(steps[i].getIndex());
                pathNode.addPathStep(step);
            }
        }
        if (this.constraintNode.getNumOperands() > 0) {
            LocationStepQueryNode[] steps = pathNode.getPathSteps();
            steps[steps.length - 1].addPredicate(this.constraintNode);
        }
        return this.root;
    }

    public Object visit(ASTSelectList node, Object data) {
        final QueryRootNode root = (QueryRootNode)data;
        node.childrenAccept(new DefaultParserVisitor(){

            public Object visit(ASTIdentifier node, Object data) {
                root.addSelectProperty(node.getName());
                return data;
            }
        }, root);
        return data;
    }

    public Object visit(ASTFromClause node, Object data) {
        QueryRootNode root = (QueryRootNode)data;
        return node.childrenAccept(new DefaultParserVisitor(){

            public Object visit(ASTIdentifier node, Object data) {
                if (!node.getName().equals((Object)QName.NT_BASE)) {
                    NodeTypeQueryNode nodeType = new NodeTypeQueryNode(JCRSQLQueryBuilder.this.constraintNode, node.getName());
                    JCRSQLQueryBuilder.this.constraintNode.addOperand(nodeType);
                }
                return data;
            }
        }, root);
    }

    public Object visit(ASTWhereClause node, Object data) {
        return node.childrenAccept(this, this.constraintNode);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visit(ASTPredicate node, Object data) {
        void var5_20;
        NAryQueryNode parent = (NAryQueryNode)data;
        int type = node.getOperationType();
        try {
            final QName[] tmp = new QName[2];
            final ASTLiteral[] value = new ASTLiteral[1];
            node.childrenAccept(new DefaultParserVisitor(){

                public Object visit(ASTIdentifier node, Object data) {
                    if (tmp[0] == null) {
                        tmp[0] = node.getName();
                    } else if (tmp[1] == null) {
                        tmp[1] = node.getName();
                    }
                    return data;
                }

                public Object visit(ASTLiteral node, Object data) {
                    value[0] = node;
                    return data;
                }

                public Object visit(ASTLowerFunction node, Object data) {
                    this.getIdentifier(node);
                    return data;
                }

                public Object visit(ASTUpperFunction node, Object data) {
                    this.getIdentifier(node);
                    return data;
                }

                private void getIdentifier(SimpleNode node) {
                    Node n;
                    if (node.jjtGetNumChildren() > 0 && (n = node.jjtGetChild(0)) instanceof ASTIdentifier) {
                        ASTIdentifier identifier = (ASTIdentifier)n;
                        if (tmp[0] == null) {
                            tmp[0] = identifier.getName();
                        } else if (tmp[1] == null) {
                            tmp[1] = identifier.getName();
                        }
                    }
                }
            }, data);
            QName identifier = tmp[0];
            if (identifier.equals((Object)QName.JCR_PATH)) {
                if (tmp[1] != null) return data;
                this.createPathQuery(value[0].getValue(), parent.getType());
                return data;
            }
            if (type == 24) {
                AndQueryNode between = new AndQueryNode(parent);
                RelationQueryNode rel = this.createRelationQueryNode(between, identifier, 20, (ASTLiteral)node.children[1]);
                node.childrenAccept(this, rel);
                between.addOperand(rel);
                rel = this.createRelationQueryNode(between, identifier, 22, (ASTLiteral)node.children[2]);
                node.childrenAccept(this, rel);
                between.addOperand(rel);
                AndQueryNode andQueryNode = between;
            } else if (type == 20 || type == 18 || type == 22 || type == 16 || type == 14 || type == 12) {
                RelationQueryNode relationQueryNode = this.createRelationQueryNode(parent, identifier, type, value[0]);
                node.childrenAccept(this, relationQueryNode);
            } else if (type == 23) {
                ASTLiteral pattern = value[0];
                if (node.getEscapeString() != null) {
                    if (node.getEscapeString().length() != 1) throw new IllegalArgumentException("ESCAPE string value must have length 1: '" + node.getEscapeString() + "'");
                    pattern.setValue(JCRSQLQueryBuilder.translateEscaping(pattern.getValue(), node.getEscapeString().charAt(0), '\\'));
                } else {
                    pattern.setValue(pattern.getValue().replaceAll("\\\\", "\\\\\\\\"));
                }
                RelationQueryNode relationQueryNode = this.createRelationQueryNode(parent, identifier, type, pattern);
                node.childrenAccept(this, relationQueryNode);
            } else if (type == 25) {
                OrQueryNode in = new OrQueryNode(parent);
                for (int i = 1; i < node.children.length; ++i) {
                    RelationQueryNode rel = this.createRelationQueryNode(in, identifier, 11, (ASTLiteral)node.children[i]);
                    node.childrenAccept(this, rel);
                    in.addOperand(rel);
                }
                OrQueryNode orQueryNode = in;
            } else {
                if (type != 26 && type != 27) throw new IllegalArgumentException("Unknown operation type: " + type);
                ASTLiteral star = new ASTLiteral(13);
                star.setType(3);
                star.setValue("%");
                RelationQueryNode relationQueryNode = this.createRelationQueryNode(parent, identifier, type, star);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Too few arguments in predicate");
        }
        if (var5_20 == null) return data;
        parent.addOperand((QueryNode)var5_20);
        return data;
    }

    public Object visit(ASTOrExpression node, Object data) {
        NAryQueryNode parent = (NAryQueryNode)data;
        OrQueryNode orQuery = new OrQueryNode(parent);
        node.childrenAccept(this, orQuery);
        if (orQuery.getNumOperands() > 0) {
            parent.addOperand(orQuery);
        }
        return parent;
    }

    public Object visit(ASTAndExpression node, Object data) {
        NAryQueryNode parent = (NAryQueryNode)data;
        AndQueryNode andQuery = new AndQueryNode(parent);
        node.childrenAccept(this, andQuery);
        parent.addOperand(andQuery);
        return parent;
    }

    public Object visit(ASTNotExpression node, Object data) {
        NAryQueryNode parent = (NAryQueryNode)data;
        NotQueryNode notQuery = new NotQueryNode(parent);
        node.childrenAccept(this, notQuery);
        parent.addOperand(notQuery);
        return parent;
    }

    public Object visit(ASTBracketExpression node, Object data) {
        return node.childrenAccept(this, data);
    }

    public Object visit(ASTLiteral node, Object data) {
        return data;
    }

    public Object visit(ASTIdentifier node, Object data) {
        return data;
    }

    public Object visit(ASTOrderByClause node, Object data) {
        QueryRootNode root = (QueryRootNode)data;
        OrderQueryNode order = new OrderQueryNode(root);
        root.setOrderNode(order);
        node.childrenAccept(this, order);
        return root;
    }

    public Object visit(ASTOrderSpec node, Object data) {
        OrderQueryNode order = (OrderQueryNode)data;
        final QName[] identifier = new QName[1];
        node.childrenAccept(new DefaultParserVisitor(){

            public Object visit(ASTIdentifier node, Object data) {
                identifier[0] = node.getName();
                return data;
            }
        }, data);
        OrderQueryNode.OrderSpec spec = new OrderQueryNode.OrderSpec(identifier[0], true);
        order.addOrderSpec(spec);
        node.childrenAccept(this, spec);
        return data;
    }

    public Object visit(ASTAscendingOrderSpec node, Object data) {
        return data;
    }

    public Object visit(ASTDescendingOrderSpec node, Object data) {
        OrderQueryNode.OrderSpec spec = (OrderQueryNode.OrderSpec)data;
        spec.setAscending(false);
        return data;
    }

    public Object visit(ASTContainsExpression node, Object data) {
        NAryQueryNode parent = (NAryQueryNode)data;
        try {
            Path relPath = null;
            if (node.getPropertyName() != null) {
                Path.PathBuilder builder = new Path.PathBuilder();
                builder.addLast(node.getPropertyName());
                relPath = builder.getPath();
            }
            parent.addOperand(new TextsearchQueryNode(parent, node.getQuery(), relPath, true));
        }
        catch (MalformedPathException e) {
            // empty catch block
        }
        return parent;
    }

    public Object visit(ASTLowerFunction node, Object data) {
        RelationQueryNode parent = (RelationQueryNode)data;
        if (parent.getValueType() != 3) {
            String msg = "LOWER() function is only supported for String literal";
            throw new IllegalArgumentException(msg);
        }
        parent.addOperand(new PropertyFunctionQueryNode(parent, "lower-case"));
        return parent;
    }

    public Object visit(ASTUpperFunction node, Object data) {
        RelationQueryNode parent = (RelationQueryNode)data;
        if (parent.getValueType() != 3) {
            String msg = "UPPER() function is only supported for String literal";
            throw new IllegalArgumentException(msg);
        }
        parent.addOperand(new PropertyFunctionQueryNode(parent, "upper-case"));
        return parent;
    }

    private RelationQueryNode createRelationQueryNode(QueryNode parent, QName propertyName, int operationType, ASTLiteral literal) throws IllegalArgumentException {
        String stringValue = literal.getValue();
        RelationQueryNode node = null;
        try {
            Path.PathBuilder builder = new Path.PathBuilder();
            builder.addLast(propertyName);
            Path relPath = builder.getPath();
            if (literal.getType() == 4) {
                SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN);
                Date date = format.parse(stringValue);
                node = new RelationQueryNode(parent, relPath, date, operationType);
            } else if (literal.getType() == 2) {
                double d = Double.parseDouble(stringValue);
                node = new RelationQueryNode(parent, relPath, d, operationType);
            } else if (literal.getType() == 1) {
                long l = Long.parseLong(stringValue);
                node = new RelationQueryNode(parent, relPath, l, operationType);
            } else if (literal.getType() == 3) {
                node = new RelationQueryNode(parent, relPath, stringValue, operationType);
            } else if (literal.getType() == 5) {
                Calendar c = ISO8601.parse((String)stringValue);
                node = new RelationQueryNode(parent, relPath, c.getTime(), operationType);
            }
        }
        catch (java.text.ParseException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (MalformedPathException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (node == null) {
            throw new IllegalArgumentException("Unknown type for literal: " + literal.getType());
        }
        return node;
    }

    private void createPathQuery(String path, int operation) {
        MergingPathQueryNode pathNode = new MergingPathQueryNode(operation);
        pathNode.setAbsolute(true);
        if (path.equals("/")) {
            pathNode.addPathStep(new LocationStepQueryNode(pathNode));
            this.pathConstraints.add(pathNode);
            return;
        }
        String[] names = path.split("/");
        for (int i = 0; i < names.length; ++i) {
            String name;
            if (names[i].length() == 0) {
                if (i == 0) {
                    pathNode.addPathStep(new LocationStepQueryNode(pathNode));
                    continue;
                }
                pathNode.addPathStep(new LocationStepQueryNode(pathNode));
                continue;
            }
            int idx = names[i].indexOf(91);
            int index = -2147483647;
            if (idx > -1) {
                name = names[i].substring(0, idx);
                String suffix = names[i].substring(idx);
                String indexStr = suffix.substring(1, suffix.length() - 1);
                if (indexStr.equals("%")) {
                    index = -2147483647;
                } else {
                    try {
                        index = Integer.parseInt(indexStr);
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to parse index for path element: " + names[i]);
                    }
                }
                if (name.equals("%")) {
                    name = null;
                }
            } else {
                name = names[i];
                if (name.equals("%")) {
                    name = null;
                } else {
                    index = 1;
                }
            }
            QName qName = null;
            if (name != null) {
                try {
                    qName = NameFormat.parse((String)name, (NamespaceResolver)this.resolver);
                }
                catch (IllegalNameException e) {
                    throw new IllegalArgumentException("Illegal name: " + name);
                }
                catch (UnknownPrefixException e) {
                    throw new IllegalArgumentException("Unknown prefix: " + name);
                }
            }
            boolean descendant = name == null;
            LocationStepQueryNode step = new LocationStepQueryNode(pathNode, qName, descendant);
            if (index > 0) {
                step.setIndex(index);
            }
            pathNode.addPathStep(step);
        }
        this.pathConstraints.add(pathNode);
    }

    private static String translateEscaping(String pattern, char from, char to) {
        if (from == to || pattern.indexOf(from) < 0 && pattern.indexOf(to) < 0) {
            return pattern;
        }
        StringBuffer translated = new StringBuffer(pattern.length());
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            if (pattern.charAt(i) == from) {
                if (escaped) {
                    translated.append(from);
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (pattern.charAt(i) == to) {
                if (escaped) {
                    translated.append(to).append(to);
                    escaped = false;
                    continue;
                }
                translated.append(to).append(to);
                continue;
            }
            if (escaped) {
                translated.append(to);
                escaped = false;
            }
            translated.append(pattern.charAt(i));
        }
        return translated.toString();
    }

    private static class MergingPathQueryNode
    extends PathQueryNode {
        private int operation;

        MergingPathQueryNode(int operation) {
            super(null);
            if (operation != 8 && operation != 7 && operation != 9) {
                throw new IllegalArgumentException("operation");
            }
            this.operation = operation;
        }

        MergingPathQueryNode[] doMerge(MergingPathQueryNode[] nodes) {
            if (this.operation == 8) {
                return this.doOrMerge(nodes);
            }
            return this.doAndMerge(nodes);
        }

        private MergingPathQueryNode[] doAndMerge(MergingPathQueryNode[] nodes) {
            if (this.operation == 7) {
                MergingPathQueryNode n = null;
                for (int i = 0; i < nodes.length; ++i) {
                    if (nodes[i].operation != 9) continue;
                    n = nodes[i];
                    nodes[i] = this;
                }
                if (n == null) {
                    throw new NoSuchElementException("Merging not possible with any node");
                }
                return super.doAndMerge(nodes);
            }
            if (this.operands.size() < 3) {
                throw new NoSuchElementException("Merging not possible");
            }
            int size = this.operands.size();
            LocationStepQueryNode n1 = (LocationStepQueryNode)this.operands.get(size - 1);
            LocationStepQueryNode n2 = (LocationStepQueryNode)this.operands.get(size - 2);
            if (n1.getNameTest() != null || n2.getNameTest() != null || !n1.getIncludeDescendants() || !n2.getIncludeDescendants()) {
                throw new NoSuchElementException("Merging not possible");
            }
            MergingPathQueryNode matchedNode = null;
            for (int i = 0; i < nodes.length; ++i) {
                boolean bl;
                if (nodes[i].operands.size() != this.operands.size() - 1) continue;
                boolean match = true;
                for (int j = 0; j < this.operands.size() - 1 && match; match &= bl, ++j) {
                    LocationStepQueryNode step = (LocationStepQueryNode)this.operands.get(j);
                    LocationStepQueryNode other = (LocationStepQueryNode)nodes[i].operands.get(j);
                    if (step.getNameTest() == null) {
                        if (other.getNameTest() == null) {
                            bl = true;
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    bl = step.getNameTest().equals((Object)other.getNameTest());
                }
                if (!match) continue;
                matchedNode = nodes[i];
                break;
            }
            if (matchedNode == null) {
                throw new NoSuchElementException("Merging not possible with any node");
            }
            ((LocationStepQueryNode)matchedNode.operands.get(matchedNode.operands.size() - 1)).setIncludeDescendants(false);
            return nodes;
        }

        private MergingPathQueryNode[] doOrMerge(MergingPathQueryNode[] nodes) {
            MergingPathQueryNode compacted = new MergingPathQueryNode(8);
            Iterator it = this.operands.iterator();
            while (it.hasNext()) {
                LocationStepQueryNode step = (LocationStepQueryNode)it.next();
                if (step.getIncludeDescendants() && step.getNameTest() == null) {
                    if (it.hasNext()) {
                        LocationStepQueryNode next = (LocationStepQueryNode)it.next();
                        next.setIncludeDescendants(true);
                        compacted.addPathStep(next);
                        continue;
                    }
                    compacted.addPathStep(step);
                    continue;
                }
                compacted.addPathStep(step);
            }
            MergingPathQueryNode matchedNode = null;
            for (int i = 0; i < nodes.length; ++i) {
                boolean match;
                boolean bl;
                if (nodes[i].operands.size() != compacted.operands.size()) continue;
                Iterator compactedSteps = compacted.operands.iterator();
                Iterator otherSteps = nodes[i].operands.iterator();
                for (match = true; match && compactedSteps.hasNext(); match &= bl) {
                    LocationStepQueryNode n1 = (LocationStepQueryNode)compactedSteps.next();
                    LocationStepQueryNode n2 = (LocationStepQueryNode)otherSteps.next();
                    if (n1.getNameTest() == null) {
                        if (n2.getNameTest() == null) {
                            bl = true;
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    bl = n1.getNameTest().equals((Object)n2.getNameTest());
                }
                if (!match) continue;
                matchedNode = nodes[i];
                break;
            }
            if (matchedNode == null) {
                throw new NoSuchElementException("Merging not possible with any node.");
            }
            ArrayList<MergingPathQueryNode> mergedList = new ArrayList<MergingPathQueryNode>(Arrays.asList(nodes));
            mergedList.remove(matchedNode);
            mergedList.add(compacted);
            return mergedList.toArray(new MergingPathQueryNode[mergedList.size()]);
        }

        boolean needsMerge() {
            Iterator it = this.operands.iterator();
            while (it.hasNext()) {
                LocationStepQueryNode step = (LocationStepQueryNode)it.next();
                if (!step.getIncludeDescendants() || step.getNameTest() != null) continue;
                return true;
            }
            return false;
        }
    }
}

