/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.AndQueryNode;
import org.apache.jackrabbit.core.query.DefaultQueryNodeVisitor;
import org.apache.jackrabbit.core.query.DerefQueryNode;
import org.apache.jackrabbit.core.query.ExactQueryNode;
import org.apache.jackrabbit.core.query.LocationStepQueryNode;
import org.apache.jackrabbit.core.query.NodeTypeQueryNode;
import org.apache.jackrabbit.core.query.NotQueryNode;
import org.apache.jackrabbit.core.query.OrQueryNode;
import org.apache.jackrabbit.core.query.OrderQueryNode;
import org.apache.jackrabbit.core.query.PathQueryNode;
import org.apache.jackrabbit.core.query.PropertyFunctionQueryNode;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.QueryNode;
import org.apache.jackrabbit.core.query.QueryNodeVisitor;
import org.apache.jackrabbit.core.query.QueryRootNode;
import org.apache.jackrabbit.core.query.RelationQueryNode;
import org.apache.jackrabbit.core.query.TextsearchQueryNode;
import org.apache.jackrabbit.core.query.lucene.CaseTermQuery;
import org.apache.jackrabbit.core.query.lucene.ChildAxisQuery;
import org.apache.jackrabbit.core.query.lucene.DateField;
import org.apache.jackrabbit.core.query.lucene.DerefQuery;
import org.apache.jackrabbit.core.query.lucene.DescendantSelfAxisQuery;
import org.apache.jackrabbit.core.query.lucene.DoubleField;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.LongField;
import org.apache.jackrabbit.core.query.lucene.MatchAllQuery;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.NotQuery;
import org.apache.jackrabbit.core.query.lucene.ParentAxisQuery;
import org.apache.jackrabbit.core.query.lucene.RangeQuery;
import org.apache.jackrabbit.core.query.lucene.WildcardQuery;
import org.apache.jackrabbit.core.query.lucene.fulltext.ParseException;
import org.apache.jackrabbit.core.query.lucene.fulltext.QueryParser;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.name.IllegalNameException;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NameFormat;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathFormat;
import org.apache.jackrabbit.name.QName;
import org.apache.jackrabbit.name.UnknownPrefixException;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.XMLChar;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneQueryBuilder
implements QueryNodeVisitor {
    private static final Logger log = LoggerFactory.getLogger((Class)LuceneQueryBuilder.class);
    private QueryRootNode root;
    private SessionImpl session;
    private ItemStateManager sharedItemMgr;
    private NamespaceMappings nsMappings;
    private Analyzer analyzer;
    private PropertyTypeRegistry propRegistry;
    private List exceptions = new ArrayList();

    private LuceneQueryBuilder(QueryRootNode root, SessionImpl session, ItemStateManager sharedItemMgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg) {
        this.root = root;
        this.session = session;
        this.sharedItemMgr = sharedItemMgr;
        this.nsMappings = nsMappings;
        this.analyzer = analyzer;
        this.propRegistry = propReg;
    }

    public static Query createQuery(QueryRootNode root, SessionImpl session, ItemStateManager sharedItemMgr, NamespaceMappings nsMappings, Analyzer analyzer, PropertyTypeRegistry propReg) throws RepositoryException {
        LuceneQueryBuilder builder = new LuceneQueryBuilder(root, session, sharedItemMgr, nsMappings, analyzer, propReg);
        Query q = builder.createLuceneQuery();
        if (builder.exceptions.size() > 0) {
            StringBuffer msg = new StringBuffer();
            Iterator it = builder.exceptions.iterator();
            while (it.hasNext()) {
                msg.append(it.next().toString()).append('\n');
            }
            throw new RepositoryException("Exception building query: " + msg.toString());
        }
        return q;
    }

    private Query createLuceneQuery() {
        return (Query)this.root.accept(this, null);
    }

    public Object visit(QueryRootNode node, Object data) {
        BooleanQuery root;
        BooleanQuery wrapped = root = new BooleanQuery();
        if (node.getLocationNode() != null) {
            wrapped = (Query)node.getLocationNode().accept(this, root);
        }
        return wrapped;
    }

    public Object visit(OrQueryNode node, Object data) {
        BooleanQuery orQuery = new BooleanQuery();
        Object[] result = node.acceptOperands(this, null);
        for (int i = 0; i < result.length; ++i) {
            Query operand = (Query)result[i];
            orQuery.add(operand, BooleanClause.Occur.SHOULD);
        }
        return orQuery;
    }

    public Object visit(AndQueryNode node, Object data) {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return null;
        }
        BooleanQuery andQuery = new BooleanQuery();
        for (int i = 0; i < result.length; ++i) {
            Query operand = (Query)result[i];
            andQuery.add(operand, BooleanClause.Occur.MUST);
        }
        return andQuery;
    }

    public Object visit(NotQueryNode node, Object data) {
        Object[] result = node.acceptOperands(this, null);
        if (result.length == 0) {
            return data;
        }
        BooleanQuery b = new BooleanQuery();
        for (int i = 0; i < result.length; ++i) {
            b.add((Query)result[i], BooleanClause.Occur.SHOULD);
        }
        return new NotQuery((Query)b);
    }

    public Object visit(ExactQueryNode node, Object data) {
        String field = "";
        String value = "";
        try {
            field = NameFormat.format((QName)node.getPropertyName(), (NamespaceResolver)this.nsMappings);
            value = NameFormat.format((QName)node.getValue(), (NamespaceResolver)this.nsMappings);
        }
        catch (NoPrefixDeclaredException e) {
            // empty catch block
        }
        return new TermQuery(new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, value)));
    }

    public Object visit(NodeTypeQueryNode node, Object data) {
        ArrayList<Term> terms = new ArrayList<Term>();
        try {
            Term t;
            String mixinTypesField = NameFormat.format((QName)QName.JCR_MIXINTYPES, (NamespaceResolver)this.nsMappings);
            String primaryTypeField = NameFormat.format((QName)QName.JCR_PRIMARYTYPE, (NamespaceResolver)this.nsMappings);
            NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
            NodeType base = ntMgr.getNodeType(NameFormat.format((QName)node.getValue(), (NamespaceResolver)this.session.getNamespaceResolver()));
            if (base.isMixin()) {
                t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, NameFormat.format((QName)node.getValue(), (NamespaceResolver)this.nsMappings)));
                terms.add(t);
            } else {
                t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, NameFormat.format((QName)node.getValue(), (NamespaceResolver)this.nsMappings)));
                terms.add(t);
            }
            NodeTypeIterator allTypes = ntMgr.getAllNodeTypes();
            while (allTypes.hasNext()) {
                NodeType nt = allTypes.nextNodeType();
                NodeType[] superTypes = nt.getSupertypes();
                if (!Arrays.asList(superTypes).contains(base)) continue;
                String ntName = this.nsMappings.translatePropertyName(nt.getName(), this.session.getNamespaceResolver());
                Term t2 = nt.isMixin() ? new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, ntName)) : new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, ntName));
                terms.add(t2);
            }
        }
        catch (IllegalNameException e) {
            this.exceptions.add(e);
        }
        catch (UnknownPrefixException e) {
            this.exceptions.add(e);
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        catch (RepositoryException e) {
            this.exceptions.add(e);
        }
        if (terms.size() == 0) {
            return new BooleanQuery();
        }
        if (terms.size() == 1) {
            return new TermQuery((Term)terms.get(0));
        }
        BooleanQuery b = new BooleanQuery();
        Iterator it = terms.iterator();
        while (it.hasNext()) {
            b.add((Query)new TermQuery((Term)it.next()), BooleanClause.Occur.SHOULD);
        }
        return b;
    }

    public Object visit(TextsearchQueryNode node, Object data) {
        try {
            String fieldname;
            Path relPath = node.getRelativePath();
            if (relPath == null || !node.getReferencesProperty()) {
                fieldname = FieldNames.FULLTEXT;
            } else {
                QName propName = relPath.getNameElement().getName();
                StringBuffer tmp = new StringBuffer();
                tmp.append(this.nsMappings.getPrefix(propName.getNamespaceURI()));
                tmp.append(":").append("FULL:");
                tmp.append(propName.getLocalName());
                fieldname = tmp.toString();
            }
            QueryParser parser = new QueryParser(fieldname, this.analyzer);
            parser.setOperator(1);
            StringBuffer query = new StringBuffer();
            String textsearch = node.getQuery();
            textsearch = textsearch.replaceAll("AND", "and");
            textsearch = textsearch.replaceAll("NOT", "not");
            boolean escaped = false;
            for (int i = 0; i < textsearch.length(); ++i) {
                if (textsearch.charAt(i) == '\\') {
                    if (escaped) {
                        query.append("\\\\");
                        escaped = false;
                        continue;
                    }
                    escaped = true;
                    continue;
                }
                if (textsearch.charAt(i) == '\'') {
                    if (escaped) {
                        query.append('\'');
                        escaped = false;
                        continue;
                    }
                    query.append('\"');
                    continue;
                }
                if (escaped) {
                    query.append('\\');
                    escaped = false;
                }
                query.append(textsearch.charAt(i));
            }
            Query context = parser.parse(query.toString());
            if (!(relPath == null || node.getReferencesProperty() && relPath.getLength() <= 1)) {
                Path.PathElement[] elements = relPath.getElements();
                for (int i = elements.length - 1; i >= 0; --i) {
                    String name = null;
                    if (!elements[i].getName().equals((Object)RelationQueryNode.STAR_NAME_TEST)) {
                        name = NameFormat.format((QName)elements[i].getName(), (NamespaceResolver)this.nsMappings);
                    }
                    if (name != null && (node.getReferencesProperty() && i == elements.length - 2 || !node.getReferencesProperty() && i == elements.length - 1)) {
                        TermQuery q = new TermQuery(new Term(FieldNames.LABEL, name));
                        BooleanQuery and = new BooleanQuery();
                        and.add((Query)q, BooleanClause.Occur.MUST);
                        and.add(context, BooleanClause.Occur.MUST);
                        context = and;
                        continue;
                    }
                    if ((!node.getReferencesProperty() || i >= elements.length - 2) && (node.getReferencesProperty() || i >= elements.length - 1)) continue;
                    context = new ParentAxisQuery(context, name);
                }
                context = new ParentAxisQuery(context, null);
            }
            return context;
        }
        catch (NamespaceException e) {
            this.exceptions.add(e);
        }
        catch (ParseException e) {
            this.exceptions.add(e);
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        return null;
    }

    public Object visit(PathQueryNode node, Object data) {
        BooleanQuery constraint;
        TermQuery context = null;
        LocationStepQueryNode[] steps = node.getPathSteps();
        if (steps.length > 0) {
            if (node.isAbsolute() && !steps[0].getIncludeDescendants()) {
                QName nameTest = steps[0].getNameTest();
                if (nameTest == null) {
                    context = new TermQuery(new Term(FieldNames.PARENT, ""));
                } else if (nameTest.getLocalName().length() == 0) {
                    context = new TermQuery(new Term(FieldNames.PARENT, ""));
                } else {
                    String name = "";
                    try {
                        name = NameFormat.format((QName)nameTest, (NamespaceResolver)this.nsMappings);
                    }
                    catch (NoPrefixDeclaredException e) {
                        this.exceptions.add(e);
                    }
                    BooleanQuery and = new BooleanQuery();
                    and.add((Query)new TermQuery(new Term(FieldNames.PARENT, "")), BooleanClause.Occur.MUST);
                    and.add((Query)new TermQuery(new Term(FieldNames.LABEL, name)), BooleanClause.Occur.MUST);
                    context = and;
                }
                LocationStepQueryNode[] tmp = new LocationStepQueryNode[steps.length - 1];
                System.arraycopy(steps, 1, tmp, 0, steps.length - 1);
                steps = tmp;
            } else {
                context = new TermQuery(new Term(FieldNames.PARENT, ""));
            }
        } else {
            this.exceptions.add(new InvalidQueryException("Number of location steps must be > 0"));
        }
        for (int i = 0; i < steps.length; ++i) {
            context = (Query)steps[i].accept(this, context);
        }
        if (data instanceof BooleanQuery && (constraint = (BooleanQuery)data).getClauses().length > 0) {
            constraint.add((Query)context, BooleanClause.Occur.MUST);
            context = constraint;
        }
        return context;
    }

    public Object visit(LocationStepQueryNode node, Object data) {
        Query context = (Query)data;
        BooleanQuery andQuery = new BooleanQuery();
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        Object[] predicates = node.acceptOperands(this, data);
        for (int i = 0; i < predicates.length; ++i) {
            andQuery.add((Query)predicates[i], BooleanClause.Occur.MUST);
        }
        QueryNode[] pred = node.getPredicates();
        for (int i = 0; i < pred.length; ++i) {
            RelationQueryNode pos;
            if (pred[i].getType() != 2 || (pos = (RelationQueryNode)pred[i]).getValueType() != 6) continue;
            node.setIndex(pos.getPositionValue());
        }
        TermQuery nameTest = null;
        if (node.getNameTest() != null) {
            try {
                String internalName = NameFormat.format((QName)node.getNameTest(), (NamespaceResolver)this.nsMappings);
                nameTest = new TermQuery(new Term(FieldNames.LABEL, internalName));
            }
            catch (NoPrefixDeclaredException e) {
                this.exceptions.add(e);
            }
        }
        if (node.getIncludeDescendants()) {
            if (nameTest != null) {
                andQuery.add((Query)new DescendantSelfAxisQuery(context, (Query)nameTest), BooleanClause.Occur.MUST);
            } else if (predicates.length > 0) {
                PathQueryNode pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    DescendantSelfAxisQuery subQuery = new DescendantSelfAxisQuery(context, (Query)andQuery, false);
                    andQuery = new BooleanQuery();
                    andQuery.add((Query)subQuery, BooleanClause.Occur.MUST);
                }
            } else {
                MatchAllQuery subQuery = null;
                try {
                    subQuery = new MatchAllQuery(NameFormat.format((QName)QName.JCR_PRIMARYTYPE, (NamespaceResolver)this.nsMappings));
                }
                catch (NoPrefixDeclaredException e) {
                    // empty catch block
                }
                PathQueryNode pathNode = (PathQueryNode)node.getParent();
                if (pathNode.getPathSteps()[0] != node) {
                    context = new DescendantSelfAxisQuery(context, subQuery);
                    andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex()), BooleanClause.Occur.MUST);
                } else {
                    andQuery.add((Query)subQuery, BooleanClause.Occur.MUST);
                }
            }
        } else if (nameTest != null) {
            andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, nameTest.getTerm().text(), node.getIndex()), BooleanClause.Occur.MUST);
        } else {
            andQuery.add((Query)new ChildAxisQuery(this.sharedItemMgr, context, null, node.getIndex()), BooleanClause.Occur.MUST);
        }
        return andQuery;
    }

    public Object visit(DerefQueryNode node, Object data) {
        Query context = (Query)data;
        if (context == null) {
            this.exceptions.add(new IllegalArgumentException("Unsupported query"));
        }
        try {
            String refProperty = NameFormat.format((QName)node.getRefProperty(), (NamespaceResolver)this.nsMappings);
            String nameTest = null;
            if (node.getNameTest() != null) {
                nameTest = NameFormat.format((QName)node.getNameTest(), (NamespaceResolver)this.nsMappings);
            }
            if (node.getIncludeDescendants()) {
                MatchAllQuery refPropQuery = new MatchAllQuery(refProperty);
                context = new DescendantSelfAxisQuery(context, refPropQuery, false);
            }
            context = new DerefQuery(context, refProperty, nameTest);
            Object[] predicates = node.acceptOperands(this, data);
            if (predicates.length > 0) {
                BooleanQuery andQuery = new BooleanQuery();
                for (int i = 0; i < predicates.length; ++i) {
                    andQuery.add((Query)predicates[i], BooleanClause.Occur.MUST);
                }
                andQuery.add(context, BooleanClause.Occur.MUST);
                context = andQuery;
            }
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        return context;
    }

    public Object visit(RelationQueryNode node, Object data) {
        Query query;
        String[] stringValues = new String[1];
        switch (node.getValueType()) {
            case 0: {
                break;
            }
            case 4: {
                stringValues[0] = DateField.dateToString(node.getDateValue());
                break;
            }
            case 2: {
                stringValues[0] = DoubleField.doubleToString(node.getDoubleValue());
                break;
            }
            case 1: {
                stringValues[0] = LongField.longToString(node.getLongValue());
                break;
            }
            case 3: {
                if (node.getOperation() == 12 || node.getOperation() == 11 || node.getOperation() == 14 || node.getOperation() == 13) {
                    QName propertyName = node.getRelativePath().getNameElement().getName();
                    stringValues = this.getStringValues(propertyName, node.getStringValue());
                    break;
                }
                stringValues[0] = node.getStringValue();
                break;
            }
            case 6: {
                return null;
            }
            default: {
                throw new IllegalArgumentException("Unknown relation type: " + node.getValueType());
            }
        }
        if (node.getRelativePath() == null) {
            this.exceptions.add(new InvalidQueryException("@* not supported in predicate"));
            return data;
        }
        final int[] transform = new int[]{0};
        node.acceptOperands(new DefaultQueryNodeVisitor(){

            public Object visit(PropertyFunctionQueryNode node, Object data) {
                if (node.getFunctionName().equals("lower-case")) {
                    transform[0] = 1;
                } else if (node.getFunctionName().equals("upper-case")) {
                    transform[0] = 2;
                }
                return data;
            }
        }, null);
        Path relPath = node.getRelativePath();
        String field = "";
        try {
            field = NameFormat.format((QName)relPath.getNameElement().getName(), (NamespaceResolver)this.nsMappings);
        }
        catch (NoPrefixDeclaredException e) {
            this.exceptions.add(e);
        }
        switch (node.getOperation()) {
            case 11: 
            case 12: {
                BooleanQuery or = new BooleanQuery();
                for (int i = 0; i < stringValues.length; ++i) {
                    Term t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    CaseTermQuery q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new TermQuery(t));
                    or.add((Query)q, BooleanClause.Occur.SHOULD);
                }
                query = or;
                if (node.getOperation() != 11) break;
                query = this.createSingleValueConstraint((Query)or, field);
                break;
            }
            case 19: 
            case 20: {
                Term upper;
                BooleanQuery or = new BooleanQuery();
                for (int i = 0; i < stringValues.length; ++i) {
                    Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                    or.add((Query)new RangeQuery(lower, upper, true, transform[0]), BooleanClause.Occur.SHOULD);
                }
                query = or;
                if (node.getOperation() != 19) break;
                query = this.createSingleValueConstraint((Query)or, field);
                break;
            }
            case 17: 
            case 18: {
                Term upper;
                BooleanQuery or = new BooleanQuery();
                for (int i = 0; i < stringValues.length; ++i) {
                    Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, "\uffff"));
                    or.add((Query)new RangeQuery(lower, upper, false, transform[0]), BooleanClause.Occur.SHOULD);
                }
                query = or;
                if (node.getOperation() != 17) break;
                query = this.createSingleValueConstraint((Query)or, field);
                break;
            }
            case 21: 
            case 22: {
                Term upper;
                BooleanQuery or = new BooleanQuery();
                for (int i = 0; i < stringValues.length; ++i) {
                    Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                    upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    or.add((Query)new RangeQuery(lower, upper, true, transform[0]), BooleanClause.Occur.SHOULD);
                }
                query = or;
                if (node.getOperation() != 21) break;
                query = this.createSingleValueConstraint(query, field);
                break;
            }
            case 23: {
                if (stringValues[0].equals("%")) {
                    query = new MatchAllQuery(field);
                    break;
                }
                query = new WildcardQuery(FieldNames.PROPERTIES, field, stringValues[0], transform[0]);
                break;
            }
            case 15: 
            case 16: {
                Term upper;
                BooleanQuery or = new BooleanQuery();
                for (int i = 0; i < stringValues.length; ++i) {
                    Term lower = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, ""));
                    upper = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    or.add((Query)new RangeQuery(lower, upper, false, transform[0]), BooleanClause.Occur.SHOULD);
                }
                query = or;
                if (node.getOperation() != 15) break;
                query = this.createSingleValueConstraint((Query)or, field);
                break;
            }
            case 13: {
                Term t;
                BooleanQuery notQuery = new BooleanQuery();
                notQuery.add((Query)new MatchAllQuery(field), BooleanClause.Occur.SHOULD);
                for (int i = 0; i < stringValues.length; ++i) {
                    t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    CaseTermQuery q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new TermQuery(t));
                    notQuery.add((Query)q, BooleanClause.Occur.MUST_NOT);
                }
                notQuery.add((Query)new TermQuery(new Term(FieldNames.MVP, field)), BooleanClause.Occur.MUST_NOT);
                query = notQuery;
                break;
            }
            case 14: {
                Term t;
                BooleanQuery notQuery = new BooleanQuery();
                notQuery.add((Query)new MatchAllQuery(field), BooleanClause.Occur.SHOULD);
                for (int i = 0; i < stringValues.length; ++i) {
                    t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(field, stringValues[i]));
                    NotQuery svp = new NotQuery((Query)new TermQuery(new Term(FieldNames.MVP, field)));
                    BooleanQuery and = new BooleanQuery();
                    CaseTermQuery q = transform[0] == 2 ? new CaseTermQuery.Upper(t) : (transform[0] == 1 ? new CaseTermQuery.Lower(t) : new TermQuery(t));
                    and.add((Query)q, BooleanClause.Occur.MUST);
                    and.add((Query)svp, BooleanClause.Occur.MUST);
                    notQuery.add((Query)and, BooleanClause.Occur.MUST_NOT);
                }
                query = notQuery;
                break;
            }
            case 26: {
                query = new NotQuery(new MatchAllQuery(field));
                break;
            }
            case 27: {
                query = new MatchAllQuery(field);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown relation operation: " + node.getOperation());
            }
        }
        if (relPath.getLength() > 1) {
            try {
                Path.PathElement[] elements = relPath.getElements();
                for (int i = elements.length - 2; i >= 0; --i) {
                    String name = null;
                    if (!elements[i].getName().equals((Object)RelationQueryNode.STAR_NAME_TEST)) {
                        name = NameFormat.format((QName)elements[i].getName(), (NamespaceResolver)this.nsMappings);
                    }
                    if (i == elements.length - 2) {
                        if (name == null) continue;
                        TermQuery nameTest = new TermQuery(new Term(FieldNames.LABEL, name));
                        BooleanQuery and = new BooleanQuery();
                        and.add(query, BooleanClause.Occur.MUST);
                        and.add((Query)nameTest, BooleanClause.Occur.MUST);
                        query = and;
                        continue;
                    }
                    query = new ParentAxisQuery(query, name);
                }
            }
            catch (NoPrefixDeclaredException e) {
                this.exceptions.add(e);
            }
            query = new ParentAxisQuery(query, null);
        }
        return query;
    }

    public Object visit(OrderQueryNode node, Object data) {
        return data;
    }

    public Object visit(PropertyFunctionQueryNode node, Object data) {
        return data;
    }

    private Query createSingleValueConstraint(Query q, String propName) {
        TermQuery mvp = new TermQuery(new Term(FieldNames.MVP, propName));
        NotQuery svp = new NotQuery((Query)mvp);
        BooleanQuery and = new BooleanQuery();
        and.add(q, BooleanClause.Occur.MUST);
        and.add((Query)svp, BooleanClause.Occur.MUST);
        return and;
    }

    private String[] getStringValues(QName propertyName, String literal) {
        PropertyTypeRegistry.TypeMapping[] types = this.propRegistry.getPropertyTypes(propertyName);
        ArrayList<String> values = new ArrayList<String>();
        block26: for (int i = 0; i < types.length; ++i) {
            switch (types[i].type) {
                case 7: {
                    try {
                        values.add(this.nsMappings.translatePropertyName(literal, this.session.getNamespaceResolver()));
                        log.debug("Coerced " + literal + " into NAME.");
                    }
                    catch (IllegalNameException e) {
                        log.warn("Unable to coerce '" + literal + "' into a NAME: " + e.toString());
                    }
                    catch (UnknownPrefixException e) {
                        log.warn("Unable to coerce '" + literal + "' into a NAME: " + e.toString());
                    }
                    continue block26;
                }
                case 8: {
                    try {
                        Path p = PathFormat.parse((String)literal, (NamespaceResolver)this.session.getNamespaceResolver());
                        values.add(PathFormat.format((Path)p, (NamespaceResolver)this.nsMappings));
                        log.debug("Coerced " + literal + " into PATH.");
                    }
                    catch (MalformedPathException e) {
                        log.warn("Unable to coerce '" + literal + "' into a PATH: " + e.toString());
                    }
                    catch (NoPrefixDeclaredException e) {
                        log.warn("Unable to coerce '" + literal + "' into a PATH: " + e.toString());
                    }
                    continue block26;
                }
                case 5: {
                    Calendar c = ISO8601.parse((String)literal);
                    if (c != null) {
                        values.add(DateField.timeToString(c.getTimeInMillis()));
                        log.debug("Coerced " + literal + " into DATE.");
                        continue block26;
                    }
                    log.warn("Unable to coerce '" + literal + "' into a DATE.");
                    continue block26;
                }
                case 4: {
                    try {
                        double d = Double.parseDouble(literal);
                        values.add(DoubleField.doubleToString(d));
                        log.debug("Coerced " + literal + " into DOUBLE.");
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to coerce '" + literal + "' into a DOUBLE: " + e.toString());
                    }
                    continue block26;
                }
                case 3: {
                    try {
                        long l = Long.parseLong(literal);
                        values.add(LongField.longToString(l));
                        log.debug("Coerced " + literal + " into LONG.");
                    }
                    catch (NumberFormatException e) {
                        log.warn("Unable to coerce '" + literal + "' into a LONG: " + e.toString());
                    }
                    continue block26;
                }
                case 1: {
                    values.add(literal);
                    log.debug("Using literal " + literal + " as is.");
                }
            }
        }
        if (values.size() == 0) {
            values.add(literal);
            if (literal.indexOf(47) > -1) {
                try {
                    values.add(PathFormat.format((Path)PathFormat.parse((String)literal, (NamespaceResolver)this.session.getNamespaceResolver()), (NamespaceResolver)this.nsMappings));
                    log.debug("Coerced " + literal + " into PATH.");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (XMLChar.isValidName((String)literal)) {
                try {
                    values.add(this.nsMappings.translatePropertyName(literal, this.session.getNamespaceResolver()));
                    log.debug("Coerced " + literal + " into NAME.");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (literal.indexOf(58) > -1) {
                Calendar c = ISO8601.parse((String)literal);
                if (c != null) {
                    values.add(DateField.timeToString(c.getTimeInMillis()));
                    log.debug("Coerced " + literal + " into DATE.");
                }
            } else {
                try {
                    values.add(LongField.longToString(Long.parseLong(literal)));
                    log.debug("Coerced " + literal + " into LONG.");
                }
                catch (NumberFormatException e) {
                    try {
                        values.add(DoubleField.doubleToString(Double.parseDouble(literal)));
                        log.debug("Coerced " + literal + " into DOUBLE.");
                    }
                    catch (NumberFormatException e1) {
                        // empty catch block
                    }
                }
            }
        }
        if (values.size() == 0) {
            values.add(literal);
            log.debug("Using literal " + literal + " as is.");
        }
        return values.toArray(new String[values.size()]);
    }
}

