/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.name.MalformedPathException;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathFormat;

class PathConstraint
extends ValueConstraint {
    final Path path;
    final boolean deep;

    PathConstraint(String definition, NamespaceResolver nsResolver) throws InvalidConstraintException {
        super(definition);
        this.deep = definition.endsWith("*");
        if (this.deep) {
            definition = definition.substring(0, definition.length() - 1);
        }
        try {
            this.path = PathFormat.parse((String)definition, (NamespaceResolver)nsResolver);
        }
        catch (MalformedPathException mpe) {
            String msg = "invalid path expression specified as value constraint: " + definition;
            log.debug(msg);
            throw new InvalidConstraintException(msg, mpe);
        }
    }

    public String getDefinition(NamespaceResolver nsResolver) {
        try {
            String p = PathFormat.format((Path)this.path, (NamespaceResolver)nsResolver);
            if (!this.deep) {
                return p;
            }
            if (this.path.denotesRoot()) {
                return p + "*";
            }
            return p + "/*";
        }
        catch (NoPrefixDeclaredException npde) {
            return this.definition;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void check(InternalValue value) throws ConstraintViolationException, RepositoryException {
        if (value == null) {
            throw new ConstraintViolationException("null value does not satisfy the constraint '" + this.definition + "'");
        }
        switch (value.getType()) {
            case 8: {
                Path p1;
                Path p0;
                Path p = (Path)value.internalValue();
                try {
                    p0 = this.path.getNormalizedPath();
                    p1 = p.getNormalizedPath();
                }
                catch (MalformedPathException e) {
                    throw new ConstraintViolationException("path not valid: " + (Object)((Object)e));
                }
                if (this.deep) {
                    try {
                        if (p0.isAncestorOf(p1)) return;
                        throw new ConstraintViolationException(p + " does not satisfy the constraint '" + this.definition + "'");
                    }
                    catch (MalformedPathException mpe) {
                        throw new ConstraintViolationException(p + " does not satisfy the constraint '" + this.definition + "'");
                    }
                }
                if (p0.equals((Object)p1)) return;
                throw new ConstraintViolationException(p + " does not satisfy the constraint '" + this.definition + "'");
            }
        }
        String msg = "PATH constraint can not be applied to value of type: " + PropertyType.nameFromValue((int)value.getType());
        log.debug(msg);
        throw new RepositoryException(msg);
    }
}

