/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.lock;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import org.apache.jackrabbit.core.lock.AbstractLockInfo;

class LockImpl
implements Lock {
    protected final AbstractLockInfo info;
    protected final Node node;

    public LockImpl(AbstractLockInfo info, Node node) {
        this.info = info;
        this.node = node;
    }

    public String getLockOwner() {
        return this.info.lockOwner;
    }

    public boolean isDeep() {
        return this.info.deep;
    }

    public Node getNode() {
        return this.node;
    }

    public String getLockToken() {
        try {
            return this.info.getLockToken(this.node.getSession());
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public boolean isLive() throws RepositoryException {
        return this.info.isLive();
    }

    public boolean isSessionScoped() {
        return this.info.isSessionScoped();
    }

    public void refresh() throws LockException, RepositoryException {
        if (!this.isLive()) {
            throw new LockException("Lock is not live any more.");
        }
        if (this.getLockToken() == null) {
            throw new LockException("Session does not hold lock.");
        }
    }
}

