/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeIdIterator;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.SearchConfig;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.observation.EventImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.query.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.QueryImpl;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateIterator;
import org.apache.jackrabbit.name.NamespaceResolver;
import org.apache.jackrabbit.name.NoPrefixDeclaredException;
import org.apache.jackrabbit.name.Path;
import org.apache.jackrabbit.name.PathFormat;
import org.apache.jackrabbit.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchManager
implements SynchronousEventListener {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchManager.class);
    private static final String NS_FN_PREFIX = "fn";
    public static final String NS_FN_URI = "http://www.w3.org/2004/10/xpath-functions";
    private static final String NS_XS_PREFIX = "xs";
    public static final String NS_XS_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String PARAM_QUERY_IMPL = "queryClass";
    private static final String PARAM_IDLE_TIME = "idleTime";
    private static final String DEFAULT_QUERY_IMPL_CLASS = QueryImpl.class.getName();
    private static final Timer IDLE_TIMER = new Timer(true);
    private static final int DEFAULT_IDLE_TIME = -1;
    private long lastAccess = System.currentTimeMillis();
    private final SearchConfig config;
    private final NodeTypeRegistry ntReg;
    private final ItemStateManager itemMgr;
    private final FileSystem fs;
    private final NodeId rootNodeId;
    private QueryHandler handler;
    private final QueryHandler parentHandler;
    private final NamespaceRegistryImpl nsReg;
    private final NodeId excludedNodeId;
    private Path excludePath;
    private final String queryImplClassName;
    private final Timer.Task idleChecker;
    private int idleTime;
    private final Map activeQueries = Collections.synchronizedMap(new WeakHashMap(){});

    public SearchManager(SearchConfig config, NamespaceRegistryImpl nsReg, NodeTypeRegistry ntReg, ItemStateManager itemMgr, NodeId rootNodeId, SearchManager parentMgr, NodeId excludedNodeId) throws RepositoryException {
        this.fs = config.getFileSystemConfig() != null ? config.getFileSystemConfig().createFileSystem() : null;
        this.config = config;
        this.ntReg = ntReg;
        this.nsReg = nsReg;
        this.itemMgr = itemMgr;
        this.rootNodeId = rootNodeId;
        this.parentHandler = parentMgr != null ? parentMgr.handler : null;
        this.excludedNodeId = excludedNodeId;
        nsReg.safeRegisterNamespace(NS_XS_PREFIX, NS_XS_URI);
        nsReg.safeRegisterNamespace(NS_FN_PREFIX, NS_FN_URI);
        Properties params = config.getParameters();
        this.queryImplClassName = params.getProperty(PARAM_QUERY_IMPL, DEFAULT_QUERY_IMPL_CLASS);
        String idleTimeString = params.getProperty(PARAM_IDLE_TIME, String.valueOf(-1));
        try {
            this.idleTime = Integer.decode(idleTimeString);
        }
        catch (NumberFormatException e) {
            this.idleTime = -1;
        }
        if (excludedNodeId != null) {
            HierarchyManagerImpl hmgr = new HierarchyManagerImpl(rootNodeId, itemMgr, (NamespaceResolver)nsReg);
            this.excludePath = hmgr.getPath(excludedNodeId);
        }
        this.initializeQueryHandler();
        this.idleChecker = new Timer.Task(){

            public void run() {
                if (SearchManager.this.lastAccess + (long)(SearchManager.this.idleTime * 1000) < System.currentTimeMillis()) {
                    int inUse = SearchManager.this.activeQueries.size();
                    if (inUse == 0) {
                        try {
                            SearchManager.this.shutdownQueryHandler();
                        }
                        catch (IOException e) {
                            log.warn("Unable to shutdown idle query handler", (Throwable)e);
                        }
                    } else {
                        log.debug("SearchManager is idle but " + inUse + " queries are still in use.");
                    }
                }
            }
        };
        if (this.idleTime > -1) {
            IDLE_TIMER.schedule(this.idleChecker, 0L, 1000L);
        }
    }

    public void close() {
        try {
            this.idleChecker.cancel();
            this.shutdownQueryHandler();
            if (this.fs != null) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            log.error("Exception closing QueryHandler.", (Throwable)e);
        }
        catch (FileSystemException e) {
            log.error("Exception closing FileSystem.", (Throwable)((Object)e));
        }
    }

    public Query createQuery(SessionImpl session, ItemManager itemMgr, String statement, String language) throws InvalidQueryException, RepositoryException {
        this.ensureInitialized();
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, itemMgr, this.handler, statement, language);
        return query;
    }

    public Query createQuery(SessionImpl session, ItemManager itemMgr, Node node) throws InvalidQueryException, RepositoryException {
        this.ensureInitialized();
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, itemMgr, this.handler, node);
        return query;
    }

    public void onEvent(EventIterator events) {
        log.debug("onEvent: indexing started");
        long time = System.currentTimeMillis();
        String exclude = "";
        if (this.excludePath != null) {
            try {
                exclude = PathFormat.format((Path)this.excludePath, (NamespaceResolver)this.nsReg);
            }
            catch (NoPrefixDeclaredException e) {
                log.error("Error filtering events.", (Throwable)e);
            }
        }
        final HashSet<NodeId> removedNodes = new HashSet<NodeId>();
        final HashSet<NodeId> addedNodes = new HashSet<NodeId>();
        ArrayList<EventImpl> propEvents = new ArrayList<EventImpl>();
        while (events.hasNext()) {
            EventImpl e = (EventImpl)events.nextEvent();
            try {
                if (this.excludePath != null && e.getPath().startsWith(exclude)) {
                    continue;
                }
            }
            catch (RepositoryException ex) {
                log.error("Error filtering events.", (Throwable)ex);
            }
            long type = e.getType();
            if (type == 1L) {
                addedNodes.add(e.getChildId());
                continue;
            }
            if (type == 2L) {
                removedNodes.add(e.getChildId());
                continue;
            }
            propEvents.add(e);
        }
        for (int i = 0; i < propEvents.size(); ++i) {
            EventImpl event = (EventImpl)propEvents.get(i);
            NodeId nodeId = event.getParentId();
            if (event.getType() == 4) {
                if (!addedNodes.add(nodeId)) continue;
                removedNodes.add(nodeId);
                continue;
            }
            if (event.getType() == 16) {
                addedNodes.add(nodeId);
                removedNodes.add(nodeId);
                continue;
            }
            addedNodes.add(nodeId);
            removedNodes.add(nodeId);
        }
        NodeStateIterator addedStates = new NodeStateIterator(){
            private final Iterator iter;
            {
                this.iter = addedNodes.iterator();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.nextNodeState();
            }

            public NodeState nextNodeState() {
                NodeState item = null;
                NodeId id = (NodeId)this.iter.next();
                try {
                    item = (NodeState)SearchManager.this.itemMgr.getItemState(id);
                }
                catch (ItemStateException e) {
                    log.error("Unable to index node " + id + ": does not exist");
                }
                return item;
            }
        };
        NodeIdIterator removedIds = new NodeIdIterator(){
            private final Iterator iter;
            {
                this.iter = removedNodes.iterator();
            }

            public NodeId nextNodeId() throws NoSuchElementException {
                return (NodeId)this.iter.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.nextNodeId();
            }
        };
        if (removedNodes.size() > 0 || addedNodes.size() > 0) {
            try {
                this.ensureInitialized();
                this.handler.updateNodes(removedIds, addedStates);
            }
            catch (RepositoryException e) {
                log.error("Error indexing node.", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Error indexing node.", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("onEvent: indexing finished in " + String.valueOf(System.currentTimeMillis() - time) + " ms.");
        }
    }

    protected AbstractQueryImpl createQueryInstance() throws RepositoryException {
        try {
            Object obj = Class.forName(this.queryImplClassName).newInstance();
            if (obj instanceof AbstractQueryImpl) {
                this.activeQueries.put(obj, null);
                return (AbstractQueryImpl)obj;
            }
            throw new IllegalArgumentException(this.queryImplClassName + " is not of type " + AbstractQueryImpl.class.getName());
        }
        catch (Throwable t) {
            throw new RepositoryException("Unable to create query: " + t.toString());
        }
    }

    private void initializeQueryHandler() throws RepositoryException {
        try {
            this.handler = (QueryHandler)this.config.newInstance();
            QueryHandlerContext context = new QueryHandlerContext(this.fs, this.itemMgr, this.rootNodeId, this.ntReg, this.nsReg, this.parentHandler, this.excludedNodeId);
            this.handler.init(context);
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private synchronized void shutdownQueryHandler() throws IOException {
        if (this.handler != null) {
            this.handler.close();
            this.handler = null;
        }
    }

    private synchronized void ensureInitialized() throws RepositoryException {
        this.lastAccess = System.currentTimeMillis();
        if (this.handler == null) {
            this.initializeQueryHandler();
        }
    }
}

