/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.ui;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.jboss.seam.mail.ui.MailComponent;

public class UIBody
extends MailComponent {
    public static final String HTML = "html";
    public static final String PLAIN = "plain";
    private String type = "html";

    public void encodeChildren(FacesContext facesContext) throws IOException {
        try {
            String body = this.encode(facesContext);
            BodyPart bodyPart = null;
            if (PLAIN.equalsIgnoreCase(this.type)) {
                bodyPart = this.getTextBody(facesContext, body);
            } else if (HTML.equals(this.type)) {
                UIComponent alternative = this.getFacet("alternative");
                if (alternative != null) {
                    MimeMultipart multipart = new MimeMultipart("alternative");
                    multipart.addBodyPart(this.getTextBody(facesContext, this.encode(facesContext, alternative)));
                    multipart.addBodyPart(this.getHtmlBody(facesContext, body));
                    bodyPart = new MimeBodyPart();
                    bodyPart.setContent((Multipart)multipart);
                } else {
                    bodyPart = this.getHtmlBody(facesContext, body);
                }
            }
            this.getRootMultipart().addBodyPart(bodyPart);
        }
        catch (MessagingException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        if (this.type == null) {
            return this.getString("type");
        }
        return this.type;
    }

    private BodyPart getTextBody(FacesContext facesContext, Object body) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setDisposition("inline");
        if (facesContext.getResponseWriter().getCharacterEncoding() != null) {
            bodyPart.setContent(body, "text/plain; charset=" + facesContext.getResponseWriter().getCharacterEncoding() + "; format=flowed");
        } else {
            bodyPart.setContent(body, "text/plain");
        }
        return bodyPart;
    }

    private BodyPart getHtmlBody(FacesContext facesContext, Object body) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setDisposition("inline");
        if (facesContext.getResponseWriter().getCharacterEncoding() != null) {
            bodyPart.setContent(body, "text/html; charset=" + facesContext.getResponseWriter().getCharacterEncoding());
        } else {
            bodyPart.setContent(body, "text/html");
        }
        return bodyPart;
    }
}

