/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.instrument.WrapperTransformer;
import org.jboss.aop.util.JavassistMethodHashing;
import org.jboss.aop.util.MethodHashing;

public class MethodExecutionTransformer {
    private static final WrapperTransformer wrapper = new WrapperTransformer(WrapperTransformer.SINGLE_TRANSFORMATION);
    private Instrumentor instrumentor;
    private JoinpointClassifier classifier;

    public MethodExecutionTransformer(Instrumentor instrumentor) {
        this.instrumentor = instrumentor;
        this.classifier = instrumentor.joinpointClassifier;
    }

    private String addMethodInfoField(CtClass clazz, String methodName, long methodHash) throws Exception {
        CtClass type = this.instrumentor.forName("org.jboss.aop.MethodInfo");
        String name = MethodExecutionTransformer.getMethodInfoFieldName(methodName, methodHash);
        CtField field = new CtField(type, name, clazz);
        field.setModifiers(10);
        clazz.addField(field);
        return name;
    }

    public static String getMethodInfoFieldName(String methodName, long methodHash) {
        String hash = methodHash < 0L ? "_N_" + -1L * methodHash : "" + methodHash;
        String name = "aop$MethodInfo_" + methodName + hash;
        return name;
    }

    private JoinpointClassification[] classifyMethods(CtClass clazz, ClassAdvisor advisor) throws NotFoundException {
        CtMethod[] methods = clazz.getDeclaredMethods();
        JoinpointClassification[] classification = new JoinpointClassification[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            classification[i] = this.classifier.classifyMethodExecution(methods[i], advisor);
        }
        return classification;
    }

    public static String getOptimizedInvocationClassName(CtClass clazz, CtMethod method) throws Exception {
        long hash = JavassistMethodHashing.methodHash(method);
        StringBuffer sb = new StringBuffer(clazz.getName());
        sb.append(".").append(method.getName()).append("_").append(Long.toString(hash).replace('-', 'N'));
        return sb.toString();
    }

    public static String getOptimizedInvocationClassName(Method method) throws Exception {
        long hash = MethodHashing.methodHash(method);
        StringBuffer sb = new StringBuffer(method.getDeclaringClass().getName());
        sb.append(".").append(method.getName()).append("_").append(Long.toString(hash).replace('-', 'N'));
        return sb.toString();
    }

    protected String createOptimizedInvocationClass(CtClass clazz, CtMethod method) throws Exception {
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
        AOPClassPool pool = (AOPClassPool)this.instrumentor.getClassPool();
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
        String className = MethodExecutionTransformer.getOptimizedInvocationClassName(clazz, method);
        boolean makeInnerClass = true;
        CtClass invocation = TransformerCommon.makeInvocationClass(pool, makeInnerClass, clazz, className, methodInvocation);
        CtClass[] params = method.getParameterTypes();
        TransformerCommon.addArgumentFieldsToInvocation(invocation, params);
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        if (!isStatic) {
            CtField target = new CtField(method.getDeclaringClass(), "typedTargetObject", invocation);
            target.setModifiers(1);
            invocation.addField(target);
        }
        CtMethod in = methodInvocation.getDeclaredMethod("invokeNext");
        CtMethod invokeNext = CtNewMethod.make((CtClass)in.getReturnType(), (String)"invokeNext", (CtClass[])in.getParameterTypes(), (CtClass[])in.getExceptionTypes(), null, (CtClass)invocation);
        invokeNext.setModifiers(in.getModifiers());
        String code = "{    if (currentInterceptor < interceptors.length)    {       try         {          return interceptors[currentInterceptor++].invoke(this);       }        catch (Throwable t)        {           currentInterceptor--;           throw t;       }    } ";
        String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($w)";
        code = isStatic ? code + "   " + returnStr + " " + method.getDeclaringClass().getName() + "." : code + "   " + returnStr + " typedTargetObject.";
        code = code + wrappedName + "(";
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                code = code + ", ";
            }
            code = code + "arg" + i;
        }
        code = code + ");  ";
        if (method.getReturnType().equals(CtClass.voidType)) {
            code = code + " return null; ";
        }
        code = code + "}";
        try {
            invokeNext.setBody(code);
        }
        catch (CannotCompileException e) {
            System.out.println(code);
            throw e;
        }
        invocation.addMethod(invokeNext);
        TransformerCommon.addGetArguments(pool, invocation, method.getParameterTypes());
        MethodExecutionTransformer.addSetArguments(pool, invocation, method.getParameterTypes());
        this.addCopy(pool, invocation, method.getParameterTypes(), isStatic);
        TransformerCommon.compileOrLoadClass(method.getDeclaringClass(), invocation);
        return invocation.getName();
    }

    public void instrument(CtClass clazz, ClassAdvisor advisor) throws Exception {
        JoinpointClassification[] classification = this.classifyMethods(clazz, advisor);
        CtMethod[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (classification[i] == JoinpointClassification.NOT_INSTRUMENTED) continue;
            this.instrumentor.setupBasics(clazz);
            long hash = JavassistMethodHashing.methodHash(methods[i]);
            String name = methods[i].getName();
            String methodInfoField = this.addMethodInfoField(clazz, name, hash);
            boolean wrap = classification[i].equals(JoinpointClassification.WRAPPED);
            if (AspectManager.optimize) {
                this.optimized(methods[i], clazz, name, methodInfoField, wrap);
                continue;
            }
            this.unoptimized(methods[i], clazz, name, hash, methodInfoField, wrap);
        }
    }

    public void wrap(CtClass clazz, Collection methodInfos) throws Exception {
        Iterator iterator = methodInfos.iterator();
        while (iterator.hasNext()) {
            CtMethod javassistWMethod;
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            Method method = methodInfo.advisedMethod;
            AOPClassPool classPool = (AOPClassPool)clazz.getClassPool();
            Class<?>[] parameterTypes = method.getParameterTypes();
            CtClass[] javassistParameterTypes = new CtClass[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                classPool.getLocally(parameterTypes[i].getName());
            }
            if (method.getName().indexOf("access$") >= 0 || wrapper.isNotPrepared((CtMember)(javassistWMethod = clazz.getDeclaredMethod(method.getName(), javassistParameterTypes)), 0)) continue;
            CtMethod javassistMethod = clazz.getDeclaredMethod(ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName()), javassistParameterTypes);
            wrapper.wrap((CtMember)javassistWMethod, 0);
            long hash = JavassistMethodHashing.methodHash(javassistWMethod);
            String methodInfoFieldName = MethodExecutionTransformer.getMethodInfoFieldName(javassistWMethod.getName(), hash);
            if (AspectManager.optimize) {
                String invocationClassName = MethodExecutionTransformer.getOptimizedInvocationClassName(clazz, javassistWMethod);
                invocationClassName = invocationClassName.substring(invocationClassName.lastIndexOf(46) + 1);
                invocationClassName = method.getDeclaringClass().getName() + "$" + invocationClassName;
                this.setOptimizedWrapperBody(javassistMethod, javassistWMethod.getName(), methodInfoFieldName, javassistWMethod, javassistMethod.getName(), invocationClassName);
                continue;
            }
            this.setUnoptimizedWrapperBody(javassistMethod, javassistWMethod.getName(), hash, methodInfoFieldName, javassistMethod.getName(), javassistWMethod);
        }
    }

    public void unwrap(CtClass clazz, Collection methodInfos) throws Exception {
        Iterator iterator = methodInfos.iterator();
        while (iterator.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iterator.next();
            Method method = methodInfo.advisedMethod;
            AOPClassPool classPool = (AOPClassPool)clazz.getClassPool();
            Class<?>[] parameterTypes = method.getParameterTypes();
            CtClass[] javassistParameterTypes = new CtClass[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                classPool.getLocally(parameterTypes[i].getName());
            }
            CtMethod javassistWMethod = clazz.getDeclaredMethod(method.getName(), javassistParameterTypes);
            if (wrapper.isNotPrepared((CtMember)javassistWMethod, 0)) continue;
            CtMethod javassistMethod = clazz.getDeclaredMethod(ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName()), javassistParameterTypes);
            wrapper.unwrap((CtMember)javassistWMethod, 0);
            javassistWMethod.setBody(javassistMethod, null);
        }
    }

    public static String setArguments(CtClass[] params) throws Exception {
        String code = "";
        for (int i = 0; i < params.length; ++i) {
            code = code + "   invocation.arg" + i + " = $" + (i + 1) + "; ";
        }
        return code;
    }

    public static void addSetArguments(ClassPool pool, CtClass invocation, CtClass[] params) throws Exception {
        if (params == null || params.length == 0) {
            return;
        }
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("setArguments");
        String code = "public void setArguments(java.lang.Object[] args){ ";
        code = code + "   arguments = args; ";
        for (int i = 0; i < params.length; ++i) {
            if (params[i].isPrimitive()) {
                CtPrimitiveType primitive = (CtPrimitiveType)params[i];
                code = code + "   arg" + i + " = ((" + primitive.getWrapperName() + ")args[" + i + "])." + primitive.getGetMethodName() + "(); ";
                continue;
            }
            code = code + "   Object warg" + i + " = args[" + i + "]; ";
            code = code + "   arg" + i + " = (" + params[i].getName() + ")warg" + i + "; ";
        }
        code = code + "}";
        CtMethod setArguments = CtNewMethod.make((String)code, (CtClass)invocation);
        setArguments.setModifiers(template.getModifiers());
        invocation.addMethod(setArguments);
    }

    private void addCopy(ClassPool pool, CtClass invocation, CtClass[] params, boolean isStatic) throws Exception {
        CtClass methodInvocation = pool.get("org.jboss.aop.joinpoint.MethodInvocation");
        CtMethod template = methodInvocation.getDeclaredMethod("copy");
        CtMethod copy = CtNewMethod.make((CtClass)template.getReturnType(), (String)"copy", (CtClass[])template.getParameterTypes(), (CtClass[])template.getExceptionTypes(), null, (CtClass)invocation);
        copy.setModifiers(template.getModifiers());
        StringBuffer code = new StringBuffer("{");
        code.append("   ").append(invocation.getName()).append(" wrapper = new ").append(invocation.getName()).append("(this.interceptors, methodHash, advisedMethod, unadvisedMethod, advisor); ").append("   wrapper.arguments = this.arguments; ").append("   wrapper.metadata = this.metadata; ").append("   wrapper.currentInterceptor = this.currentInterceptor; ").append("   wrapper.instanceResolver = this.instanceResolver; ");
        if (!isStatic) {
            code.append("   wrapper.typedTargetObject = this.typedTargetObject; ");
            code.append("   wrapper.targetObject = this.targetObject; ");
        }
        for (int i = 0; i < params.length; ++i) {
            code.append("   wrapper.arg").append(i).append(" = this.arg").append(i).append("; ");
        }
        code.append("   return wrapper; }");
        copy.setBody(code.toString());
        invocation.addMethod(copy);
    }

    private void copyAnnotations(CtMethod src, CtMethod dest) {
        AnnotationsAttribute visible;
        javassist.bytecode.MethodInfo mi = src.getMethodInfo2();
        javassist.bytecode.MethodInfo wmi = dest.getMethodInfo2();
        AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        if (invisible != null) {
            wmi.addAttribute(invisible.copy(wmi.getConstPool(), new HashMap()));
        }
        if ((visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations")) != null) {
            wmi.addAttribute(visible.copy(wmi.getConstPool(), new HashMap()));
        }
    }

    private void optimized(CtMethod method, CtClass clazz, String name, String methodInfoField, boolean wrap) throws Exception {
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
        CtMethod wmethod = CtNewMethod.copy((CtMethod)method, (CtClass)clazz, null);
        String originalName = method.getName();
        wmethod.setName(wrappedName);
        clazz.addMethod(wmethod);
        this.copyAnnotations(method, wmethod);
        String optimizedInvocation = this.createOptimizedInvocationClass(clazz, method);
        method.setName(wrappedName);
        wmethod.setName(originalName);
        wrapper.prepareForWrapping((CtMember)wmethod, 0);
        if (wrap) {
            wrapper.wrap((CtMember)wmethod, 0);
            this.setOptimizedWrapperBody(method, name, methodInfoField, wmethod, wrappedName, optimizedInvocation);
        }
    }

    private void setOptimizedWrapperBody(CtMethod method, String name, String methodInfoField, CtMethod wmethod, String wrappedName, String optimizedInvocation) throws NotFoundException, Exception {
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        String code = null;
        String aopReturnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
        String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ";
        code = !isStatic ? "{     if (" + methodInfoField + ".interceptors != (Object[])null || (_instanceAdvisor != null && _instanceAdvisor.hasInstanceAspects)) " + "    { " + "       org.jboss.aop.advice.Interceptor[] interceptors = " + methodInfoField + ".interceptors;" + "       if (_instanceAdvisor != null) " + "       { " + "          interceptors = _instanceAdvisor.getInterceptors(interceptors); " + "       } " + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + methodInfoField + ", interceptors); " + MethodExecutionTransformer.setArguments(method.getParameterTypes()) + "       invocation.setTargetObject(this); " + "       invocation.typedTargetObject = this; " + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       " + aopReturnStr + "invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       " + returnStr + " " + wrappedName + "($$); " + "    }" + "}" : "{     if (" + methodInfoField + ".interceptors != (Object[])null) " + "    { " + "       org.jboss.aop.advice.Interceptor[] interceptors = " + methodInfoField + ".interceptors;" + "       " + optimizedInvocation + " invocation = new " + optimizedInvocation + "(" + methodInfoField + ", interceptors); " + MethodExecutionTransformer.setArguments(method.getParameterTypes()) + "       invocation.setAdvisor(" + "aop$classAdvisor$aop" + "); " + "       " + aopReturnStr + "invocation.invokeNext(); " + "    } " + "    else " + "    {" + "       " + returnStr + " " + wrappedName + "($$); " + "    }" + "}";
        try {
            wmethod.setBody(code);
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
            throw new RuntimeException("code was: " + code + " for method " + name);
        }
    }

    private void unoptimized(CtMethod method, CtClass clazz, String name, long hash, String methodInfoField, boolean wrap) throws NotFoundException, CannotCompileException {
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), method.getName());
        CtMethod wmethod = CtNewMethod.copy((CtMethod)method, (CtClass)clazz, null);
        String originalName = method.getName();
        wmethod.setName(wrappedName);
        clazz.addMethod(wmethod);
        this.copyAnnotations(method, wmethod);
        method.setName(wrappedName);
        wmethod.setName(originalName);
        wrapper.prepareForWrapping((CtMember)wmethod, 0);
        if (wrap) {
            wrapper.wrap((CtMember)wmethod, 0);
            this.setUnoptimizedWrapperBody(method, name, hash, methodInfoField, wrappedName, wmethod);
        }
    }

    private void setUnoptimizedWrapperBody(CtMethod method, String name, long hash, String methodInfoField, String wrappedName, CtMethod wmethod) throws NotFoundException {
        boolean isStatic = Modifier.isStatic((int)method.getModifiers());
        String code = null;
        String aopReturnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
        String returnStr = method.getReturnType().equals(CtClass.voidType) ? "" : "return ";
        String args = "null";
        if (method.getParameterTypes().length > 0) {
            args = "$args";
        }
        code = !isStatic ? "{     if (" + methodInfoField + ".interceptors != (Object[])null || (_instanceAdvisor != null && _instanceAdvisor.hasInstanceAspects)) " + "    { " + "       Object[] ags = " + args + "; " + "       " + aopReturnStr + "aop$classAdvisor$aop" + ".invokeMethod(_instanceAdvisor, this, " + hash + "L, ags, " + methodInfoField + "); " + "    } " + "    else " + "    {" + "       " + returnStr + " " + wrappedName + "($$); " + "    }" + "}" : "{     if (" + methodInfoField + ".interceptors != (Object[])null) " + "    { " + "       org.jboss.aop.ClassInstanceAdvisor ia = null; " + "       Object[] ags = " + args + "; " + "       Object target = null; " + "       " + aopReturnStr + "aop$classAdvisor$aop" + ".invokeMethod(ia, target, " + hash + "L, ags, " + methodInfoField + "); " + "    } " + "    else " + "    {" + "       " + returnStr + " " + wrappedName + "($$); " + "    }" + "}";
        try {
            wmethod.setBody(code);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("code was: " + code + " for method " + name, e);
        }
    }
}

