/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.mvel.ASTIterator;
import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.CompiledExpression;
import org.mvel.DataConversion;
import org.mvel.ExecutableAccessor;
import org.mvel.ExecutableLiteral;
import org.mvel.ExpressionCompiler;
import org.mvel.MVEL;
import org.mvel.OptimizationFailure;
import org.mvel.ParseException;
import org.mvel.integration.ResolverTools;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.ClassImportResolverFactory;
import org.mvel.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel.integration.impl.LocalVariableResolverFactory;
import org.mvel.integration.impl.StaticMethodImportResolverFactory;
import org.mvel.math.MathProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTools {
    public static final Object[] EMPTY_OBJ_ARR;
    public static final MathProcessor MATH_PROCESSOR;
    public static final boolean JDK_14_COMPATIBILITY;
    private static Map<String, Map<Integer, Method>> RESOLVED_METH_CACHE;
    private static Map<Class, Map<Integer, Constructor>> RESOLVED_CONST_CACHE;
    private static Map<Constructor, Class[]> CONSTRUCTOR_PARMS_CACHE;
    private static Map<String, Class> CLASS_RESOLVER_CACHE;
    private static Map<Class, Constructor[]> CLASS_CONSTRUCTOR_CACHE;

    public static String[] parseMethodOrConstructor(char[] parm) {
        int start = -1;
        for (int i = 0; i < parm.length; ++i) {
            if (parm[i] != '(') continue;
            start = ++i;
            break;
        }
        if (start != -1) {
            return ParseTools.parseParameterList(parm, --start + 1, ParseTools.balancedCapture(parm, start, '(') - start - 1);
        }
        return null;
    }

    public static String[] parseParameterList(char[] parm, int offset, int length) {
        String s;
        int i;
        LinkedList<String> list = new LinkedList<String>();
        if (length == -1) {
            length = parm.length;
        }
        int adepth = 0;
        int start = offset;
        int end = i + length;
        block14: for (i = offset; i < end; ++i) {
            switch (parm[i]) {
                case '(': {
                    int depth = 1;
                    while (i++ < length - 1 && depth != 0) {
                        switch (parm[i]) {
                            case '(': {
                                ++depth;
                                break;
                            }
                            case ')': {
                                --depth;
                                break;
                            }
                            case '\'': {
                                i = ParseTools.captureStringLiteral('\'', parm, i, parm.length);
                                break;
                            }
                            case '\"': {
                                i = ParseTools.captureStringLiteral('\"', parm, i, parm.length);
                            }
                        }
                    }
                    --i;
                    continue block14;
                }
                case '[': 
                case '{': {
                    ++adepth;
                    continue block14;
                }
                case ']': 
                case '}': {
                    if (--adepth != 0) continue block14;
                    list.add(new String(parm, start, i - start + 1));
                    while (Character.isWhitespace(parm[i])) {
                        ++i;
                    }
                    start = i + 1;
                    continue block14;
                }
                case '\'': {
                    i = ParseTools.captureStringLiteral('\'', parm, i, parm.length);
                    continue block14;
                }
                case '\"': {
                    i = ParseTools.captureStringLiteral('\"', parm, i, parm.length);
                    continue block14;
                }
                case ',': {
                    if (adepth != 0) continue block14;
                    if (i > start) {
                        while (Character.isWhitespace(parm[start])) {
                            ++start;
                        }
                        list.add(new String(parm, start, i - start));
                    }
                    while (Character.isWhitespace(parm[i])) {
                        ++i;
                    }
                    start = i + 1;
                }
            }
        }
        if (start < length + offset && i > start) {
            String s2 = new String(parm, start, i - start).trim();
            if (s2.length() > 0) {
                list.add(s2);
            }
        } else if (list.size() == 0 && (s = new String(parm, start, length).trim()).length() > 0) {
            list.add(s);
        }
        return list.toArray(new String[list.size()]);
    }

    public static Method getBestCandidate(Object[] arguments, String method, Method[] methods) {
        Class[] targetParms = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            targetParms[i] = arguments[i] != null ? arguments[i].getClass() : Object.class;
        }
        return ParseTools.getBestCandidate(targetParms, method, methods);
    }

    public static Method getBestCandidate(Class[] arguments, String method, Method[] methods) {
        if (methods.length == 0) {
            return null;
        }
        Method bestCandidate = null;
        int bestScore = 0;
        int score = 0;
        Integer hash = ParseTools.createClassSignatureHash(methods[0].getDeclaringClass(), arguments);
        if (RESOLVED_METH_CACHE.containsKey(method) && RESOLVED_METH_CACHE.get(method).containsKey(hash)) {
            return RESOLVED_METH_CACHE.get(method).get(hash);
        }
        for (Method meth : methods) {
            Class<?>[] parmTypes;
            if (!method.equals(meth.getName()) || (parmTypes = meth.getParameterTypes()).length != arguments.length) continue;
            if (arguments.length == 0 && parmTypes.length == 0) {
                bestCandidate = meth;
                break;
            }
            for (int i = 0; i < arguments.length; ++i) {
                if (parmTypes[i] == arguments[i]) {
                    score += 5;
                    continue;
                }
                if (parmTypes[i].isPrimitive() && ParseTools.boxPrimitive(parmTypes[i]) == arguments[i]) {
                    score += 4;
                    continue;
                }
                if (arguments[i].isPrimitive() && ParseTools.unboxPrimitive(arguments[i]) == parmTypes[i]) {
                    score += 4;
                    continue;
                }
                if (ParseTools.isNumericallyCoercible(arguments[i], parmTypes[i])) {
                    score += 3;
                    continue;
                }
                if (parmTypes[i].isAssignableFrom(arguments[i])) {
                    score += 2;
                    continue;
                }
                if (DataConversion.canConvert(parmTypes[i], arguments[i]) || arguments[i] == Object.class) {
                    ++score;
                    continue;
                }
                score = 0;
                break;
            }
            if (score != 0 && score > bestScore) {
                bestCandidate = meth;
                bestScore = score;
            }
            score = 0;
        }
        if (bestCandidate != null) {
            if (!RESOLVED_METH_CACHE.containsKey(method)) {
                RESOLVED_METH_CACHE.put(method, new WeakHashMap());
            }
            RESOLVED_METH_CACHE.get(method).put(hash, bestCandidate);
        }
        return bestCandidate;
    }

    public static Method getWidenedTarget(Method method) {
        Class<?> cls = method.getDeclaringClass();
        Method m = method;
        Class[] args = method.getParameterTypes();
        String name = method.getName();
        do {
            for (Class<?> iface : cls.getInterfaces()) {
                m = ParseTools.getBestCandidate(args, name, iface.getMethods());
                if (m == null || m.getDeclaringClass().getSuperclass() == null) continue;
                cls = m.getDeclaringClass();
            }
        } while ((cls = cls.getSuperclass()) != null);
        return m != null ? m : method;
    }

    private static Class[] getConstructors(Constructor cns) {
        if (CONSTRUCTOR_PARMS_CACHE.containsKey(cns)) {
            return CONSTRUCTOR_PARMS_CACHE.get(cns);
        }
        Class[] c = cns.getParameterTypes();
        CONSTRUCTOR_PARMS_CACHE.put(cns, c);
        return c;
    }

    public static Constructor getBestConstructorCanadidate(Object[] arguments, Class cls) {
        Constructor bestCandidate = null;
        int bestScore = 0;
        int score = 0;
        Class[] targetParms = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            targetParms[i] = arguments[i] != null ? arguments[i].getClass() : Object.class;
        }
        Integer hash = ParseTools.createClassSignatureHash(cls, targetParms);
        if (RESOLVED_CONST_CACHE.containsKey(cls) && RESOLVED_CONST_CACHE.get(cls).containsKey(hash)) {
            return RESOLVED_CONST_CACHE.get(cls).get(hash);
        }
        for (Constructor construct : ParseTools.getConstructors(cls)) {
            Class[] parmTypes = ParseTools.getConstructors(construct);
            if (parmTypes.length != arguments.length) continue;
            if (arguments.length == 0 && parmTypes.length == 0) {
                return construct;
            }
            for (int i = 0; i < arguments.length; ++i) {
                if (parmTypes[i] == targetParms[i]) {
                    score += 5;
                    continue;
                }
                if (parmTypes[i].isPrimitive() && ParseTools.boxPrimitive(parmTypes[i]) == targetParms[i]) {
                    score += 4;
                    continue;
                }
                if (targetParms[i].isPrimitive() && ParseTools.unboxPrimitive(targetParms[i]) == parmTypes[i]) {
                    score += 4;
                    continue;
                }
                if (ParseTools.isNumericallyCoercible(targetParms[i], parmTypes[i])) {
                    score += 3;
                    continue;
                }
                if (parmTypes[i].isAssignableFrom(targetParms[i])) {
                    score += 2;
                    continue;
                }
                if (DataConversion.canConvert(parmTypes[i], targetParms[i])) {
                    ++score;
                    continue;
                }
                score = 0;
                break;
            }
            if (score != 0 && score > bestScore) {
                bestCandidate = construct;
                bestScore = score;
            }
            score = 0;
        }
        if (bestCandidate != null) {
            if (!RESOLVED_CONST_CACHE.containsKey(cls)) {
                RESOLVED_CONST_CACHE.put(cls, new WeakHashMap());
            }
            RESOLVED_CONST_CACHE.get(cls).put(hash, bestCandidate);
        }
        return bestCandidate;
    }

    public static Class createClassSafe(String className) {
        try {
            return ParseTools.createClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class createClass(String className) throws ClassNotFoundException {
        if (CLASS_RESOLVER_CACHE.containsKey(className)) {
            return CLASS_RESOLVER_CACHE.get(className);
        }
        Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className);
        CLASS_RESOLVER_CACHE.put(className, cls);
        return cls;
    }

    public static Constructor[] getConstructors(Class cls) {
        if (CLASS_CONSTRUCTOR_CACHE.containsKey(cls)) {
            return CLASS_CONSTRUCTOR_CACHE.get(cls);
        }
        Constructor[] cns = cls.getConstructors();
        CLASS_CONSTRUCTOR_CACHE.put(cls, cns);
        return cns;
    }

    public static String[] captureContructorAndResidual(String token) {
        char[] cs = token.toCharArray();
        int depth = 0;
        block4: for (int i = 0; i < cs.length; ++i) {
            switch (cs[i]) {
                case '(': {
                    ++depth;
                    continue block4;
                }
                case ')': {
                    if (1 != depth--) continue block4;
                    return new String[]{new String(cs, 0, ++i), new String(cs, i, cs.length - i)};
                }
            }
        }
        return new String[]{token};
    }

    public static String[] captureContructorAndResidual(char[] cs) {
        int depth = 0;
        block4: for (int i = 0; i < cs.length; ++i) {
            switch (cs[i]) {
                case '(': {
                    ++depth;
                    continue block4;
                }
                case ')': {
                    if (1 != depth--) continue block4;
                    return new String[]{new String(cs, 0, ++i), new String(cs, i, cs.length - i)};
                }
            }
        }
        return new String[]{new String(cs)};
    }

    public static Class boxPrimitive(Class cls) {
        if (cls == Integer.TYPE || cls == Integer.class) {
            return Integer.class;
        }
        if (cls == int[].class || cls == Integer[].class) {
            return Integer[].class;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return Long.class;
        }
        if (cls == long[].class || cls == Long[].class) {
            return Long[].class;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return Short.class;
        }
        if (cls == short[].class || cls == Short[].class) {
            return Short[].class;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return Double.class;
        }
        if (cls == double[].class || cls == Double[].class) {
            return Double[].class;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return Float.class;
        }
        if (cls == float[].class || cls == Float[].class) {
            return Float[].class;
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return Boolean.class;
        }
        if (cls == boolean[].class || cls == Boolean[].class) {
            return Boolean[].class;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return Byte.class;
        }
        if (cls == byte[].class || cls == Byte[].class) {
            return Byte[].class;
        }
        return null;
    }

    public static Class unboxPrimitive(Class cls) {
        if (cls == Integer.class || cls == Integer.TYPE) {
            return Integer.TYPE;
        }
        if (cls == Integer[].class || cls == int[].class) {
            return int[].class;
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return Long.TYPE;
        }
        if (cls == Long[].class || cls == long[].class) {
            return long[].class;
        }
        if (cls == Short.class || cls == Short.TYPE) {
            return Short.TYPE;
        }
        if (cls == Short[].class || cls == short[].class) {
            return short[].class;
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return Double.TYPE;
        }
        if (cls == Double[].class || cls == double[].class) {
            return double[].class;
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.TYPE;
        }
        if (cls == Float[].class || cls == float[].class) {
            return float[].class;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return Boolean.TYPE;
        }
        if (cls == Boolean[].class || cls == boolean[].class) {
            return boolean[].class;
        }
        if (cls == Byte.class || cls == Byte.TYPE) {
            return Byte.TYPE;
        }
        if (cls == Byte[].class || cls == byte[].class) {
            return byte[].class;
        }
        return null;
    }

    public static boolean containsCheck(Object compareTo, Object compareTest) {
        if (compareTo == null) {
            return false;
        }
        if (compareTo instanceof String) {
            return ((String)compareTo).indexOf(String.valueOf(compareTest)) > -1;
        }
        if (compareTo instanceof Collection) {
            return ((Collection)compareTo).contains(compareTest);
        }
        if (compareTo instanceof Map) {
            return ((Map)compareTo).containsKey(compareTest);
        }
        if (compareTo.getClass().isArray()) {
            for (Object o : (Object[])compareTo) {
                if (compareTest == null && o == null) {
                    return true;
                }
                if (!((Boolean)ParseTools.doOperations(o, 10, compareTest)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static int createClassSignatureHash(Class declaring, Class[] sig) {
        int hash = 0;
        for (Class cls : sig) {
            if (cls == null) continue;
            hash += cls.hashCode();
        }
        return hash + sig.length + declaring.hashCode();
    }

    public static char handleEscapeSequence(char escapedChar) {
        switch (escapedChar) {
            case '\\': {
                return '\\';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'n': {
                return '\n';
            }
            case '\'': {
                return '\'';
            }
            case '\"': {
                return '\"';
            }
        }
        throw new ParseException("illegal escape sequence: " + escapedChar);
    }

    public static char[] createShortFormOperativeAssignment(String name, char[] statement, int operation) {
        if (operation == -1) {
            return statement;
        }
        int op = 0;
        switch (operation) {
            case 0: {
                op = 43;
                break;
            }
            case 1: {
                op = 45;
                break;
            }
            case 2: {
                op = 42;
                break;
            }
            case 3: {
                op = 47;
                break;
            }
            case 21: {
                op = 38;
                break;
            }
            case 22: {
                op = 124;
            }
        }
        char[] stmt = new char[name.length() + statement.length + 1];
        System.arraycopy(name.toCharArray(), 0, stmt, 0, name.length());
        stmt[name.length()] = op;
        System.arraycopy(statement, 0, stmt, name.length() + 1, statement.length);
        return stmt;
    }

    public static VariableResolverFactory finalLocalVariableFactory(VariableResolverFactory factory) {
        for (VariableResolverFactory v = factory; v != null; v = v.getNextFactory()) {
            if (!(v instanceof LocalVariableResolverFactory)) continue;
            return v;
        }
        if (factory == null) {
            throw new OptimizationFailure("unable to assign variables.  no variable resolver factory available.");
        }
        return new DefaultLocalVariableResolverFactory(new HashMap<String, Object>()).setNextFactory(factory);
    }

    public static ClassImportResolverFactory findClassImportResolverFactory(VariableResolverFactory factory) {
        for (VariableResolverFactory v = factory; v != null; v = v.getNextFactory()) {
            if (!(v instanceof ClassImportResolverFactory)) continue;
            return (ClassImportResolverFactory)v;
        }
        if (factory == null) {
            throw new OptimizationFailure("unable to import classes.  no variable resolver factory available.");
        }
        return ResolverTools.insertFactory(factory, new ClassImportResolverFactory());
    }

    public static StaticMethodImportResolverFactory findStaticMethodImportResolverFactory(VariableResolverFactory factory) {
        for (VariableResolverFactory v = factory; v != null; v = v.getNextFactory()) {
            if (!(v instanceof StaticMethodImportResolverFactory)) continue;
            return (StaticMethodImportResolverFactory)v;
        }
        if (factory == null) {
            throw new OptimizationFailure("unable to import classes.  no variable resolver factory available.");
        }
        return ResolverTools.insertFactory(factory, new StaticMethodImportResolverFactory());
    }

    public static Class findClass(VariableResolverFactory factory, String name) throws ClassNotFoundException {
        try {
            if (AbstractParser.LITERALS.containsKey(name)) {
                return (Class)AbstractParser.LITERALS.get(name);
            }
            if (factory != null && factory.isResolveable(name)) {
                return (Class)factory.getVariableResolver(name).getValue();
            }
            if (AbstractParser.getCurrentThreadParserContext() != null && AbstractParser.getCurrentThreadParserContext().hasImport(name)) {
                return AbstractParser.getCurrentThreadParserContext().getImport(name);
            }
            return ParseTools.createClass(name);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompileException("class not found: " + name, e);
        }
    }

    public static boolean debug(String str) {
        return true;
    }

    public static boolean debug(Throwable t) {
        t.printStackTrace();
        return true;
    }

    public static char[] subset(char[] array, int start, int length) {
        char[] newArray = new char[length];
        System.arraycopy(array, start, newArray, 0, length);
        return newArray;
    }

    public static char[] subset(char[] array, int start) {
        char[] newArray = new char[array.length - start];
        System.arraycopy(array, start, newArray, 0, newArray.length);
        return newArray;
    }

    public static int resolveType(Class cls) {
        if (cls == null) {
            return 0;
        }
        if (BigDecimal.class == cls) {
            return 110;
        }
        if (BigInteger.class == cls) {
            return 111;
        }
        if (String.class == cls) {
            return 1;
        }
        if (Integer.TYPE == cls) {
            return 101;
        }
        if (Short.TYPE == cls) {
            return 100;
        }
        if (Float.TYPE == cls) {
            return 104;
        }
        if (Double.TYPE == cls) {
            return 103;
        }
        if (Long.TYPE == cls) {
            return 102;
        }
        if (Boolean.TYPE == cls) {
            return 7;
        }
        if (Byte.TYPE == cls) {
            return 9;
        }
        if (Character.TYPE == cls) {
            return 8;
        }
        if (Integer.class == cls) {
            return 106;
        }
        if (Short.class == cls) {
            return 105;
        }
        if (Float.class == cls) {
            return 109;
        }
        if (Double.class == cls) {
            return 108;
        }
        if (Long.class == cls) {
            return 107;
        }
        if (Boolean.class == cls) {
            return 15;
        }
        if (Byte.class == cls) {
            return 17;
        }
        if (Character.class == cls) {
            return 16;
        }
        return 0;
    }

    public static Object valueOnly(Object o) {
        return o instanceof ASTNode ? ((ASTNode)o).getLiteralValue() : o;
    }

    public static boolean isNumericallyCoercible(Class target, Class parm) {
        Class boxedTarget;
        Class clazz = boxedTarget = target.isPrimitive() ? ParseTools.boxPrimitive(target) : target;
        if (boxedTarget != null && Number.class.isAssignableFrom(target)) {
            Class boxedParm;
            Class clazz2 = boxedParm = parm.isPrimitive() ? ParseTools.boxPrimitive(parm) : parm;
            if (boxedParm != null) {
                return Number.class.isAssignableFrom(boxedParm);
            }
        }
        return false;
    }

    public static Object handleParserEgress(Object result, boolean returnBigDecimal) {
        if (result instanceof BigDecimal) {
            if (returnBigDecimal) {
                return result;
            }
            if (((BigDecimal)result).scale() > 14) {
                return ((BigDecimal)result).doubleValue();
            }
            if (((BigDecimal)result).scale() > 0) {
                return Float.valueOf(((BigDecimal)result).floatValue());
            }
            if (((BigDecimal)result).longValue() > Integer.MAX_VALUE) {
                return ((BigDecimal)result).longValue();
            }
            return ((BigDecimal)result).intValue();
        }
        return result;
    }

    public static Method determineActualTargetMethod(Method method) {
        String name = method.getName();
        for (Class<?> cls : method.getDeclaringClass().getInterfaces()) {
            for (Method meth : cls.getMethods()) {
                if (meth.getParameterTypes().length != 0 || !name.equals(meth.getName())) continue;
                return meth;
            }
        }
        return null;
    }

    public static Object doOperations(Object val1, int operation, Object val2) {
        return MATH_PROCESSOR.doOperation(val1, operation, val2);
    }

    public static Object increment(Object o) {
        if (o instanceof Integer) {
            return (Integer)o + 1;
        }
        if (o instanceof Double) {
            return (Double)o + 1.0;
        }
        if (o instanceof Float) {
            return Float.valueOf(((Float)o).floatValue() + 1.0f);
        }
        if (o instanceof Short) {
            return (Short)o + 1;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue() + '\u0001';
        }
        throw new CompileException("unable to increment type: " + (o != null ? o.getClass().getName() : "null"));
    }

    public static Map<String, String> parseParameters(char[] parms) {
        int i;
        HashMap<String, String> allParms = new HashMap<String, String>();
        boolean capture = false;
        int start = 0;
        String parmName = null;
        block4: for (i = 0; i < parms.length; ++i) {
            switch (parms[i]) {
                case '=': {
                    parmName = new String(parms, start, ++i - start - 1).trim();
                    capture = true;
                    start = i;
                    continue block4;
                }
                case ',': {
                    if (!capture) continue block4;
                    allParms.put(parmName, new String(parms, start, i - start).trim());
                    start = ++i;
                    capture = false;
                }
            }
        }
        if (capture) {
            allParms.put(parmName, new String(parms, start, i - start).trim());
        }
        return allParms;
    }

    public static int balancedCapture(char[] chars, int start, char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type == term) {
            ++start;
            while (start < chars.length) {
                if (chars[start] == type) {
                    return start;
                }
                ++start;
            }
        } else {
            ++start;
            while (start < chars.length) {
                if (chars[start] == '\'' || chars[start] == '\"') {
                    start = ParseTools.captureStringLiteral(chars[start], chars, start, chars.length);
                } else if (chars[start] == type) {
                    ++depth;
                } else if (chars[start] == term && --depth == 0) {
                    return start;
                }
                ++start;
            }
        }
        return -1;
    }

    public static int[] balancedCaptureWithLineAccounting(char[] chars, int start, char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type == term) {
            ++start;
            while (start < chars.length) {
                if (chars[start] == type) {
                    return new int[]{start, 0};
                }
                ++start;
            }
        } else {
            int lines = 0;
            ++start;
            while (start < chars.length) {
                if (Character.isWhitespace(chars[start])) {
                    switch (chars[start]) {
                        case '\r': {
                            break;
                        }
                        case '\n': {
                            ++lines;
                        }
                    }
                } else if (chars[start] == '\'' || chars[start] == '\"') {
                    start = ParseTools.captureStringLiteral(chars[start], chars, start, chars.length);
                } else if (chars[start] == type) {
                    ++depth;
                } else if (chars[start] == term && --depth == 0) {
                    return new int[]{start, lines};
                }
                ++start;
            }
        }
        return new int[]{-1, 0};
    }

    public static String handleStringEscapes(char[] input) {
        int escapes = 0;
        for (int i = 0; i < input.length; ++i) {
            if (input[i] != '\\') continue;
            input[i++] = '\u0000';
            input[i] = ParseTools.handleEscapeSequence(input[i]);
            ++escapes;
        }
        char[] processedEscapeString = new char[input.length - escapes];
        int cursor = 0;
        for (char aName : input) {
            if (aName == '\u0000') continue;
            processedEscapeString[cursor++] = aName;
        }
        return new String(processedEscapeString);
    }

    public static int captureStringLiteral(char type, char[] expr, int cursor, int length) {
        while (++cursor < length && expr[cursor] != type) {
            if (expr[cursor] != '\\') continue;
            ParseTools.handleEscapeSequence(expr[++cursor]);
        }
        if (cursor == length || expr[cursor] != type) {
            throw new CompileException("unterminated literal", expr, cursor);
        }
        return cursor;
    }

    public static String getSimpleClassName(Class cls) {
        if (JDK_14_COMPATIBILITY) {
            int lastIndex = cls.getName().lastIndexOf(36);
            if (lastIndex < 0) {
                lastIndex = cls.getName().lastIndexOf(46);
            }
            if (cls.isArray()) {
                return cls.getName().substring(lastIndex + 1) + "[]";
            }
            return cls.getName().substring(lastIndex + 1);
        }
        return cls.getSimpleName();
    }

    public static void checkNameSafety(String name) {
        if (AbstractParser.isReservedWord(name)) {
            throw new CompileException("reserved word in assignment: " + name);
        }
    }

    public static FileWriter getDebugFileWriter() throws IOException {
        return new FileWriter(new File(MVEL.getDebuggingOutputFileName()), true);
    }

    public static boolean isPrimitiveWrapper(Class clazz) {
        return clazz == Integer.class || clazz == Boolean.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class;
    }

    public static Serializable subCompileExpression(String expression) {
        return ParseTools.optimizeTree(new ExpressionCompiler(expression)._compile());
    }

    public static Serializable subCompileExpression(char[] expression) {
        return ParseTools.optimizeTree(new ExpressionCompiler(expression)._compile());
    }

    public static Serializable optimizeTree(CompiledExpression compiled) {
        ASTIterator nodes = compiled.getTokens();
        if (MVEL.isOptimizationEnabled() && nodes.size() == 1) {
            ASTNode tk = nodes.firstNode();
            if (tk.isLiteral() && !tk.isThisVal()) {
                if ((tk.getFields() & 0x800000) != 0) {
                    return new ExecutableLiteral(tk.getIntRegister());
                }
                return new ExecutableLiteral(tk.getLiteralValue());
            }
            if (tk.isIdentifier()) {
                return new ExecutableAccessor(tk, false);
            }
        }
        return compiled;
    }

    static {
        block5: {
            EMPTY_OBJ_ARR = new Object[0];
            try {
                double version = Double.parseDouble(System.getProperty("java.version").substring(0, 3));
                if (version == 1.4) {
                    MATH_PROCESSOR = (MathProcessor)Thread.currentThread().getContextClassLoader().loadClass("org.mvel.math.JDK14CompatabilityMath").newInstance();
                    JDK_14_COMPATIBILITY = true;
                    break block5;
                }
                if (version > 1.4) {
                    MATH_PROCESSOR = (MathProcessor)Thread.currentThread().getContextClassLoader().loadClass("org.mvel.math.IEEEFloatingPointMath").newInstance();
                    JDK_14_COMPATIBILITY = false;
                    break block5;
                }
                throw new RuntimeException("unsupported java version: " + version);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("unable to initialize math processor", e);
            }
        }
        RESOLVED_METH_CACHE = new WeakHashMap<String, Map<Integer, Method>>(10);
        RESOLVED_CONST_CACHE = new WeakHashMap<Class, Map<Integer, Constructor>>(10);
        CONSTRUCTOR_PARMS_CACHE = new WeakHashMap<Constructor, Class[]>(10);
        CLASS_RESOLVER_CACHE = new WeakHashMap<String, Class>(10);
        CLASS_CONSTRUCTOR_CACHE = new WeakHashMap<Class, Constructor[]>(10);
    }
}

