/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import java.util.HashMap;
import org.mvel.CompileException;
import org.mvel.ExecutableStatement;
import org.mvel.ast.BlockNode;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel.util.ParseTools;

public class ForEachNode
extends BlockNode {
    protected String item;
    protected ExecutableStatement condition;
    protected ExecutableStatement compiledBlock;

    public ForEachNode(char[] condition, char[] block, int fields) {
        super(condition, fields);
        this.handleCond(condition);
        this.block = block;
        this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(block);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object ret;
        block3: {
            Object iterCond;
            DefaultLocalVariableResolverFactory local;
            HashMap<String, Object> locals;
            block2: {
                locals = new HashMap<String, Object>();
                local = new DefaultLocalVariableResolverFactory(locals);
                ret = null;
                iterCond = this.condition.getValue(ctx, thisValue, local.setNextFactory(factory));
                if (!(iterCond instanceof Iterable)) break block2;
                for (Object o : (Iterable)iterCond) {
                    locals.put(this.item, o);
                    ret = this.compiledBlock.getValue(ctx, thisValue, local);
                }
                break block3;
            }
            if (!(iterCond instanceof Object[])) break block3;
            for (Object o : (Object[])iterCond) {
                locals.put(this.item, o);
                ret = this.compiledBlock.getValue(ctx, thisValue, local);
            }
        }
        return ret == null ? Void.class : ret;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    private void handleCond(char[] condition) {
        int cursor;
        for (cursor = 0; cursor < condition.length && condition[cursor] != ':'; ++cursor) {
        }
        if (cursor == condition.length || condition[cursor] != ':') {
            throw new CompileException("expected : in foreach");
        }
        this.item = new String(condition, 0, cursor).trim();
        this.condition = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(condition, ++cursor));
    }
}

