/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.CompiledSetExpression;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.ast.Assignment;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ArrayTools;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;

public class AssignmentNode
extends ASTNode
implements Assignment {
    private String name;
    private transient CompiledSetExpression setExpr;
    private char[] indexTarget;
    private char[] index;
    private char[] stmt;
    private ExecutableStatement statement;
    private boolean col = false;

    public AssignmentNode(char[] expr, int fields, int operation, String name) {
        super(expr, fields);
        if (operation != -1) {
            this.name = name.trim();
            ParseTools.checkNameSafety(this.name);
            this.stmt = ParseTools.createShortFormOperativeAssignment(name, expr, operation);
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
            this.egressType = this.statement.getKnownEgressType();
        } else {
            int assignStart = PropertyTools.find(expr, '=');
            if (assignStart != -1) {
                this.name = new String(expr, 0, assignStart).trim();
                this.stmt = ParseTools.subset(expr, assignStart + 1);
                if ((fields & 0x10) != 0) {
                    this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
                    this.egressType = this.statement.getKnownEgressType();
                }
                if (this.col = (this.endOfName = ArrayTools.findFirst('[', this.indexTarget = this.name.toCharArray())) > 0) {
                    this.fields |= 0x2000;
                    if ((fields & 0x10) != 0) {
                        this.setExpr = (CompiledSetExpression)MVEL.compileSetExpression(this.indexTarget);
                    }
                    this.name = new String(expr, 0, this.endOfName);
                    this.index = ParseTools.subset(this.indexTarget, this.endOfName, this.indexTarget.length - this.endOfName);
                }
                ParseTools.checkNameSafety(this.name);
            } else {
                this.name = new String(expr);
                ParseTools.checkNameSafety(this.name);
            }
        }
    }

    public AssignmentNode(char[] expr, int fields) {
        this(expr, fields, -1, null);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object o;
        if (this.setExpr == null) {
            this.setExpr = (CompiledSetExpression)MVEL.compileSetExpression(this.indexTarget);
        }
        if (this.col) {
            o = this.statement.getValue(ctx, thisValue, factory);
            this.setExpr.setValue(ctx, factory, o);
        } else if (this.statement != null) {
            o = this.statement.getValue(ctx, thisValue, factory);
            ParseTools.finalLocalVariableFactory(factory).createVariable(this.name, o);
        } else {
            factory.createVariable(this.name, null);
            return Void.class;
        }
        return o;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object o;
        ParseTools.checkNameSafety(this.name);
        if (this.col) {
            o = MVEL.eval(this.stmt, ctx, factory);
            MVEL.setProperty(factory.getVariableResolver(this.name).getValue(), new String(this.index), o);
        } else {
            o = MVEL.eval(this.stmt, ctx, factory);
            ParseTools.finalLocalVariableFactory(factory).createVariable(this.name, o);
        }
        return o;
    }

    public String getAssignmentVar() {
        return this.name;
    }
}

