/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.ErrorDetail;
import org.mvel.ast.LineLabel;
import org.mvel.integration.Interceptor;
import org.mvel.util.MethodStub;
import org.mvel.util.ParseTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserContext
implements Serializable {
    private String sourceFile;
    private int lineCount = 1;
    private int lineOffset;
    protected Map<String, Object> imports;
    protected Set<String> packageImports;
    protected Map<String, Interceptor> interceptors;
    private Map<String, Class> variables;
    private Map<String, Class> inputs;
    private List<ErrorDetail> errorList;
    private Map<String, Set<Integer>> sourceMap;
    private LineLabel lastLineLabel;
    private Object rootParser;
    private boolean compiled = false;
    private boolean strictTypeEnforcement = false;
    private boolean fatalError = false;
    private boolean retainParserState = false;
    private boolean debugSymbols = false;
    private boolean blockSymbols = false;
    private boolean executableCodeReached = false;

    public ParserContext() {
    }

    public ParserContext(boolean debugSymbols) {
        this.debugSymbols = debugSymbols;
    }

    public ParserContext(Object rootParser) {
        this.rootParser = rootParser;
    }

    public ParserContext(Map<String, Object> imports, Map<String, Interceptor> interceptors, String sourceFile) {
        this.setImports(imports);
        this.interceptors = interceptors;
        this.sourceFile = sourceFile;
    }

    public boolean hasVarOrInput(String name) {
        return this.variables != null && this.variables.containsKey(name) || this.inputs != null && this.inputs.containsKey(name);
    }

    public Class getVarOrInputType(String name) {
        if (this.variables != null && this.variables.containsKey(name)) {
            return this.variables.get(name);
        }
        if (this.inputs != null && this.inputs.containsKey(name)) {
            return this.inputs.get(name);
        }
        return Object.class;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int setLineCount(int lineCount) {
        this.lineCount = lineCount;
        return this.lineCount;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public void setLineOffset(int lineOffset) {
        this.lineOffset = lineOffset;
    }

    public void setLineAndOffset(int lineCount, int lineOffset) {
        this.lineCount = lineCount;
        this.lineOffset = lineOffset;
    }

    public Class getImport(String name) {
        return this.imports != null && this.imports.containsKey(name) ? (Class)this.imports.get(name) : (Class)AbstractParser.LITERALS.get(name);
    }

    public MethodStub getStaticImport(String name) {
        return this.imports != null ? (MethodStub)this.imports.get(name) : null;
    }

    public void addPackageImport(String packageName) {
        if (this.packageImports == null) {
            this.packageImports = new HashSet<String>();
        }
        this.packageImports.add(packageName);
    }

    private boolean checkForDynamicImport(String className) {
        if (this.packageImports == null) {
            return false;
        }
        int found = 0;
        Class<?> cls = null;
        for (String pkg : this.packageImports) {
            try {
                cls = Thread.currentThread().getContextClassLoader().loadClass(pkg + "." + className);
                ++found;
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                if (e.getMessage().contains("wrong name")) continue;
                throw e;
            }
        }
        if (found > 1) {
            throw new CompileException("ambiguous class name: " + className);
        }
        if (found == 1) {
            this.addImport(className, cls);
            return true;
        }
        return false;
    }

    public boolean hasImport(String name) {
        return this.imports != null && this.imports.containsKey(name) || !"this".equals(name) && !"self".equals(name) && !"empty".equals(name) && !"null".equals(name) && !"nil".equals(name) && !"true".equals(name) && !"false".equals(name) && AbstractParser.LITERALS.containsKey(name) || this.checkForDynamicImport(name);
    }

    public void addImport(Class cls) {
        this.addImport(ParseTools.getSimpleClassName(cls), cls);
    }

    public void addImport(String name, Class cls) {
        if (this.imports == null) {
            this.imports = new HashMap<String, Object>();
        }
        this.imports.put(name, cls);
    }

    public void addImport(String name, Method method) {
        this.addImport(name, new MethodStub(method));
    }

    public void addImport(String name, MethodStub method) {
        if (this.imports == null) {
            this.imports = new HashMap<String, Object>();
        }
        this.imports.put(name, method);
    }

    public void initializeTables() {
        if (this.variables == null) {
            this.variables = new HashMap<String, Class>();
        }
        if (this.inputs == null) {
            this.inputs = new HashMap<String, Class>();
        }
    }

    public void addVariable(String name, Class type) {
        if (this.variables.containsKey(name)) {
            return;
        }
        if (type == null) {
            type = Object.class;
        }
        this.variables.put(name, type);
    }

    public void addInput(String name, Class type) {
        if (this.inputs == null) {
            this.inputs = new HashMap<String, Class>();
        }
        if (this.inputs.containsKey(name)) {
            return;
        }
        if (type == null) {
            type = Object.class;
        }
        this.inputs.put(name, type);
    }

    public void processTables() {
        for (String name : this.variables.keySet()) {
            this.inputs.remove(name);
        }
    }

    public Map<String, Class> getInputs() {
        return this.inputs;
    }

    public void setInputs(Map<String, Class> inputs) {
        this.inputs = inputs;
    }

    public List<ErrorDetail> getErrorList() {
        return this.errorList;
    }

    public void setErrorList(List<ErrorDetail> errorList) {
        this.errorList = errorList;
    }

    public void addError(ErrorDetail errorDetail) {
        if (this.errorList == null) {
            this.errorList = new ArrayList<ErrorDetail>();
        }
        if (errorDetail.isCritical()) {
            this.fatalError = true;
        }
        this.errorList.add(errorDetail);
    }

    public boolean isFatalError() {
        return this.fatalError;
    }

    public void setFatalError(boolean fatalError) {
        this.fatalError = fatalError;
    }

    public boolean isStrictTypeEnforcement() {
        return this.strictTypeEnforcement;
    }

    public void setStrictTypeEnforcement(boolean strictTypeEnforcement) {
        this.strictTypeEnforcement = strictTypeEnforcement;
    }

    public boolean isRetainParserState() {
        return this.retainParserState;
    }

    public void setRetainParserState(boolean retainParserState) {
        this.retainParserState = retainParserState;
    }

    public Object getRootParser() {
        return this.rootParser;
    }

    public void setRootParser(Object rootParser) {
        this.rootParser = rootParser;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        if (sourceFile != null) {
            this.sourceFile = sourceFile;
        }
    }

    public Map<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(Map<String, Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public Map<String, Object> getImports() {
        return this.imports;
    }

    public void setImports(Map<String, Object> imports) {
        if (imports == null) {
            return;
        }
        for (String name : imports.keySet()) {
            Object val = imports.get(name);
            if (val instanceof Class) {
                this.addImport(name, (Class)val);
                continue;
            }
            if (val instanceof Method) {
                this.addImport(name, (Method)val);
                continue;
            }
            if (val instanceof MethodStub) {
                this.addImport(name, (MethodStub)val);
                continue;
            }
            throw new RuntimeException("invalid element in imports map: " + name + " (" + val + ")");
        }
    }

    public Map<String, Class> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Class> variables) {
        this.variables = variables;
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public void setCompiled(boolean compiled) {
        this.compiled = compiled;
    }

    public boolean isDebugSymbols() {
        return this.debugSymbols;
    }

    public void setDebugSymbols(boolean debugSymbols) {
        this.debugSymbols = debugSymbols;
    }

    public boolean isKnownLine(String sourceName, int lineNumber) {
        return this.sourceMap != null && this.sourceMap.containsKey(sourceName) && this.sourceMap.get(sourceName).contains(lineNumber);
    }

    public void addKnownLine(String sourceName, int lineNumber) {
        if (this.sourceMap == null) {
            this.sourceMap = new HashMap<String, Set<Integer>>();
        }
        if (!this.sourceMap.containsKey(sourceName)) {
            this.sourceMap.put(sourceName, new HashSet());
        }
        this.sourceMap.get(sourceName).add(lineNumber);
    }

    public void addKnownLine(int lineNumber) {
        this.addKnownLine(this.sourceFile, lineNumber);
    }

    public LineLabel getLastLineLabel() {
        return this.lastLineLabel;
    }

    public LineLabel setLastLineLabel(LineLabel lastLineLabel) {
        this.lastLineLabel = lastLineLabel;
        return this.lastLineLabel;
    }

    public boolean hasImports() {
        return this.imports != null && this.imports.size() != 0 || this.packageImports != null && this.packageImports.size() != 0;
    }

    public boolean isBlockSymbols() {
        return this.blockSymbols;
    }

    public void setBlockSymbols(boolean blockSymbols) {
        this.blockSymbols = blockSymbols;
    }

    public boolean isExecutableCodeReached() {
        return this.executableCodeReached;
    }

    public void setExecutableCodeReached(boolean executableCodeReached) {
        this.executableCodeReached = executableCodeReached;
    }
}

