/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.mvel.ConversionHandler;
import org.mvel.conversion.BigDecimalCH;
import org.mvel.conversion.BigIntegerCH;
import org.mvel.conversion.BooleanCH;
import org.mvel.conversion.ByteCH;
import org.mvel.conversion.CharArrayCH;
import org.mvel.conversion.CharCH;
import org.mvel.conversion.DoubleCH;
import org.mvel.conversion.FloatCH;
import org.mvel.conversion.IntArrayCH;
import org.mvel.conversion.IntegerCH;
import org.mvel.conversion.LongCH;
import org.mvel.conversion.ObjectCH;
import org.mvel.conversion.PrimArrayHandler;
import org.mvel.conversion.ShortCH;
import org.mvel.conversion.StringArrayCH;
import org.mvel.conversion.StringCH;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataConversion {
    private static final Map<Class, ConversionHandler> CONVERTERS = new HashMap<Class, ConversionHandler>();

    public static boolean canConvert(Class toType, Class convertFrom) {
        return CONVERTERS.containsKey(toType) && CONVERTERS.get(toType).canConvertFrom(convertFrom) || toType.isAssignableFrom(convertFrom);
    }

    public static <T> T convert(Object in, Class<T> toType) {
        if (in == null) {
            return null;
        }
        if (toType == in.getClass() || toType.isAssignableFrom(in.getClass())) {
            return (T)in;
        }
        return (T)CONVERTERS.get(toType).convertFrom(in);
    }

    public static void addConversionHandler(Class type, ConversionHandler handler) {
        CONVERTERS.put(type, handler);
    }

    static {
        ConversionHandler ch = new IntegerCH();
        CONVERTERS.put(Integer.class, ch);
        CONVERTERS.put(Integer.TYPE, ch);
        ch = new ShortCH();
        CONVERTERS.put(Short.class, ch);
        CONVERTERS.put(Short.TYPE, ch);
        ch = new LongCH();
        CONVERTERS.put(Long.class, ch);
        CONVERTERS.put(Long.TYPE, ch);
        ch = new CharCH();
        CONVERTERS.put(Character.class, ch);
        CONVERTERS.put(Character.TYPE, ch);
        ch = new ByteCH();
        CONVERTERS.put(Byte.class, ch);
        CONVERTERS.put(Byte.TYPE, ch);
        ch = new FloatCH();
        CONVERTERS.put(Float.class, ch);
        CONVERTERS.put(Float.TYPE, ch);
        ch = new DoubleCH();
        CONVERTERS.put(Double.class, ch);
        CONVERTERS.put(Double.TYPE, ch);
        ch = new BooleanCH();
        CONVERTERS.put(Boolean.class, ch);
        CONVERTERS.put(Boolean.TYPE, ch);
        CONVERTERS.put(String.class, new StringCH());
        CONVERTERS.put(Object.class, new ObjectCH());
        CONVERTERS.put(char[].class, new CharArrayCH());
        CONVERTERS.put(String[].class, new StringArrayCH());
        CONVERTERS.put(Integer[].class, new IntArrayCH());
        CONVERTERS.put(int[].class, new PrimArrayHandler(int[].class));
        CONVERTERS.put(long[].class, new PrimArrayHandler(long[].class));
        CONVERTERS.put(double[].class, new PrimArrayHandler(double[].class));
        CONVERTERS.put(float[].class, new PrimArrayHandler(float[].class));
        CONVERTERS.put(short[].class, new PrimArrayHandler(short[].class));
        CONVERTERS.put(boolean[].class, new PrimArrayHandler(boolean[].class));
        CONVERTERS.put(BigDecimal.class, new BigDecimalCH());
        CONVERTERS.put(BigInteger.class, new BigIntegerCH());
    }
}

